/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.servicedomain;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import com.helger.peppol.servicedomain.EPeppolNetwork;
import com.helger.peppol.utils.PeppolCAChecker;
import com.helger.peppol.utils.PeppolCertificateChecker;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EPeppolServiceDomain implements IHasID<String>
{
    POST_AWARD("post-award", PeppolCertificateChecker.peppolTestAP(), PeppolCertificateChecker.peppolProductionAP(), PeppolCertificateChecker.peppolTestSMP(), PeppolCertificateChecker.peppolProductionSMP()),
    PRE_AWARD("pre-award", PeppolCertificateChecker.peppolTestAP(), PeppolCertificateChecker.peppolProductionAP(), PeppolCertificateChecker.peppolTestSMP(), PeppolCertificateChecker.peppolProductionSMP()),
    ENHANCED_B2B("eb2b", PeppolCertificateChecker.peppolTestEb2bAP(), null, PeppolCertificateChecker.peppolTestSMP(), null);

    private final String m_sID;
    private final PeppolCAChecker m_aTestAPChecker;
    private final PeppolCAChecker m_aProdAPChecker;
    private final PeppolCAChecker m_aTestSMPChecker;
    private final PeppolCAChecker m_aProdSMPChecker;

    private EPeppolServiceDomain(@Nullable String string2, @Nullable PeppolCAChecker peppolCAChecker, @Nullable PeppolCAChecker peppolCAChecker2, PeppolCAChecker peppolCAChecker3, PeppolCAChecker peppolCAChecker4) {
        this.m_sID = string2;
        this.m_aTestAPChecker = peppolCAChecker;
        this.m_aProdAPChecker = peppolCAChecker2;
        this.m_aTestSMPChecker = peppolCAChecker3;
        this.m_aProdSMPChecker = peppolCAChecker4;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nullable
    public PeppolCAChecker getTestAPChecker() {
        return this.m_aTestAPChecker;
    }

    @Nullable
    public PeppolCAChecker getProdAPChecker() {
        return this.m_aProdAPChecker;
    }

    @Nullable
    public PeppolCAChecker getAPChecker(@Nonnull EPeppolNetwork ePeppolNetwork) {
        return ePeppolNetwork.isTest() ? this.m_aTestAPChecker : this.m_aProdAPChecker;
    }

    @Nullable
    public PeppolCAChecker getTestSMPChecker() {
        return this.m_aTestSMPChecker;
    }

    @Nullable
    public PeppolCAChecker getProdSMPChecker() {
        return this.m_aProdSMPChecker;
    }

    @Nullable
    public PeppolCAChecker getSMPChecker(@Nonnull EPeppolNetwork ePeppolNetwork) {
        return ePeppolNetwork.isTest() ? this.m_aTestSMPChecker : this.m_aProdSMPChecker;
    }

    @Nullable
    public static EPeppolServiceDomain getFromIDOrNull(@Nullable String string) {
        return (EPeppolServiceDomain)EnumHelper.getFromIDOrNull(EPeppolServiceDomain.class, (Object)string);
    }
}

