/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.smp;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.type.ObjectType;
import com.helger.peppol.smp.ESMPTransportProfileState;
import com.helger.peppol.smp.ISMPTransportProfile;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SMPTransportProfile
implements ISMPTransportProfile,
ICloneable<SMPTransportProfile> {
    public static final ObjectType OT = new ObjectType("smp.transport.profile");
    public static final ESMPTransportProfileState DEFAULT_STATE = ESMPTransportProfileState.ACTIVE;
    private final String m_sID;
    private String m_sName;
    private ESMPTransportProfileState m_eState;

    @Nonnull
    static ESMPTransportProfileState internalGetDeprecatedState(boolean bl) {
        return bl ? ESMPTransportProfileState.DEPRECATED : ESMPTransportProfileState.ACTIVE;
    }

    public SMPTransportProfile(@Nonnull ISMPTransportProfile iSMPTransportProfile) {
        this(iSMPTransportProfile.getID(), iSMPTransportProfile.getName(), iSMPTransportProfile.getState());
    }

    public SMPTransportProfile(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        this(string, string2, DEFAULT_STATE);
    }

    public SMPTransportProfile(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull ESMPTransportProfileState eSMPTransportProfileState) {
        this.m_sID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"ID");
        this.setName(string2);
        this.setState(eSMPTransportProfileState);
    }

    @Nonnull
    public ObjectType getObjectType() {
        return OT;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Nonnull
    public final EChange setName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        if (string.equals(this.m_sName)) {
            return EChange.UNCHANGED;
        }
        this.m_sName = string;
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public ESMPTransportProfileState getState() {
        return this.m_eState;
    }

    @Nonnull
    public final EChange setState(@Nonnull ESMPTransportProfileState eSMPTransportProfileState) {
        ValueEnforcer.notNull((Object)((Object)eSMPTransportProfileState), (String)"State");
        if (eSMPTransportProfileState.equals((Object)this.m_eState)) {
            return EChange.UNCHANGED;
        }
        this.m_eState = eSMPTransportProfileState;
        return EChange.CHANGED;
    }

    @Nonnull
    public SMPTransportProfile getClone() {
        return new SMPTransportProfile(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SMPTransportProfile sMPTransportProfile = (SMPTransportProfile)object;
        return this.m_sID.equals(sMPTransportProfile.m_sID);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sID).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ID", (Object)this.m_sID).append("Name", (Object)this.m_sName).append("State", (Enum)this.m_eState).getToString();
    }
}

