/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.utils;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.state.EChange;
import com.helger.commons.state.ETriState;
import com.helger.peppol.utils.EPeppolCertificateCheckResult;
import com.helger.peppol.utils.PeppolCertificateChecker;
import com.helger.peppol.utils.RevocationCheckBuilder;
import com.helger.security.certificate.TrustedCACertificates;
import com.helger.security.revocation.CertificateRevocationCheckerDefaults;
import com.helger.security.revocation.ERevocationCheckMode;
import com.helger.security.revocation.RevocationCheckResultCache;
import java.security.cert.X509Certificate;
import java.time.OffsetDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.x500.X500Principal;

public final class PeppolCAChecker {
    private final TrustedCACertificates m_aTrustedCAs = new TrustedCACertificates();
    private final RevocationCheckResultCache m_aRevocationCache;

    public PeppolCAChecker(X509Certificate ... x509CertificateArray) {
        ValueEnforcer.notNullNoNullValue((Object[])x509CertificateArray, (String)"CACerts");
        for (X509Certificate x509Certificate2 : x509CertificateArray) {
            this.m_aTrustedCAs.addTrustedCACertificate(x509Certificate2);
        }
        this.m_aRevocationCache = new RevocationCheckResultCache(x509Certificate -> ((RevocationCheckBuilder)((RevocationCheckBuilder)((RevocationCheckBuilder)new RevocationCheckBuilder().certificate((X509Certificate)x509Certificate)).validCAs(x509CertificateArray)).checkMode(CertificateRevocationCheckerDefaults.getRevocationCheckMode())).build(), CertificateRevocationCheckerDefaults.DEFAULT_REVOCATION_CHECK_CACHING_DURATION);
    }

    @Nonnull
    @ReturnsMutableCopy
    public TrustedCACertificates getAllTrustedAPCertificates() {
        return new TrustedCACertificates(this.m_aTrustedCAs);
    }

    @Nonnull
    public RevocationCheckResultCache getRevocationCache() {
        return this.m_aRevocationCache;
    }

    @Nonnull
    public EChange clearRevocationCache() {
        return this.m_aRevocationCache.clearCache();
    }

    @Nonnull
    public EPeppolCertificateCheckResult checkCertificate(@Nullable X509Certificate x509Certificate) {
        return this.checkCertificate(x509Certificate, null);
    }

    @Nonnull
    public EPeppolCertificateCheckResult checkCertificate(@Nullable X509Certificate x509Certificate, @Nullable OffsetDateTime offsetDateTime) {
        return this.checkCertificate(x509Certificate, offsetDateTime, ETriState.UNDEFINED, null);
    }

    @Nonnull
    public EPeppolCertificateCheckResult checkCertificate(@Nullable X509Certificate x509Certificate, @Nullable OffsetDateTime offsetDateTime, @Nonnull ETriState eTriState, @Nullable ERevocationCheckMode eRevocationCheckMode) {
        boolean bl = eTriState.isUndefined() ? CertificateRevocationCheckerDefaults.isCacheRevocationCheckResults() : eTriState.isTrue();
        return PeppolCertificateChecker.checkCertificate((ICommonsSet<X500Principal>)this.m_aTrustedCAs.getAllTrustedCAIssuers(), bl && offsetDateTime == null ? this.m_aRevocationCache : null, ((RevocationCheckBuilder)((RevocationCheckBuilder)((RevocationCheckBuilder)new RevocationCheckBuilder().certificate(x509Certificate)).checkDate(offsetDateTime)).validCAs((Iterable)this.m_aTrustedCAs.getAllTrustedCACertificates())).checkMode(eRevocationCheckMode));
    }
}

