/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.utils;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.peppol.utils.EPeppolCertificateCheckResult;
import com.helger.peppol.utils.PeppolCAChecker;
import com.helger.peppol.utils.PeppolKeyStoreHelper;
import com.helger.security.revocation.AbstractRevocationCheckBuilder;
import com.helger.security.revocation.RevocationCheckResultCache;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class PeppolCertificateChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeppolCertificateChecker.class);
    private static final PeppolCAChecker TEST_AP = new PeppolCAChecker(PeppolKeyStoreHelper.Config2018.CERTIFICATE_PILOT_AP);
    private static final PeppolCAChecker PROD_AP = new PeppolCAChecker(PeppolKeyStoreHelper.Config2018.CERTIFICATE_PRODUCTION_AP);
    private static final PeppolCAChecker ALL_AP = new PeppolCAChecker(PeppolKeyStoreHelper.Config2018.CERTIFICATE_PILOT_AP, PeppolKeyStoreHelper.Config2018.CERTIFICATE_PRODUCTION_AP);
    private static final PeppolCAChecker TEST_SMP = new PeppolCAChecker(PeppolKeyStoreHelper.Config2018.CERTIFICATE_PILOT_SMP);
    private static final PeppolCAChecker PROD_SMP = new PeppolCAChecker(PeppolKeyStoreHelper.Config2018.CERTIFICATE_PRODUCTION_SMP);
    private static final PeppolCAChecker ALL_SMP = new PeppolCAChecker(PeppolKeyStoreHelper.Config2018.CERTIFICATE_PILOT_SMP, PeppolKeyStoreHelper.Config2018.CERTIFICATE_PRODUCTION_SMP);
    private static final PeppolCAChecker TEST_EB2B_AP = new PeppolCAChecker(PeppolKeyStoreHelper.Config2018.CERTIFICATE_PILOT_EB2B_AP);
    private static final PeppolCAChecker PROD_EB2B_AP = new PeppolCAChecker(PeppolKeyStoreHelper.Config2018.CERTIFICATE_PRODUCTION_EB2B_AP);

    private PeppolCertificateChecker() {
    }

    @Nonnull
    public static PeppolCAChecker peppolTestAP() {
        return TEST_AP;
    }

    @Nonnull
    public static PeppolCAChecker peppolProductionAP() {
        return PROD_AP;
    }

    @Nonnull
    public static PeppolCAChecker peppolAllAP() {
        return ALL_AP;
    }

    @Nonnull
    public static PeppolCAChecker peppolTestSMP() {
        return TEST_SMP;
    }

    @Nonnull
    public static PeppolCAChecker peppolProductionSMP() {
        return PROD_SMP;
    }

    @Nonnull
    public static PeppolCAChecker peppolAllSMP() {
        return ALL_SMP;
    }

    @Nonnull
    public static PeppolCAChecker peppolTestEb2bAP() {
        return TEST_EB2B_AP;
    }

    @Nonnull
    public static PeppolCAChecker peppolProductionEb2bAP() {
        return PROD_EB2B_AP;
    }

    public static void clearRevocationCheckCache() {
        TEST_AP.clearRevocationCache();
        PROD_AP.clearRevocationCache();
        ALL_AP.clearRevocationCache();
        TEST_SMP.clearRevocationCache();
        PROD_SMP.clearRevocationCache();
        ALL_SMP.clearRevocationCache();
        TEST_EB2B_AP.clearRevocationCache();
        PROD_EB2B_AP.clearRevocationCache();
        LOGGER.info("The PeppolCertificateChecker revocation cache was cleared");
    }

    @Nonnull
    public static EPeppolCertificateCheckResult checkCertificate(@Nullable ICommonsSet<X500Principal> iCommonsSet, @Nullable RevocationCheckResultCache revocationCheckResultCache, @Nonnull AbstractRevocationCheckBuilder<?> abstractRevocationCheckBuilder) {
        X509Certificate x509Certificate;
        ValueEnforcer.notNull(abstractRevocationCheckBuilder, (String)"RevocationChecker");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Running Peppol Certificate Check" + (String)(iCommonsSet != null ? " against a list of " + iCommonsSet.size() + " certificate issuers" : "") + (revocationCheckResultCache != null ? "; a cache is provided" : "; not using a cache"));
        }
        if ((x509Certificate = abstractRevocationCheckBuilder.certificate()) == null) {
            LOGGER.warn("No Peppol Certificate was provided to the certificate check");
            return EPeppolCertificateCheckResult.NO_CERTIFICATE_PROVIDED;
        }
        Date date = abstractRevocationCheckBuilder.checkDate();
        try {
            if (date == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Checking the Peppol Certificate validity against the current date time");
                }
                x509Certificate.checkValidity();
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Checking the Peppol Certificate validity against the provided date time " + String.valueOf(date));
                }
                x509Certificate.checkValidity(date);
            }
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            LOGGER.warn("The provided Peppol Certificate is not yet valid per " + (date == null ? "now" : date.toString()));
            return EPeppolCertificateCheckResult.NOT_YET_VALID;
        }
        catch (CertificateExpiredException certificateExpiredException) {
            LOGGER.warn("The provided Peppol Certificate is expired per " + (date == null ? "now" : date.toString()));
            return EPeppolCertificateCheckResult.EXPIRED;
        }
        if (iCommonsSet != null) {
            X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
            if (!iCommonsSet.contains((Object)x500Principal)) {
                LOGGER.warn("The provided Peppol Certificate issuer '" + String.valueOf(x500Principal) + "' is not in the list of trusted issuers " + String.valueOf(iCommonsSet));
                return EPeppolCertificateCheckResult.UNSUPPORTED_ISSUER;
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Not testing against known Peppol Certificate issuers");
        }
        if (revocationCheckResultCache != null) {
            boolean bl;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Testing if the Peppol Certificate is revoked, using a cache");
            }
            if (bl = revocationCheckResultCache.isRevoked(x509Certificate)) {
                LOGGER.warn("The Peppol Certificate is revoked [caching used]");
                return EPeppolCertificateCheckResult.REVOKED;
            }
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Testing if the Peppol Certificate is revoked, without a cache");
            }
            if (abstractRevocationCheckBuilder.build().isRevoked()) {
                LOGGER.warn("The Peppol Certificate is revoked [no caching]");
                return EPeppolCertificateCheckResult.REVOKED;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("The Peppol Certificate seems to be valid");
        }
        return EPeppolCertificateCheckResult.VALID;
    }
}

