/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.utils;

import com.helger.commons.ValueEnforcer;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.x500.X500Principal;

@Immutable
public final class PeppolCertificateHelper {
    public static final String PRINCIPAL_TYPE_CN = "CN";
    public static final String PRINCIPAL_TYPE_O = "O";

    private PeppolCertificateHelper() {
    }

    @Nullable
    public static String getSubjectCN(@Nullable X509Certificate x509Certificate) {
        return x509Certificate != null ? PeppolCertificateHelper.getCNOrNull(x509Certificate.getSubjectX500Principal()) : null;
    }

    @Nullable
    public static String getCNOrNull(@Nullable X500Principal x500Principal) {
        return x500Principal != null ? PeppolCertificateHelper.getCNOrNull(x500Principal.getName()) : null;
    }

    @Nullable
    public static String getCNOrNull(@Nullable String string) {
        try {
            return PeppolCertificateHelper.getCN(string);
        }
        catch (InvalidNameException invalidNameException) {
            return null;
        }
    }

    @Nullable
    public static String getPrincipalTypeValue(@Nullable String string, @Nonnull String string2) throws InvalidNameException {
        ValueEnforcer.notNull((Object)string2, (String)"Type");
        if (string != null) {
            for (Rdn rdn : new LdapName(string).getRdns()) {
                if (!rdn.getType().equalsIgnoreCase(string2)) continue;
                return (String)rdn.getValue();
            }
        }
        return null;
    }

    @Nullable
    public static String getCN(@Nullable String string) throws InvalidNameException {
        return PeppolCertificateHelper.getPrincipalTypeValue(string, PRINCIPAL_TYPE_CN);
    }
}

