/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.utils;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.text.util.TextHelper;
import com.helger.security.keystore.EKeyStoreType;
import com.helger.security.keystore.IKeyStoreType;
import com.helger.security.keystore.ITrustStoreDescriptor;
import com.helger.security.keystore.LoadedKey;
import com.helger.security.keystore.LoadedKeyStore;
import com.helger.security.keystore.TrustStoreDescriptor;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class PeppolKeyStoreHelper {
    public static final EKeyStoreType TRUSTSTORE_TYPE = EKeyStoreType.JKS;
    public static final String TRUSTSTORE_COMPLETE_CLASSPATH = "truststore/complete-truststore.jks";
    public static final String TRUSTSTORE_PASSWORD = "peppol";
    private static final Logger LOGGER = LoggerFactory.getLogger(PeppolKeyStoreHelper.class);
    private static final PeppolKeyStoreHelper INSTANCE = new PeppolKeyStoreHelper();

    @Nullable
    private static X509Certificate _resolveCert(@Nonnull KeyStore keyStore, @Nonnull @Nonempty String string) {
        try {
            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
            if (x509Certificate == null) {
                LOGGER.warn("Failed to resolve alias '" + string + "' in trust store");
            }
            return x509Certificate;
        }
        catch (KeyStoreException keyStoreException) {
            LOGGER.warn("Failed to resolve alias '" + string + "' in trust store.", (Throwable)keyStoreException);
            return null;
        }
    }

    private PeppolKeyStoreHelper() {
    }

    @Nullable
    public static String getLoadError(@Nonnull LoadedKeyStore loadedKeyStore) {
        return loadedKeyStore == null ? null : loadedKeyStore.getErrorText(TextHelper.EN);
    }

    @Nullable
    public static String getLoadError(@Nonnull LoadedKey<?> loadedKey) {
        return loadedKey == null ? null : loadedKey.getErrorText(TextHelper.EN);
    }

    @Immutable
    public static final class Config2018 {
        public static final String TRUSTSTORE_AP_PRODUCTION_CLASSPATH = "truststore/2018/prod-truststore.jks";
        public static final ITrustStoreDescriptor TRUSTSTORE_DESCRIPTOR_AP_PRODUCTION = TrustStoreDescriptor.builder().type((IKeyStoreType)TRUSTSTORE_TYPE).path("truststore/2018/prod-truststore.jks").password("peppol").build();
        public static final KeyStore TRUSTSTORE_AP_PRODUCTION = TRUSTSTORE_DESCRIPTOR_AP_PRODUCTION.loadTrustStore().getKeyStore();
        public static final String TRUSTSTORE_SMP_PRODUCTION_CLASSPATH = "truststore/2018/smp-prod-truststore.jks";
        public static final ITrustStoreDescriptor TRUSTSTORE_DESCRIPTOR_SMP_PRODUCTION;
        public static final KeyStore TRUSTSTORE_SMP_PRODUCTION;
        public static final String TRUSTSTORE_EB2B_AP_PRODUCTION_CLASSPATH = "truststore/2018/eb2b-ap-prod-truststore.jks";
        public static final ITrustStoreDescriptor TRUSTSTORE_DESCRIPTOR_EB2B_AP_PRODUCTION;
        public static final KeyStore TRUSTSTORE_EB2B_AP_PRODUCTION;
        public static final String TRUSTSTORE_PRODUCTION_ALIAS_ROOT = "peppol root ca - g2";
        public static final X509Certificate CERTIFICATE_PRODUCTION_ROOT;
        public static final String TRUSTSTORE_PRODUCTION_ALIAS_AP = "peppol access point ca - g2 (peppol root ca - g2)";
        public static final X509Certificate CERTIFICATE_PRODUCTION_AP;
        public static final String TRUSTSTORE_PRODUCTION_ALIAS_SMP = "peppol service metadata publisher ca - g2 (peppol root ca - g2)";
        public static final X509Certificate CERTIFICATE_PRODUCTION_SMP;
        public static final String TRUSTSTORE_PRODUCTION_ALIAS_EB2B_AP = "peppol eb2b access point ca - g2 (peppol root ca - g2)";
        public static final X509Certificate CERTIFICATE_PRODUCTION_EB2B_AP;
        public static final String TRUSTSTORE_AP_PILOT_CLASSPATH = "truststore/2018/pilot-truststore.jks";
        public static final ITrustStoreDescriptor TRUSTSTORE_DESCRIPTOR_AP_PILOT;
        public static final KeyStore TRUSTSTORE_AP_PILOT;
        public static final String TRUSTSTORE_SMP_PILOT_CLASSPATH = "truststore/2018/smp-pilot-truststore.jks";
        public static final ITrustStoreDescriptor TRUSTSTORE_DESCRIPTOR_SMP_PILOT;
        public static final KeyStore TRUSTSTORE_SMP_PILOT;
        public static final String TRUSTSTORE_EB2B_AP_PILOT_CLASSPATH = "truststore/2018/eb2b-ap-pilot-truststore.jks";
        public static final ITrustStoreDescriptor TRUSTSTORE_DESCRIPTOR_EB2B_AP_PILOT;
        public static final KeyStore TRUSTSTORE_EB2B_AP_PILOT;
        public static final String TRUSTSTORE_PILOT_ALIAS_ROOT = "peppol root test ca - g2";
        public static final X509Certificate CERTIFICATE_PILOT_ROOT;
        public static final String TRUSTSTORE_PILOT_ALIAS_AP = "peppol access point test ca - g2 (peppol root test ca - g2)";
        public static final X509Certificate CERTIFICATE_PILOT_AP;
        public static final String TRUSTSTORE_PILOT_ALIAS_SMP = "peppol service metadata publisher test ca - g2 (peppol root test ca - g2)";
        public static final X509Certificate CERTIFICATE_PILOT_SMP;
        public static final String TRUSTSTORE_PILOT_ALIAS_EB2B_AP = "peppol eb2b access point test ca - g2 (peppol root test ca - g2)";
        public static final X509Certificate CERTIFICATE_PILOT_EB2B_AP;

        private Config2018() {
        }

        static {
            if (TRUSTSTORE_AP_PRODUCTION == null) {
                throw new IllegalStateException("Failed to load pre-configured production AP trust store");
            }
            TRUSTSTORE_DESCRIPTOR_SMP_PRODUCTION = TrustStoreDescriptor.builder().type((IKeyStoreType)TRUSTSTORE_TYPE).path(TRUSTSTORE_SMP_PRODUCTION_CLASSPATH).password(PeppolKeyStoreHelper.TRUSTSTORE_PASSWORD).build();
            TRUSTSTORE_SMP_PRODUCTION = TRUSTSTORE_DESCRIPTOR_SMP_PRODUCTION.loadTrustStore().getKeyStore();
            if (TRUSTSTORE_SMP_PRODUCTION == null) {
                throw new IllegalStateException("Failed to load pre-configured SMP production trust store");
            }
            TRUSTSTORE_DESCRIPTOR_EB2B_AP_PRODUCTION = TrustStoreDescriptor.builder().type((IKeyStoreType)TRUSTSTORE_TYPE).path(TRUSTSTORE_EB2B_AP_PRODUCTION_CLASSPATH).password(PeppolKeyStoreHelper.TRUSTSTORE_PASSWORD).build();
            TRUSTSTORE_EB2B_AP_PRODUCTION = TRUSTSTORE_DESCRIPTOR_EB2B_AP_PRODUCTION.loadTrustStore().getKeyStore();
            if (TRUSTSTORE_EB2B_AP_PRODUCTION == null) {
                throw new IllegalStateException("Failed to load pre-configured production eB2B AP trust store");
            }
            CERTIFICATE_PRODUCTION_ROOT = PeppolKeyStoreHelper._resolveCert(TRUSTSTORE_AP_PRODUCTION, TRUSTSTORE_PRODUCTION_ALIAS_ROOT);
            CERTIFICATE_PRODUCTION_AP = PeppolKeyStoreHelper._resolveCert(TRUSTSTORE_AP_PRODUCTION, TRUSTSTORE_PRODUCTION_ALIAS_AP);
            CERTIFICATE_PRODUCTION_SMP = PeppolKeyStoreHelper._resolveCert(TRUSTSTORE_AP_PRODUCTION, TRUSTSTORE_PRODUCTION_ALIAS_SMP);
            CERTIFICATE_PRODUCTION_EB2B_AP = PeppolKeyStoreHelper._resolveCert(TRUSTSTORE_EB2B_AP_PRODUCTION, TRUSTSTORE_PRODUCTION_ALIAS_EB2B_AP);
            TRUSTSTORE_DESCRIPTOR_AP_PILOT = TrustStoreDescriptor.builder().type((IKeyStoreType)TRUSTSTORE_TYPE).path(TRUSTSTORE_AP_PILOT_CLASSPATH).password(PeppolKeyStoreHelper.TRUSTSTORE_PASSWORD).build();
            TRUSTSTORE_AP_PILOT = TRUSTSTORE_DESCRIPTOR_AP_PILOT.loadTrustStore().getKeyStore();
            if (TRUSTSTORE_AP_PILOT == null) {
                throw new IllegalStateException("Failed to load pre-configured AP pilot trust store");
            }
            TRUSTSTORE_DESCRIPTOR_SMP_PILOT = TrustStoreDescriptor.builder().type((IKeyStoreType)TRUSTSTORE_TYPE).path(TRUSTSTORE_SMP_PILOT_CLASSPATH).password(PeppolKeyStoreHelper.TRUSTSTORE_PASSWORD).build();
            TRUSTSTORE_SMP_PILOT = TRUSTSTORE_DESCRIPTOR_SMP_PILOT.loadTrustStore().getKeyStore();
            if (TRUSTSTORE_SMP_PILOT == null) {
                throw new IllegalStateException("Failed to load pre-configured SMP pilot trust store");
            }
            TRUSTSTORE_DESCRIPTOR_EB2B_AP_PILOT = TrustStoreDescriptor.builder().type((IKeyStoreType)TRUSTSTORE_TYPE).path(TRUSTSTORE_EB2B_AP_PILOT_CLASSPATH).password(PeppolKeyStoreHelper.TRUSTSTORE_PASSWORD).build();
            TRUSTSTORE_EB2B_AP_PILOT = TRUSTSTORE_DESCRIPTOR_EB2B_AP_PILOT.loadTrustStore().getKeyStore();
            if (TRUSTSTORE_EB2B_AP_PILOT == null) {
                throw new IllegalStateException("Failed to load pre-configured pilot eB2B AP trust store");
            }
            CERTIFICATE_PILOT_ROOT = PeppolKeyStoreHelper._resolveCert(TRUSTSTORE_AP_PILOT, TRUSTSTORE_PILOT_ALIAS_ROOT);
            CERTIFICATE_PILOT_AP = PeppolKeyStoreHelper._resolveCert(TRUSTSTORE_AP_PILOT, TRUSTSTORE_PILOT_ALIAS_AP);
            CERTIFICATE_PILOT_SMP = PeppolKeyStoreHelper._resolveCert(TRUSTSTORE_AP_PILOT, TRUSTSTORE_PILOT_ALIAS_SMP);
            CERTIFICATE_PILOT_EB2B_AP = PeppolKeyStoreHelper._resolveCert(TRUSTSTORE_EB2B_AP_PILOT, TRUSTSTORE_PILOT_ALIAS_EB2B_AP);
        }
    }
}

