/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.servicedomain;

import com.helger.annotation.Nonempty;
import com.helger.base.id.IHasID;
import com.helger.base.lang.EnumHelper;
import com.helger.base.name.IHasDisplayName;
import com.helger.peppol.sml.ESML;
import com.helger.peppol.sml.ISMLInfo;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public enum EPeppolNetwork implements IHasID<String>,
IHasDisplayName
{
    TEST("test", "Peppol Test Network", "https://test-directory.peppol.eu", ESML.DIGIT_TEST),
    PRODUCTION("prod", "Peppol Production Network", "https://directory.peppol.eu", ESML.DIGIT_PRODUCTION);

    private final String m_sID;
    private final String m_sDisplayName;
    private final String m_sDirectoryURL;
    private final ISMLInfo m_aSMLInfo;

    private EPeppolNetwork(@Nonnull @Nonempty String string2, @Nonnull String string3, String string4, ISMLInfo iSMLInfo) {
        this.m_sID = string2;
        this.m_sDisplayName = string3;
        this.m_sDirectoryURL = string4;
        this.m_aSMLInfo = iSMLInfo;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    @Nonempty
    public String getDisplayName() {
        return this.m_sDisplayName;
    }

    @Nonnull
    @Nonempty
    public String getDirectoryURL() {
        return this.m_sDirectoryURL;
    }

    @Nonnull
    public ISMLInfo getSMLInfo() {
        return this.m_aSMLInfo;
    }

    public boolean isProduction() {
        return this == PRODUCTION;
    }

    public boolean isTest() {
        return this == TEST;
    }

    @Nullable
    public static EPeppolNetwork getFromIDOrNull(@Nullable String string) {
        return (EPeppolNetwork)EnumHelper.getFromIDOrNull(EPeppolNetwork.class, (Object)string);
    }
}

