/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.MustImplementEqualsAndHashcode;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.string.StringHelper;
import com.helger.peppolid.CIdentifier;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;

@MustImplementEqualsAndHashcode
public interface IIdentifier
extends Serializable {
    @Nonnull
    public String getScheme();

    default public boolean hasScheme() {
        return this.getScheme() != null;
    }

    default public boolean hasScheme(@Nullable String string) {
        return EqualsHelper.equals((Object)this.getScheme(), (Object)string);
    }

    @Nonnull
    public String getValue();

    default public boolean hasValue() {
        return StringHelper.isNotEmpty((String)this.getValue());
    }

    default public boolean hasValue(@Nullable String string) {
        return EqualsHelper.equals((Object)this.getValue(), (Object)string);
    }

    @Nonnull
    @Nonempty
    default public String getURIEncoded() {
        return CIdentifier.getURIEncoded(this);
    }

    @Nonnull
    default public String getURIPercentEncoded() {
        return CIdentifier.getURIPercentEncoded(this);
    }
}

