/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.peppol.doctype;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.misc.DevelopersNote;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.clone.ICloneable;
import com.helger.base.compare.CompareHelper;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IMutableIdentifier;
import com.helger.peppolid.factory.IIdentifierFactory;
import com.helger.peppolid.peppol.IPeppolIdentifier;
import com.helger.peppolid.peppol.doctype.IPeppolGenericDocumentTypeIdentifierParts;
import com.helger.peppolid.peppol.doctype.PeppolGenericDocumentTypeIdentifierParts;
import com.helger.xsds.peppol.id1.DocumentIdentifierType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public class PeppolDocumentTypeIdentifier
extends DocumentIdentifierType
implements IPeppolIdentifier,
IMutableIdentifier,
IDocumentTypeIdentifier,
Comparable<PeppolDocumentTypeIdentifier>,
ICloneable<PeppolDocumentTypeIdentifier> {
    @Nonnull
    private static String _verifyScheme(@Nonnull IIdentifierFactory iIdentifierFactory, @Nullable String string) {
        if (!iIdentifierFactory.isDocumentTypeIdentifierSchemeValid(string)) {
            throw new IllegalArgumentException("Peppol Document Type identifier scheme '" + string + "' is invalid!");
        }
        return string;
    }

    @Nonnull
    private static String _verifyValue(@Nonnull IIdentifierFactory iIdentifierFactory, @Nullable String string, @Nonnull String string2) {
        if (!iIdentifierFactory.isDocumentTypeIdentifierValueValid(string, string2)) {
            throw new IllegalArgumentException("Peppol Document Type identifier value '" + string2 + "' is invalid for scheme '" + string + "'!");
        }
        return string2;
    }

    @DevelopersNote(value="Don't invoke manually. Always use the IdentifierFactory!")
    public PeppolDocumentTypeIdentifier(@Nonnull IIdentifierFactory iIdentifierFactory, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) {
        this(iIdentifierFactory, iDocumentTypeIdentifier.getScheme(), iDocumentTypeIdentifier.getValue());
    }

    @DevelopersNote(value="Don't invoke manually. Always use the IdentifierFactory!")
    public PeppolDocumentTypeIdentifier(@Nonnull IIdentifierFactory iIdentifierFactory, @Nullable String string, @Nonnull String string2) {
        this(true, PeppolDocumentTypeIdentifier._verifyScheme(iIdentifierFactory, string), PeppolDocumentTypeIdentifier._verifyValue(iIdentifierFactory, string, string2));
    }

    protected PeppolDocumentTypeIdentifier(boolean bl, @Nonnull String string, @Nonnull String string2) {
        this.setScheme(string);
        this.setValue(string2);
    }

    @Override
    public boolean hasDefaultScheme() {
        return this.hasScheme("busdox-docid-qns");
    }

    @Override
    public int compareTo(@Nonnull PeppolDocumentTypeIdentifier peppolDocumentTypeIdentifier) {
        int n = CompareHelper.compare((Comparable)((Object)this.getScheme()), (Comparable)((Object)peppolDocumentTypeIdentifier.getScheme()));
        if (n == 0) {
            n = CompareHelper.compare((Comparable)((Object)this.getValue()), (Comparable)((Object)peppolDocumentTypeIdentifier.getValue()));
        }
        return n;
    }

    @Nonnull
    public IPeppolGenericDocumentTypeIdentifierParts getParts() {
        return PeppolGenericDocumentTypeIdentifierParts.extractFromIdentifier(this);
    }

    @Nonnull
    @ReturnsMutableCopy
    public PeppolDocumentTypeIdentifier getClone() {
        return new PeppolDocumentTypeIdentifier(true, this.getScheme(), this.getValue());
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Nonnull
    public static PeppolDocumentTypeIdentifier internalCreatePreVerified(@Nullable String string, @Nullable String string2) {
        return new PeppolDocumentTypeIdentifier(true, string, string2);
    }
}

