/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.peppol.doctype;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.peppol.doctype.IPeppolGenericDocumentTypeIdentifierParts;
import jakarta.annotation.Nonnull;
import java.util.List;

@Immutable
public class PeppolGenericDocumentTypeIdentifierParts
implements IPeppolGenericDocumentTypeIdentifierParts {
    private final String m_sSyntaxSpecificID;
    private final String m_sCustomizationID;
    private final String m_sVersion;

    public PeppolGenericDocumentTypeIdentifierParts(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"SyntaxSpecificID");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"CustomizationID");
        ValueEnforcer.notEmpty((CharSequence)string3, (String)"Version");
        this.m_sSyntaxSpecificID = string;
        this.m_sCustomizationID = string2;
        this.m_sVersion = string3;
    }

    @Override
    @Nonnull
    public final String getSyntaxSpecificID() {
        return this.m_sSyntaxSpecificID;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getCustomizationID() {
        return this.m_sCustomizationID;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getVersion() {
        return this.m_sVersion;
    }

    @Nonnull
    public PeppolGenericDocumentTypeIdentifierParts withCustomizationID(@Nonnull @Nonempty String string) {
        return new PeppolGenericDocumentTypeIdentifierParts(this.m_sSyntaxSpecificID, string, this.m_sVersion);
    }

    @Nonnull
    public PeppolGenericDocumentTypeIdentifierParts withVersion(@Nonnull @Nonempty String string) {
        return new PeppolGenericDocumentTypeIdentifierParts(this.m_sSyntaxSpecificID, this.m_sCustomizationID, string);
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getAsDocumentTypeIdentifierValue() {
        return this.m_sSyntaxSpecificID + "##" + this.m_sCustomizationID + "::" + this.m_sVersion;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("SyntaxSpecificID", (Object)this.m_sSyntaxSpecificID).append("CustomizationID", (Object)this.m_sCustomizationID).append("Version", (Object)this.m_sVersion).getToString();
    }

    @Nonnull
    public static PeppolGenericDocumentTypeIdentifierParts extractFromString(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"DocumentTypeIdentifier");
        List list = StringHelper.getExploded((String)"##", (String)string, (int)2);
        if (list.size() != 2) {
            throw new IllegalArgumentException("The passed document type identifier is missing the separator between the Syntax specific ID and the Customization ID!");
        }
        String string2 = (String)list.get(0);
        if (StringHelper.isEmpty((String)string2)) {
            throw new IllegalArgumentException("The passed document type identifier has an empty Syntax specific ID!");
        }
        String string3 = (String)list.get(1);
        if (StringHelper.isEmpty((String)string3)) {
            throw new IllegalArgumentException("The passed document type identifier has an nothing after the Syntax specific ID!");
        }
        int n = string3.lastIndexOf("::");
        if (n < 0) {
            throw new IllegalArgumentException("The passed document type identifier remainder '" + string3 + "' is missing the separation between Customization ID and Version!");
        }
        String string4 = string3.substring(0, n);
        if (StringHelper.isEmpty((String)string4)) {
            throw new IllegalArgumentException("The passed document type identifier remainder '" + string3 + "' contains an empty Customization ID!");
        }
        String string5 = string3.substring(n + "::".length());
        if (StringHelper.isEmpty((String)string5)) {
            throw new IllegalArgumentException("The passed document type identifier remainder '" + string3 + "' contains an empty Version!");
        }
        return new PeppolGenericDocumentTypeIdentifierParts(string2, string4, string5);
    }

    @Nonnull
    public static PeppolGenericDocumentTypeIdentifierParts extractFromIdentifier(@Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) {
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"Identifier");
        return PeppolGenericDocumentTypeIdentifierParts.extractFromString(iDocumentTypeIdentifier.getValue());
    }
}

