/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.reporting.api;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.cache.regex.RegExHelper;
import com.helger.peppolid.IDocumentTypeIdentifier;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@Immutable
public final class PeppolReportingHelper {
    private PeppolReportingHelper() {
    }

    public static boolean isValidCountryCode(@Nullable String string) {
        return string != null && string.length() == 2 && RegExHelper.stringMatchesPattern((String)"[0-9A-Z]{2}", (String)string);
    }

    public static boolean isDocumentTypeEligableForReporting(@Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) {
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocTypeID");
        return PeppolReportingHelper.isDocumentTypeEligableForReporting(iDocumentTypeIdentifier.getScheme(), iDocumentTypeIdentifier.getValue());
    }

    public static boolean isDocumentTypeEligableForReporting(@Nullable String string, @Nullable String string2) {
        if ("busdox-docid-qns".equals(string)) {
            if ("urn:fdc:peppol:end-user-statistics-report:1.1::EndUserStatisticsReport##urn:fdc:peppol.eu:edec:trns:end-user-statistics-report:1.1::1.1".equals(string2)) {
                return false;
            }
            if ("urn:fdc:peppol:transaction-statistics-report:1.0::TransactionStatisticsReport##urn:fdc:peppol.eu:edec:trns:transaction-statistics-reporting:1.0::1.0".equals(string2)) {
                return false;
            }
        }
        return true;
    }
}

