/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.reporting.api.backend;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.functional.IThrowingConsumer;
import com.helger.base.spi.ServiceLoaderHelper;
import com.helger.base.state.ESuccess;
import com.helger.config.IConfig;
import com.helger.peppol.reporting.api.PeppolReportingAPIVersion;
import com.helger.peppol.reporting.api.backend.IPeppolReportingBackendSPI;
import com.helger.peppol.reporting.api.backend.PeppolReportingBackendException;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class PeppolReportingBackend {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeppolReportingBackend.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static IPeppolReportingBackendSPI s_aBackendService = PeppolReportingBackend._loadBackendService();

    @Nullable
    private static IPeppolReportingBackendSPI _loadBackendService() {
        List list;
        int n;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Loading IPeppolReportingBackendSPI implementation");
        }
        if ((n = (list = ServiceLoaderHelper.getAllSPIImplementations(IPeppolReportingBackendSPI.class)).size()) != 1) {
            if (n == 0) {
                LOGGER.error("Failed to find any Peppol Reporting backend SPI implementation");
            } else {
                LOGGER.error("Failed to find exactly one Peppol Reporting backend SPI implementations, but " + n + " instances");
            }
            return null;
        }
        IPeppolReportingBackendSPI iPeppolReportingBackendSPI = (IPeppolReportingBackendSPI)list.get(0);
        LOGGER.info("Using IPeppolReportingBackendSPI implementation '" + iPeppolReportingBackendSPI.getDisplayName() + "/" + PeppolReportingAPIVersion.BUILD_VERSION + "'");
        return iPeppolReportingBackendSPI;
    }

    private PeppolReportingBackend() {
    }

    @Nullable
    public static IPeppolReportingBackendSPI getBackendService() {
        return (IPeppolReportingBackendSPI)RW_LOCK.readLockedGet(() -> s_aBackendService);
    }

    public static void setBackendService(@Nonnull IPeppolReportingBackendSPI iPeppolReportingBackendSPI) {
        ValueEnforcer.notNull((Object)iPeppolReportingBackendSPI, (String)"BackendService");
        RW_LOCK.writeLocked(() -> {
            s_aBackendService = iPeppolReportingBackendSPI;
        });
    }

    public static boolean isBackendServiceConfigured() {
        return PeppolReportingBackend.getBackendService() != null;
    }

    @Nonnull
    public static ESuccess withBackendDo(@Nonnull IConfig iConfig, @Nonnull IThrowingConsumer<? super IPeppolReportingBackendSPI, PeppolReportingBackendException> iThrowingConsumer) throws PeppolReportingBackendException {
        ValueEnforcer.notNull((Object)iConfig, (String)"Config");
        ValueEnforcer.notNull(iThrowingConsumer, (String)"BackendConsumer");
        IPeppolReportingBackendSPI iPeppolReportingBackendSPI = PeppolReportingBackend.getBackendService();
        if (iPeppolReportingBackendSPI == null) {
            return ESuccess.FAILURE;
        }
        if (iPeppolReportingBackendSPI.isInitialized()) {
            iThrowingConsumer.accept((Object)iPeppolReportingBackendSPI);
        } else {
            if (iPeppolReportingBackendSPI.initBackend(iConfig).isFailure()) {
                return ESuccess.FAILURE;
            }
            try {
                iThrowingConsumer.accept((Object)iPeppolReportingBackendSPI);
            }
            finally {
                iPeppolReportingBackendSPI.shutdownBackend();
            }
        }
        return ESuccess.SUCCESS;
    }
}

