/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.reportingsupport.mongodb;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ESuccess;
import com.helger.peppol.reporting.backend.mongodb.MongoClientWrapper;
import com.helger.peppol.reportingsupport.IPeppolReportStorage;
import com.helger.peppol.reportingsupport.domain.PeppolReportData;
import com.helger.peppol.reportingsupport.domain.PeppolReportSendingReportData;
import com.helger.typeconvert.impl.TypeConverter;
import jakarta.annotation.Nonnull;
import java.util.Date;
import java.util.function.Supplier;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeppolReportStorageMongoDB
implements IPeppolReportStorage {
    public static final String DEFAULT_COLLECTION_NAME_PEPPOL_REPORTS = "peppol-reports";
    public static final String DEFAULT_COLLECTION_NAME_PEPPOL_REPORTING_SENDING_REPORTS = "peppol-reporting-sending-reports";
    public static final String BSON_REPORT_TYPE = "reporttype";
    public static final String BSON_YEAR = "year";
    public static final String BSON_MONTH = "month";
    public static final String BSON_CREATION_DT = "creationdt";
    public static final String BSON_PAYLOAD = "payload";
    public static final String BSON_PAYLOAD_VALID = "payloadvalid";
    private static final Logger LOGGER = LoggerFactory.getLogger(PeppolReportStorageMongoDB.class);
    private final Supplier<? extends MongoClientWrapper> m_aMongoClientSupplier;
    private String m_sCollectionNamePeppolReports;
    private String m_sCollectionNamePeppolReportingSendingReports;

    public PeppolReportStorageMongoDB(@Nonnull Supplier<? extends MongoClientWrapper> supplier) {
        ValueEnforcer.notNull(supplier, (String)"MongoClientSupplier");
        this.m_aMongoClientSupplier = supplier;
        this.m_sCollectionNamePeppolReports = DEFAULT_COLLECTION_NAME_PEPPOL_REPORTS;
        this.m_sCollectionNamePeppolReportingSendingReports = DEFAULT_COLLECTION_NAME_PEPPOL_REPORTING_SENDING_REPORTS;
    }

    @Nonnull
    @Nonempty
    public String getCollectionNamePeppolReports() {
        return this.m_sCollectionNamePeppolReports;
    }

    @Nonnull
    public PeppolReportStorageMongoDB setCollectionNamePeppolReports(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"CollectionNamePeppolReports");
        if (!this.m_sCollectionNamePeppolReports.equals(string)) {
            LOGGER.info("Using MongoDB collection name '" + string + "' to store Peppol Reports");
            this.m_sCollectionNamePeppolReports = string;
        }
        return this;
    }

    @Nonnull
    @Nonempty
    public String getCollectionNamePeppolReportingSendingReports() {
        return this.m_sCollectionNamePeppolReportingSendingReports;
    }

    @Nonnull
    public PeppolReportStorageMongoDB setCollectionNamePeppolReportingSendingReports(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"CollectionPeppolReportingSendingReports");
        if (!this.m_sCollectionNamePeppolReportingSendingReports.equals(string)) {
            LOGGER.info("Using MongoDB collection name '" + string + "' to store Peppol Reporting Sending Reports");
            this.m_sCollectionNamePeppolReportingSendingReports = string;
        }
        return this;
    }

    @Nonnull
    static Document toBson(@Nonnull PeppolReportData peppolReportData) {
        return new Document().append(BSON_REPORT_TYPE, (Object)peppolReportData.getReportType().getID()).append(BSON_YEAR, (Object)peppolReportData.getReportPeriod().getYear()).append(BSON_MONTH, (Object)peppolReportData.getReportPeriod().getMonthValue()).append(BSON_CREATION_DT, TypeConverter.convert((Object)peppolReportData.getReportCreationDT(), Date.class)).append(BSON_PAYLOAD, (Object)peppolReportData.getReportXMLString()).append(BSON_PAYLOAD_VALID, (Object)peppolReportData.isReportValid());
    }

    @Override
    @Nonnull
    public ESuccess storePeppolReport(@Nonnull PeppolReportData peppolReportData) {
        ValueEnforcer.notNull((Object)peppolReportData, (String)"ReportData");
        MongoClientWrapper mongoClientWrapper = this.m_aMongoClientSupplier.get();
        if (mongoClientWrapper == null) {
            LOGGER.error("Failed to init MongoDB client - not storing Peppol Report");
            return ESuccess.FAILURE;
        }
        if (!mongoClientWrapper.isDBWritable()) {
            LOGGER.error("MongoDB is not writable - not storing Peppol Report");
            return ESuccess.FAILURE;
        }
        Document document = PeppolReportStorageMongoDB.toBson(peppolReportData);
        if (!mongoClientWrapper.getCollection(this.m_sCollectionNamePeppolReports).insertOne((Object)document).wasAcknowledged()) {
            throw new IllegalStateException("Failed to insert into Peppol Reports MongoDB Collection");
        }
        return ESuccess.SUCCESS;
    }

    @Nonnull
    static Document toBson(@Nonnull PeppolReportSendingReportData peppolReportSendingReportData) {
        Document document = new Document().append(BSON_REPORT_TYPE, (Object)peppolReportSendingReportData.getReportType().getID()).append(BSON_YEAR, (Object)peppolReportSendingReportData.getReportPeriod().getYear()).append(BSON_MONTH, (Object)peppolReportSendingReportData.getReportPeriod().getMonthValue()).append(BSON_CREATION_DT, TypeConverter.convert((Object)peppolReportSendingReportData.getReportCreationDT(), Date.class));
        if (peppolReportSendingReportData.hasSendingReportContent()) {
            document.append(BSON_PAYLOAD, (Object)peppolReportSendingReportData.getSendingReportContent());
        }
        return document;
    }

    @Override
    @Nonnull
    public ESuccess storePeppolReportingSendingReport(@Nonnull PeppolReportSendingReportData peppolReportSendingReportData) {
        ValueEnforcer.notNull((Object)peppolReportSendingReportData, (String)"aSendingReportData");
        MongoClientWrapper mongoClientWrapper = this.m_aMongoClientSupplier.get();
        if (mongoClientWrapper == null) {
            LOGGER.error("Failed to init MongoDB client - not storing Peppol Reporting Sending Report");
            return ESuccess.FAILURE;
        }
        if (!mongoClientWrapper.isDBWritable()) {
            LOGGER.error("MongoDB is not writable - not storing Peppol Reporting Sending Report");
            return ESuccess.FAILURE;
        }
        Document document = PeppolReportStorageMongoDB.toBson(peppolReportSendingReportData);
        if (!mongoClientWrapper.getCollection(this.m_sCollectionNamePeppolReportingSendingReports).insertOne((Object)document).wasAcknowledged()) {
            throw new IllegalStateException("Failed to insert into Peppol Reporting Sending Reports MongoDB Collection");
        }
        return ESuccess.SUCCESS;
    }
}

