/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.reportingsupport.sql;

import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.string.StringImplode;
import com.helger.config.IConfig;
import com.helger.db.api.EDatabaseSystemType;
import com.helger.db.api.config.IJdbcConfiguration;
import com.helger.db.api.config.IJdbcDataSourceConfiguration;
import com.helger.db.api.flyway.FlywayConfiguration;
import com.helger.db.jdbc.DataSourceProviderFromJdbcConfiguration;
import com.helger.db.jdbc.IHasDataSource;
import com.helger.peppol.reporting.backend.sql.PeppolReportingBackendSqlSPI;
import com.helger.peppol.reportingsupport.sql.PeppolReportDBExecutor;
import com.helger.peppol.reportingsupport.sql.PeppolReportFlywayConfigurationBuilder;
import com.helger.peppol.reportingsupport.sql.PeppolReportFlywayMigrator;
import com.helger.peppol.reportingsupport.sql.PeppolReportJdbcConfiguration;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.EnumSet;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeppolReportSQLHandler
implements Supplier<PeppolReportDBExecutor>,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeppolReportSQLHandler.class);
    private static final EnumSet<EDatabaseSystemType> ALLOWED_DB_TYPES = EnumSet.of(EDatabaseSystemType.MYSQL, EDatabaseSystemType.POSTGRESQL);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final IJdbcConfiguration m_aJdbcConfig;
    private final DataSourceProviderFromJdbcConfiguration m_aDSP;
    private final String m_sTableNamePrefix;

    public PeppolReportSQLHandler(@Nonnull IConfig iConfig) {
        PeppolReportJdbcConfiguration peppolReportJdbcConfiguration = new PeppolReportJdbcConfiguration(iConfig);
        EDatabaseSystemType eDatabaseSystemType = peppolReportJdbcConfiguration.getJdbcDatabaseSystemType();
        if (eDatabaseSystemType == null || !ALLOWED_DB_TYPES.contains(eDatabaseSystemType)) {
            throw new IllegalStateException("The database type MUST be provided and MUST be one of " + StringImplode.imploder().source(ALLOWED_DB_TYPES, EDatabaseSystemType::getID).separator(", ").build() + " - provided value is '" + peppolReportJdbcConfiguration.getJdbcDatabaseType() + "'");
        }
        PeppolReportFlywayConfigurationBuilder peppolReportFlywayConfigurationBuilder = new PeppolReportFlywayConfigurationBuilder(iConfig, (IJdbcConfiguration)peppolReportJdbcConfiguration);
        FlywayConfiguration flywayConfiguration = peppolReportFlywayConfigurationBuilder.build();
        if (flywayConfiguration.isFlywayEnabled()) {
            PeppolReportFlywayMigrator.Singleton.INSTANCE.runFlyway(eDatabaseSystemType, (IJdbcConfiguration)peppolReportJdbcConfiguration, flywayConfiguration);
        } else {
            LOGGER.warn("Peppol Reporting Flyway Migration is disabled according to the configuration key '" + peppolReportFlywayConfigurationBuilder.getConfigKeyEnabled() + "'");
        }
        this.m_aJdbcConfig = peppolReportJdbcConfiguration;
        this.m_aDSP = new DataSourceProviderFromJdbcConfiguration((IJdbcDataSourceConfiguration)peppolReportJdbcConfiguration);
        if (this.m_aDSP == null) {
            throw new IllegalStateException("Failed to create Peppol Report SQL DB DataSource provider");
        }
        this.m_sTableNamePrefix = PeppolReportingBackendSqlSPI.getTableNamePrefix((EDatabaseSystemType)eDatabaseSystemType, (String)peppolReportJdbcConfiguration.getJdbcSchema());
    }

    public boolean isInitialized() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aDSP != null && this.m_sTableNamePrefix != null);
    }

    @Override
    public void close() {
        if (this.isInitialized()) {
            this.m_aRWLock.writeLocked(() -> {
                LOGGER.info("Shutting down Peppol Report SQL DB client");
                if (this.m_aDSP != null) {
                    try {
                        this.m_aDSP.close();
                    }
                    catch (IOException iOException) {
                        LOGGER.error("Failed to close Peppol Report DataSource provider", (Throwable)iOException);
                    }
                }
            });
        } else {
            LOGGER.warn("The Peppol Report SQL DB backend cannot be shutdown, because it was never properly initialized");
        }
    }

    @Override
    @Nonnull
    public PeppolReportDBExecutor get() {
        return new PeppolReportDBExecutor((IHasDataSource)this.m_aDSP, this.m_aJdbcConfig);
    }

    @Nonnull
    public String getTableNamePrefix() {
        return this.m_sTableNamePrefix;
    }
}

