/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.reportingsupport.sql;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ESuccess;
import com.helger.datetime.helper.PDTFactory;
import com.helger.db.api.helper.DBValueHelper;
import com.helger.db.jdbc.callback.ConstantPreparedStatementDataProvider;
import com.helger.db.jdbc.callback.IPreparedStatementDataProvider;
import com.helger.db.jdbc.executor.DBExecutor;
import com.helger.peppol.reportingsupport.IPeppolReportStorage;
import com.helger.peppol.reportingsupport.domain.PeppolReportData;
import com.helger.peppol.reportingsupport.domain.PeppolReportSendingReportData;
import com.helger.peppol.reportingsupport.sql.PeppolReportDBExecutor;
import jakarta.annotation.Nonnull;
import java.time.LocalDateTime;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeppolReportStorageSQL
implements IPeppolReportStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeppolReportStorageSQL.class);
    private final Supplier<? extends PeppolReportDBExecutor> m_aDBExecutorSupplier;
    private final String m_sTableNamePrefix;

    public PeppolReportStorageSQL(@Nonnull Supplier<? extends PeppolReportDBExecutor> supplier, @Nonnull String string) {
        ValueEnforcer.notNull(supplier, (String)"DBExecutorSupplier");
        ValueEnforcer.notNull((Object)string, (String)"TableNamePrefix");
        this.m_aDBExecutorSupplier = supplier;
        this.m_sTableNamePrefix = string;
    }

    @Override
    @Nonnull
    public ESuccess storePeppolReport(@Nonnull PeppolReportData peppolReportData) {
        DBExecutor dBExecutor;
        ESuccess eSuccess;
        ValueEnforcer.notNull((Object)peppolReportData, (String)"ReportData");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Trying to store Peppol Report in SQL DB");
        }
        if ((eSuccess = (dBExecutor = (DBExecutor)this.m_aDBExecutorSupplier.get()).performInTransaction(() -> {
            long l = dBExecutor.insertOrUpdateOrDelete("INSERT INTO " + this.m_sTableNamePrefix + "peppol_report (reptype, repyear, repmonth, repcreatedt, report, repvalid) VALUES (?, ?, ?, ?, ?, ?)", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{DBValueHelper.getTrimmedToLength((String)peppolReportData.getReportType().getID(), (int)12), peppolReportData.getReportPeriod().getYear(), peppolReportData.getReportPeriod().getMonthValue(), DBValueHelper.toTimestamp((LocalDateTime)PDTFactory.getWithMillisOnly((LocalDateTime)peppolReportData.getReportCreationDT())), peppolReportData.getReportXMLString(), peppolReportData.isReportValid()}));
            if (l != 1L) {
                throw new IllegalStateException("Failed to create new SQL DB entry (" + l + ")");
            }
        })).isFailure()) {
            throw new IllegalStateException("Failed to insert Peppol Report into SQL DB");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Successfully stored Peppol Report in SQL DB");
        }
        return ESuccess.SUCCESS;
    }

    @Override
    @Nonnull
    public ESuccess storePeppolReportingSendingReport(@Nonnull PeppolReportSendingReportData peppolReportSendingReportData) {
        DBExecutor dBExecutor;
        ESuccess eSuccess;
        ValueEnforcer.notNull((Object)peppolReportSendingReportData, (String)"aSendingReportData");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Trying to store Peppol Report Sending Report in SQL DB");
        }
        if ((eSuccess = (dBExecutor = (DBExecutor)this.m_aDBExecutorSupplier.get()).performInTransaction(() -> {
            long l = dBExecutor.insertOrUpdateOrDelete("INSERT INTO " + this.m_sTableNamePrefix + "peppol_sending_report (reptype, repyear, repmonth, repcreatedt, sendingreport) VALUES (?, ?, ?, ?, ?)", (IPreparedStatementDataProvider)new ConstantPreparedStatementDataProvider(new Object[]{DBValueHelper.getTrimmedToLength((String)peppolReportSendingReportData.getReportType().getID(), (int)12), peppolReportSendingReportData.getReportPeriod().getYear(), peppolReportSendingReportData.getReportPeriod().getMonthValue(), DBValueHelper.toTimestamp((LocalDateTime)PDTFactory.getWithMillisOnly((LocalDateTime)peppolReportSendingReportData.getReportCreationDT())), peppolReportSendingReportData.getSendingReportContent()}));
            if (l != 1L) {
                throw new IllegalStateException("Failed to create new SQL DB entry (" + l + ")");
            }
        })).isFailure()) {
            throw new IllegalStateException("Failed to insert Peppol Report Sending Report into SQL DB");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Successfully stored Peppol Report Sending Report in SQL DB");
        }
        return ESuccess.SUCCESS;
    }
}

