/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.sbdh;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.datetime.XMLOffsetDateTime;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.error.IError;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.level.IHasErrorLevel;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.peppol.sbdh.EPeppolSBDHDataError;
import com.helger.peppol.sbdh.PeppolSBDHAdditionalAttributes;
import com.helger.peppol.sbdh.PeppolSBDHData;
import com.helger.peppol.sbdh.PeppolSBDHDataReadException;
import com.helger.peppolid.CIdentifier;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.factory.IIdentifierFactory;
import com.helger.sbdh.SBDMarshaller;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.unece.cefact.namespaces.sbdh.DocumentIdentification;
import org.unece.cefact.namespaces.sbdh.PartnerIdentification;
import org.unece.cefact.namespaces.sbdh.Scope;
import org.unece.cefact.namespaces.sbdh.StandardBusinessDocument;
import org.unece.cefact.namespaces.sbdh.StandardBusinessDocumentHeader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@NotThreadSafe
public class PeppolSBDHDataReader {
    public static final boolean DEFAULT_PERFORM_VALUE_CHECKS = true;
    public static final boolean DEFAULT_CHECK_FOR_COUNTRY_C1 = true;
    public static final String DEFAULT_COUNTRY_CODE_REGEX = "[A-Z0-9][A-Z0-9]";
    private static final Logger LOGGER = LoggerFactory.getLogger(PeppolSBDHDataReader.class);
    private final IIdentifierFactory m_aIdentifierFactory;
    private boolean m_bPerformValueChecks = true;
    private boolean m_bCheckForCountryC1 = true;

    public PeppolSBDHDataReader(@Nonnull IIdentifierFactory iIdentifierFactory) {
        ValueEnforcer.notNull((Object)iIdentifierFactory, (String)"IdentifierFactory");
        this.m_aIdentifierFactory = iIdentifierFactory;
    }

    @Nonnull
    public final IIdentifierFactory getIdentifierFactory() {
        return this.m_aIdentifierFactory;
    }

    public final boolean isPerformValueChecks() {
        return this.m_bPerformValueChecks;
    }

    @Nonnull
    public final PeppolSBDHDataReader setPerformValueChecks(boolean bl) {
        this.m_bPerformValueChecks = bl;
        return this;
    }

    public final boolean isCheckForCountryC1() {
        return this.m_bCheckForCountryC1;
    }

    @Nonnull
    public final PeppolSBDHDataReader setCheckForCountryC1(boolean bl) {
        boolean bl2 = bl != this.m_bCheckForCountryC1;
        this.m_bCheckForCountryC1 = bl;
        if (bl2) {
            LOGGER.info("Peppol SBDH C1 Country Code check is " + (bl ? "enabled" : "disabled"));
        }
        return this;
    }

    @OverrideOnDemand
    protected boolean isValidHeaderVersion(@Nullable String string) {
        return "1.0".equals(string);
    }

    @OverrideOnDemand
    protected boolean isValidSenderAuthority(@Nullable String string) {
        return "iso6523-actorid-upis".equals(string);
    }

    @OverrideOnDemand
    protected boolean isValidSenderIdentifier(@Nullable String string, @Nullable String string2) {
        return StringHelper.hasText((String)string2);
    }

    @OverrideOnDemand
    protected boolean isValidReceiverAuthority(@Nullable String string) {
        return "iso6523-actorid-upis".equals(string);
    }

    @OverrideOnDemand
    protected boolean isValidReceiverIdentifier(@Nullable String string, @Nullable String string2) {
        return StringHelper.hasText((String)string2);
    }

    @OverrideOnDemand
    protected boolean isValidDocumentTypeIdentifier(@Nullable String string) {
        return StringHelper.hasText((String)string);
    }

    @OverrideOnDemand
    protected boolean isValidProcessIdentifier(@Nullable String string) {
        return StringHelper.hasText((String)string);
    }

    @OverrideOnDemand
    protected boolean isValidCountryC1(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return false;
        }
        return RegExHelper.stringMatchesPattern((String)DEFAULT_COUNTRY_CODE_REGEX, (String)string);
    }

    @OverrideOnDemand
    protected boolean isValidBusinessMessage(@Nonnull Element element) {
        return true;
    }

    @OverrideOnDemand
    protected boolean isValidStandard(@Nullable String string, @Nonnull Element element, @Nonnull String string2) {
        if (StringHelper.hasNoText((String)string)) {
            return false;
        }
        return string.equals(element.getNamespaceURI()) && string2.startsWith(string);
    }

    @OverrideOnDemand
    protected boolean isValidTypeVersion(@Nullable String string, @Nonnull Element element, @Nonnull String string2) {
        if (StringHelper.hasNoText((String)string)) {
            return false;
        }
        if (string.indexOf(58) >= 0) {
            return false;
        }
        return string2.endsWith(":" + string);
    }

    @OverrideOnDemand
    protected boolean isValidType(@Nullable String string, @Nonnull Element element) {
        return EqualsHelper.equals((Object)string, (Object)element.getLocalName());
    }

    @OverrideOnDemand
    protected boolean isValidInstanceIdentifier(@Nullable String string) {
        return StringHelper.hasText((String)string);
    }

    @OverrideOnDemand
    protected boolean isValidCreationDateTime(@Nonnull XMLOffsetDateTime xMLOffsetDateTime) {
        return true;
    }

    @Nonnull
    @OverrideOnDemand
    protected SBDMarshaller createSBDMarshaller() {
        SBDMarshaller sBDMarshaller = new SBDMarshaller();
        sBDMarshaller.setValidationEventHandler(null);
        return sBDMarshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public PeppolSBDHData extractData(@Nonnull @WillClose InputStream inputStream) throws PeppolSBDHDataReadException {
        ValueEnforcer.notNull((Object)inputStream, (String)"StandardBusinessDocument");
        try {
            StandardBusinessDocument standardBusinessDocument = (StandardBusinessDocument)this.createSBDMarshaller().read(inputStream);
            if (standardBusinessDocument == null) {
                throw new PeppolSBDHDataReadException(EPeppolSBDHDataError.INVALID_SBD_XML);
            }
            PeppolSBDHData peppolSBDHData = this.extractData(standardBusinessDocument);
            return peppolSBDHData;
        }
        finally {
            StreamHelper.close((AutoCloseable)inputStream);
        }
    }

    @Nonnull
    public PeppolSBDHData extractData(@Nonnull IReadableResource iReadableResource) throws PeppolSBDHDataReadException {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"StandardBusinessDocument");
        StandardBusinessDocument standardBusinessDocument = (StandardBusinessDocument)this.createSBDMarshaller().read(iReadableResource);
        if (standardBusinessDocument == null) {
            throw new PeppolSBDHDataReadException(EPeppolSBDHDataError.INVALID_SBD_XML);
        }
        return this.extractData(standardBusinessDocument);
    }

    @Nonnull
    public PeppolSBDHData extractData(@Nonnull Node node) throws PeppolSBDHDataReadException {
        ValueEnforcer.notNull((Object)node, (String)"StandardBusinessDocument");
        StandardBusinessDocument standardBusinessDocument = (StandardBusinessDocument)this.createSBDMarshaller().read(node);
        if (standardBusinessDocument == null) {
            throw new PeppolSBDHDataReadException(EPeppolSBDHDataError.INVALID_SBD_XML);
        }
        return this.extractData(standardBusinessDocument);
    }

    @Nonnull
    public PeppolSBDHData extractData(@Nonnull StandardBusinessDocument standardBusinessDocument) throws PeppolSBDHDataReadException {
        ValueEnforcer.notNull((Object)standardBusinessDocument, (String)"StandardBusinessDocument");
        StandardBusinessDocumentHeader standardBusinessDocumentHeader = standardBusinessDocument.getStandardBusinessDocumentHeader();
        if (standardBusinessDocumentHeader == null) {
            throw new PeppolSBDHDataReadException(EPeppolSBDHDataError.MISSING_SBDH);
        }
        Element element = (Element)standardBusinessDocument.getAny();
        return this.extractData(standardBusinessDocumentHeader, element);
    }

    @Nonnull
    private static IError _toError(@Nullable String string, @Nonnull EPeppolSBDHDataError ePeppolSBDHDataError, Object ... objectArray) {
        return ((SingleError.Builder)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string)).errorID(ePeppolSBDHDataError.getID())).errorText(objectArray == null ? ePeppolSBDHDataError.getErrorMessage() : ePeppolSBDHDataError.getErrorMessage(objectArray))).build();
    }

    public void validateData(@Nonnull StandardBusinessDocumentHeader standardBusinessDocumentHeader, @Nonnull Element element, @Nonnull ErrorList errorList) {
        XMLOffsetDateTime xMLOffsetDateTime;
        String string;
        String string2;
        IParticipantIdentifier iParticipantIdentifier;
        String string3;
        String string4;
        PartnerIdentification partnerIdentification;
        int n;
        ValueEnforcer.notNull((Object)standardBusinessDocumentHeader, (String)"StandardBusinessDocumentHeader");
        ValueEnforcer.notNull((Object)element, (String)"BusinessMessage");
        ValueEnforcer.notNull((Object)errorList, (String)"ErrorList");
        if (!this.isValidHeaderVersion(standardBusinessDocumentHeader.getHeaderVersion())) {
            errorList.add((Object)PeppolSBDHDataReader._toError("SBDH/HeaderVersion", EPeppolSBDHDataError.INVALID_HEADER_VERSION, standardBusinessDocumentHeader.getHeaderVersion()));
        }
        if ((n = standardBusinessDocumentHeader.getSenderCount()) != 1) {
            errorList.add((Object)PeppolSBDHDataReader._toError("SBDH", EPeppolSBDHDataError.INVALID_SENDER_COUNT, Integer.toString(n)));
        }
        if (n > 0 && (partnerIdentification = standardBusinessDocumentHeader.getSenderAtIndex(0).getIdentifier()) != null) {
            string4 = partnerIdentification.getAuthority();
            if (!this.isValidSenderAuthority(string4)) {
                errorList.add((Object)PeppolSBDHDataReader._toError("SBDH/Sender[1]/Identifier/Authority", EPeppolSBDHDataError.INVALID_SENDER_AUTHORITY, string4));
            }
            if (!this.isValidSenderIdentifier(string4, string3 = partnerIdentification.getValue())) {
                errorList.add((Object)PeppolSBDHDataReader._toError("SBDH/Sender[1]/Identifier/Value", EPeppolSBDHDataError.INVALID_SENDER_VALUE, string3));
            } else {
                iParticipantIdentifier = this.m_aIdentifierFactory.createParticipantIdentifier(string4, string3);
                if (iParticipantIdentifier == null) {
                    errorList.add((Object)PeppolSBDHDataReader._toError("SBDH/Sender[1]/Identifier", EPeppolSBDHDataError.INVALID_SENDER_VALUE, CIdentifier.getURIEncoded((String)string4, (String)string3)));
                }
            }
        }
        if ((n = standardBusinessDocumentHeader.getReceiverCount()) != 1) {
            errorList.add((Object)PeppolSBDHDataReader._toError("SBDH", EPeppolSBDHDataError.INVALID_RECEIVER_COUNT, Integer.toString(n)));
        }
        if (n > 0 && (partnerIdentification = standardBusinessDocumentHeader.getReceiverAtIndex(0).getIdentifier()) != null) {
            string4 = partnerIdentification.getAuthority();
            if (!this.isValidReceiverAuthority(string4)) {
                errorList.add((Object)PeppolSBDHDataReader._toError("SBDH/Receiver[1]/Identifier/Authority", EPeppolSBDHDataError.INVALID_RECEIVER_AUTHORITY, string4));
            }
            if (!this.isValidReceiverIdentifier(string4, string3 = partnerIdentification.getValue())) {
                errorList.add((Object)PeppolSBDHDataReader._toError("SBDH/Receiver[1]/Identifier/Value", EPeppolSBDHDataError.INVALID_RECEIVER_VALUE, string3));
            } else {
                iParticipantIdentifier = this.m_aIdentifierFactory.createParticipantIdentifier(string4, string3);
                if (iParticipantIdentifier == null) {
                    errorList.add((Object)PeppolSBDHDataReader._toError("SBDH/Receiver[1]/Identifier", EPeppolSBDHDataError.INVALID_RECEIVER_VALUE, CIdentifier.getURIEncoded((String)string4, (String)string3)));
                }
            }
        }
        IDocumentTypeIdentifier iDocumentTypeIdentifier = null;
        partnerIdentification = null;
        string4 = standardBusinessDocumentHeader.getBusinessScope();
        if (string4 == null) {
            errorList.add((Object)PeppolSBDHDataReader._toError("SBDH", EPeppolSBDHDataError.BUSINESS_SCOPE_MISSING, new Object[0]));
        } else {
            int n2;
            int n3 = n2 = this.isCheckForCountryC1() ? 3 : 2;
            if (string4.getScopeCount() < n2) {
                errorList.add((Object)PeppolSBDHDataReader._toError("SBDH/BusinessScope", EPeppolSBDHDataError.INVALID_SCOPE_COUNT, Integer.toString(n2), Integer.toString(string4.getScopeCount())));
            }
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            int n4 = 1;
            for (Scope scope : string4.getScope()) {
                String string5;
                String string6 = scope.getType();
                String string7 = scope.getInstanceIdentifier();
                if ("DOCUMENTID".equals(string6)) {
                    if (!this.isValidDocumentTypeIdentifier(string7)) {
                        errorList.add((Object)PeppolSBDHDataReader._toError("SBDH/BusinessScope/Scope[" + n4 + "]/InstanceIdentifier", EPeppolSBDHDataError.INVALID_DOCUMENT_TYPE_IDENTIFIER, string7));
                    } else {
                        string5 = StringHelper.getNotNull((String)scope.getIdentifier(), (String)"busdox-docid-qns");
                        iDocumentTypeIdentifier = this.m_aIdentifierFactory.createDocumentTypeIdentifier(string5, string7);
                        if (iDocumentTypeIdentifier == null) {
                            errorList.add((Object)PeppolSBDHDataReader._toError("SBDH/BusinessScope/Scope[" + n4 + "]", EPeppolSBDHDataError.INVALID_DOCUMENT_TYPE_IDENTIFIER, CIdentifier.getURIEncoded((String)string5, (String)string7)));
                        }
                    }
                    bl = true;
                } else if ("PROCESSID".equals(string6)) {
                    if (!this.isValidProcessIdentifier(string7)) {
                        errorList.add((Object)PeppolSBDHDataReader._toError("SBDH/BusinessScope/Scope[" + n4 + "]/InstanceIdentifier", EPeppolSBDHDataError.INVALID_PROCESS_IDENTIFIER, string7));
                    } else {
                        string5 = StringHelper.getNotNull((String)scope.getIdentifier(), (String)"cenbii-procid-ubl");
                        partnerIdentification = this.m_aIdentifierFactory.createProcessIdentifier(string5, string7);
                        if (partnerIdentification == null) {
                            errorList.add((Object)PeppolSBDHDataReader._toError("SBDH/BusinessScope/Scope[" + n4 + "]", EPeppolSBDHDataError.INVALID_PROCESS_IDENTIFIER, CIdentifier.getURIEncoded((String)string5, (String)string7)));
                        }
                    }
                    bl2 = true;
                } else if ("COUNTRY_C1".equals(string6)) {
                    if (this.isCheckForCountryC1() && !this.isValidCountryC1(string7)) {
                        errorList.add((Object)PeppolSBDHDataReader._toError("SBDH/BusinessScope/Scope[" + n4 + "]/InstanceIdentifier", EPeppolSBDHDataError.INVALID_COUNTRY_C1, string7));
                    }
                    bl3 = true;
                } else if (PeppolSBDHAdditionalAttributes.isReservedAttributeName(string6)) {
                    errorList.add((Object)((SingleError.Builder)((SingleError.Builder)SingleError.builderWarn().errorFieldName("SBDH/BusinessScope/Scope[" + n4 + "]/Type")).errorText("Found a Peppol reserved attribute name '" + string6 + "' in the SBDH - Ignoring it.")).build());
                }
                ++n4;
            }
            if (!bl) {
                errorList.add((Object)PeppolSBDHDataReader._toError("SBDH/BusinessScope", EPeppolSBDHDataError.MISSING_DOCUMENT_TYPE_IDENTIFIER, new Object[0]));
            }
            if (!bl2) {
                errorList.add((Object)PeppolSBDHDataReader._toError("SBDH/BusinessScope", EPeppolSBDHDataError.MISSING_PROCESS_IDENTIFIER, new Object[0]));
            }
            if (this.isCheckForCountryC1() && !bl3) {
                errorList.add((Object)PeppolSBDHDataReader._toError("SBDH/BusinessScope", EPeppolSBDHDataError.MISSING_COUNTRY_C1, new Object[0]));
            }
        }
        if (!this.isValidBusinessMessage(element)) {
            errorList.add((Object)PeppolSBDHDataReader._toError(null, EPeppolSBDHDataError.INVALID_BUSINESS_MESSAGE, new Object[0]));
        }
        DocumentIdentification documentIdentification = standardBusinessDocumentHeader.getDocumentIdentification();
        if (iDocumentTypeIdentifier != null) {
            String string8;
            String string9 = documentIdentification.getStandard();
            if (!this.isValidStandard(string9, element, iDocumentTypeIdentifier.getValue())) {
                errorList.add((Object)PeppolSBDHDataReader._toError("SBDH/DocumentIdentification/Standard", EPeppolSBDHDataError.INVALID_STANDARD, string9, element.getNamespaceURI(), iDocumentTypeIdentifier.getValue()));
            }
            if (!this.isValidTypeVersion(string8 = documentIdentification.getTypeVersion(), element, iDocumentTypeIdentifier.getValue())) {
                errorList.add((Object)PeppolSBDHDataReader._toError("SBDH/DocumentIdentification/TypeVersion", EPeppolSBDHDataError.INVALID_TYPE_VERSION, string8, iDocumentTypeIdentifier.getValue()));
            }
        }
        if (!this.isValidType(string2 = documentIdentification.getType(), element)) {
            errorList.add((Object)PeppolSBDHDataReader._toError("SBDH/DocumentIdentification/Type", EPeppolSBDHDataError.INVALID_TYPE, string2, element.getLocalName()));
        }
        if (!this.isValidInstanceIdentifier(string = documentIdentification.getInstanceIdentifier())) {
            errorList.add((Object)PeppolSBDHDataReader._toError("SBDH/DocumentIdentification/InstanceIdentifier", EPeppolSBDHDataError.INVALID_INSTANCE_IDENTIFIER, string));
        }
        if (!this.isValidCreationDateTime(xMLOffsetDateTime = documentIdentification.getCreationDateAndTime())) {
            errorList.add((Object)PeppolSBDHDataReader._toError("SBDH/DocumentIdentification/CreationDateAndTime", EPeppolSBDHDataError.INVALID_CREATION_DATE_TIME, String.valueOf(xMLOffsetDateTime)));
        }
    }

    @Nonnull
    public PeppolSBDHData extractData(@Nonnull StandardBusinessDocumentHeader standardBusinessDocumentHeader, @Nonnull Element element) throws PeppolSBDHDataReadException {
        ValueEnforcer.notNull((Object)standardBusinessDocumentHeader, (String)"StandardBusinessDocumentHeader");
        ValueEnforcer.notNull((Object)element, (String)"BusinessMessage");
        if (this.isPerformValueChecks()) {
            ErrorList errorList = new ErrorList();
            this.validateData(standardBusinessDocumentHeader, element, errorList);
            int n = errorList.getErrorCount();
            if (n > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                errorList.forEach(iError -> {
                    if (iError.isError()) {
                        String string = iError.getAsStringLocaleIndepdent();
                        LOGGER.error("Peppol SBDH validation " + string);
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append('\n');
                        }
                        stringBuilder.append(string);
                    }
                });
                IError iError2 = (IError)errorList.findFirst(IHasErrorLevel::isError);
                EPeppolSBDHDataError ePeppolSBDHDataError = EPeppolSBDHDataError.getFromIDOrDefault(iError2.getErrorID(), EPeppolSBDHDataError.GENERIC_SBDH_ERROR);
                throw new PeppolSBDHDataReadException(stringBuilder.toString(), ePeppolSBDHDataError);
            }
        }
        return this.extractDataUnchecked(standardBusinessDocumentHeader, element);
    }

    @Nonnull
    public PeppolSBDHData extractDataUnchecked(@Nonnull StandardBusinessDocumentHeader standardBusinessDocumentHeader, @Nonnull Element element) {
        PartnerIdentification partnerIdentification;
        ValueEnforcer.notNull((Object)standardBusinessDocumentHeader, (String)"StandardBusinessDocumentHeader");
        ValueEnforcer.notNull((Object)element, (String)"BusinessMessage");
        PeppolSBDHData peppolSBDHData = new PeppolSBDHData(this.m_aIdentifierFactory);
        if (standardBusinessDocumentHeader.hasSenderEntries()) {
            partnerIdentification = standardBusinessDocumentHeader.getSenderAtIndex(0).getIdentifier();
            peppolSBDHData.setSender(partnerIdentification.getAuthority(), partnerIdentification.getValue());
        }
        if (standardBusinessDocumentHeader.hasReceiverEntries()) {
            partnerIdentification = standardBusinessDocumentHeader.getReceiverAtIndex(0).getIdentifier();
            peppolSBDHData.setReceiver(partnerIdentification.getAuthority(), partnerIdentification.getValue());
        }
        if ((partnerIdentification = standardBusinessDocumentHeader.getBusinessScope()) != null) {
            for (Scope scope : partnerIdentification.getScope()) {
                String string;
                String string2 = scope.getType();
                String string3 = scope.getInstanceIdentifier();
                if ("DOCUMENTID".equals(string2)) {
                    string = StringHelper.getNotNull((String)scope.getIdentifier(), (String)"busdox-docid-qns");
                    peppolSBDHData.setDocumentType(string, string3);
                    continue;
                }
                if ("PROCESSID".equals(string2)) {
                    string = StringHelper.getNotNull((String)scope.getIdentifier(), (String)"cenbii-procid-ubl");
                    peppolSBDHData.setProcess(string, string3);
                    continue;
                }
                if ("COUNTRY_C1".equals(string2)) {
                    peppolSBDHData.setCountryC1(string3);
                    continue;
                }
                if (PeppolSBDHAdditionalAttributes.isReservedAttributeName(string2)) continue;
                if (StringHelper.hasText((String)string3)) {
                    peppolSBDHData.additionalAttributes().add(string2, string3);
                    continue;
                }
                peppolSBDHData.additionalAttributes().add(string2, (String)null);
            }
        }
        peppolSBDHData.setBusinessMessage(element);
        DocumentIdentification documentIdentification = standardBusinessDocumentHeader.getDocumentIdentification();
        peppolSBDHData.setDocumentIdentification(documentIdentification.getStandard(), documentIdentification.getTypeVersion(), documentIdentification.getType(), documentIdentification.getInstanceIdentifier(), documentIdentification.getCreationDateAndTime());
        return peppolSBDHData;
    }
}

