/*
 * Copyright (C) 2015-2025 Philip Helger
 * philip[at]helger[dot]com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.helger.smpclient.httpclient;

import java.io.IOException;

import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

/**
 * This is the Apache HTTP client response handler for messages which don't
 * deliver a response body (PUT or DELETE HTTP operations).
 * <p>
 * Note: this class is also licensed under Apache 2 license, as it was not part
 * of the original implementation
 * </p>
 *
 * @author Philip Helger
 */
public class SMPHttpResponseHandlerWriteOperations extends AbstractSMPResponseHandler <Object>
{
  @Override
  @Nullable
  public Object handleEntity (@Nonnull final HttpEntity aEntity) throws IOException
  {
    // Ignore body
    EntityUtils.consume (aEntity);
    return null;
  }
}
