/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.dynamicdiscovery;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.peppol.smp.ESMPTransportProfile;
import com.helger.peppol.smp.ISMPTransportProfile;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.phase4.dynamicdiscovery.IAS4EndpointDetailProvider;
import com.helger.phase4.dynamicdiscovery.Phase4SMPException;
import com.helger.phase4.logging.Phase4LoggerFactory;
import com.helger.phase4.util.Phase4Exception;
import com.helger.smpclient.bdxr2.BDXR2ClientReadOnly;
import com.helger.smpclient.bdxr2.IBDXR2ServiceMetadataProvider;
import com.helger.smpclient.exception.SMPClientBadRequestException;
import com.helger.smpclient.exception.SMPClientBadResponseException;
import com.helger.smpclient.exception.SMPClientException;
import com.helger.smpclient.exception.SMPClientUnauthorizedException;
import com.helger.xsds.bdxr.smp2.ac.EndpointType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.slf4j.Logger;

public class AS4EndpointDetailProviderBDXR2
implements IAS4EndpointDetailProvider {
    public static final ISMPTransportProfile DEFAULT_TRANSPORT_PROFILE = ESMPTransportProfile.TRANSPORT_PROFILE_BDXR_AS4;
    private static final Logger LOGGER = Phase4LoggerFactory.getLogger(AS4EndpointDetailProviderBDXR2.class);
    private final IBDXR2ServiceMetadataProvider m_aSMPClient;
    private ISMPTransportProfile m_aTP = DEFAULT_TRANSPORT_PROFILE;
    private EndpointType m_aEndpoint;

    public AS4EndpointDetailProviderBDXR2(@Nonnull IBDXR2ServiceMetadataProvider iBDXR2ServiceMetadataProvider) {
        ValueEnforcer.notNull((Object)iBDXR2ServiceMetadataProvider, (String)"SMPClient");
        this.m_aSMPClient = iBDXR2ServiceMetadataProvider;
    }

    @Nonnull
    public final IBDXR2ServiceMetadataProvider getServiceMetadataProvider() {
        return this.m_aSMPClient;
    }

    @Nonnull
    public final ISMPTransportProfile getTransportProfile() {
        return this.m_aTP;
    }

    @Nonnull
    public final AS4EndpointDetailProviderBDXR2 setTransportProfile(@Nonnull ISMPTransportProfile iSMPTransportProfile) {
        ValueEnforcer.notNull((Object)iSMPTransportProfile, (String)"TransportProfile");
        this.m_aTP = iSMPTransportProfile;
        return this;
    }

    @Nullable
    public final EndpointType getEndpoint() {
        return this.m_aEndpoint;
    }

    @Override
    public void init(@Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull IParticipantIdentifier iParticipantIdentifier) throws Phase4Exception {
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocTypeID");
        ValueEnforcer.notNull((Object)iProcessIdentifier, (String)"ProcID");
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ReceiverID");
        if (this.m_aEndpoint == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Start performing SMP lookup (" + iParticipantIdentifier.getURIEncoded() + ", " + iDocumentTypeIdentifier.getURIEncoded() + ", " + iProcessIdentifier.getURIEncoded() + ")");
            }
            try {
                this.m_aEndpoint = this.m_aSMPClient.getEndpoint(iParticipantIdentifier, iDocumentTypeIdentifier, iProcessIdentifier, this.m_aTP);
                if (this.m_aEndpoint == null) {
                    throw new Phase4SMPException("Failed to resolve SMP endpoint (" + iParticipantIdentifier.getURIEncoded() + ", " + iDocumentTypeIdentifier.getURIEncoded() + ", " + iProcessIdentifier.getURIEncoded() + ", " + this.m_aTP.getID() + ")");
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Successfully resolved SMP endpoint (" + iParticipantIdentifier.getURIEncoded() + ", " + iDocumentTypeIdentifier.getURIEncoded() + ", " + iProcessIdentifier.getURIEncoded() + ", " + this.m_aTP.getID() + ")");
                }
            }
            catch (SMPClientException sMPClientException) {
                boolean bl = sMPClientException instanceof SMPClientBadRequestException || sMPClientException instanceof SMPClientBadResponseException || sMPClientException instanceof SMPClientUnauthorizedException || ((Object)((Object)sMPClientException)).getClass().equals(SMPClientException.class);
                throw new Phase4SMPException("Failed to resolve SMP endpoint (" + iParticipantIdentifier.getURIEncoded() + ", " + iDocumentTypeIdentifier.getURIEncoded() + ", " + iProcessIdentifier.getURIEncoded() + ", " + this.m_aTP.getID() + ")", sMPClientException).setRetryFeasible(bl);
            }
        }
    }

    @Override
    @Nullable
    public X509Certificate getReceiverAPCertificate() throws Phase4Exception {
        try {
            return BDXR2ClientReadOnly.getEndpointCertificate((EndpointType)this.m_aEndpoint);
        }
        catch (CertificateException certificateException) {
            throw new Phase4Exception("Failed to extract AP certificate from SMP endpoint: " + String.valueOf(this.m_aEndpoint), (Throwable)certificateException).setRetryFeasible(false);
        }
    }

    @Override
    @Nonnull
    @Nonempty
    public String getReceiverAPEndpointURL() throws Phase4Exception {
        String string = BDXR2ClientReadOnly.getEndpointAddress((EndpointType)this.m_aEndpoint);
        if (StringHelper.isEmpty((String)string)) {
            throw new Phase4Exception("Failed to determine the destination URL from the SMP endpoint: " + String.valueOf(this.m_aEndpoint));
        }
        return string;
    }

    @Override
    @Nullable
    public String getReceiverTechnicalContact() throws Phase4Exception {
        return this.m_aEndpoint.getContactValue();
    }

    public String toString() {
        return new ToStringGenerator(null).append("SMPClient", (Object)this.m_aSMPClient).append("TransportProfile", (Object)this.m_aTP).appendIfNotNull("Endpoint", (Object)this.m_aEndpoint).getToString();
    }
}

