/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.dump;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.base.trait.IGenericImplTrait;
import com.helger.collection.commons.ICommonsList;
import com.helger.http.CHttp;
import com.helger.http.header.HttpHeaderMap;
import com.helger.phase4.dump.IAS4OutgoingDumper;
import com.helger.phase4.incoming.IAS4IncomingMessageMetadata;
import com.helger.phase4.incoming.IAS4IncomingMessageState;
import com.helger.phase4.messaging.EAS4MessageMode;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public abstract class AbstractAS4OutgoingDumperWithHeaders<IMPLTYPE extends AbstractAS4OutgoingDumperWithHeaders<IMPLTYPE>>
implements IAS4OutgoingDumper,
IGenericImplTrait<IMPLTYPE> {
    public static final boolean DEFAULT_INCLUDE_HEADERS = true;
    private boolean m_bIncludeHeaders = true;

    public final boolean isIncludeHeaders() {
        return this.m_bIncludeHeaders;
    }

    public final IMPLTYPE setIncludeHeaders(boolean bl) {
        this.m_bIncludeHeaders = bl;
        return (IMPLTYPE)((AbstractAS4OutgoingDumperWithHeaders)this.thisAsT());
    }

    @Nullable
    protected abstract OutputStream openOutputStream(@Nonnull EAS4MessageMode var1, @Nullable IAS4IncomingMessageMetadata var2, @Nullable IAS4IncomingMessageState var3, @Nonnull @Nonempty String var4, @Nullable HttpHeaderMap var5, @Nonnegative int var6) throws IOException;

    @Override
    @Nullable
    public OutputStream onBeginRequest(@Nonnull EAS4MessageMode eAS4MessageMode, @Nullable IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nullable IAS4IncomingMessageState iAS4IncomingMessageState, @Nonnull @Nonempty String string, @Nullable HttpHeaderMap httpHeaderMap, @Nonnegative int n) throws IOException {
        OutputStream outputStream = this.openOutputStream(eAS4MessageMode, iAS4IncomingMessageMetadata, iAS4IncomingMessageState, string, httpHeaderMap, n);
        if (outputStream != null && httpHeaderMap != null && httpHeaderMap.isNotEmpty() && this.m_bIncludeHeaders) {
            for (Map.Entry entry : httpHeaderMap) {
                String string2 = (String)entry.getKey();
                for (String string3 : (ICommonsList)entry.getValue()) {
                    String string4 = HttpHeaderMap.getUnifiedValue((String)string3, (boolean)false);
                    String string5 = string2 + ": " + string4 + "\r\n";
                    outputStream.write(string5.getBytes(CHttp.HTTP_CHARSET));
                }
            }
            outputStream.write("\r\n".getBytes(CHttp.HTTP_CHARSET));
        }
        return outputStream;
    }

    @Override
    public void onEndRequest(@Nonnull EAS4MessageMode eAS4MessageMode, @Nullable IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nullable IAS4IncomingMessageState iAS4IncomingMessageState, @Nonnull @Nonempty String string, @Nullable Exception exception) {
    }
}

