/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.duplicate;

import com.helger.annotation.misc.ContainsSoftMigration;
import com.helger.phase4.duplicate.AS4DuplicateItem;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class AS4DuplicateItemMicroTypeConverter
implements IMicroTypeConverter<AS4DuplicateItem> {
    private static final String ATTR_DT = "dt";
    private static final String ATTR_MESSAGE_ID = "msgid";
    private static final String ATTR_PROFILE_ID = "profileid";
    private static final String ATTR_PMODE_ID = "pmodeid";

    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull AS4DuplicateItem aS4DuplicateItem, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttributeWithConversion(ATTR_DT, (Object)aS4DuplicateItem.getDateTime());
        microElement.setAttribute(ATTR_MESSAGE_ID, aS4DuplicateItem.getMessageID());
        microElement.setAttribute(ATTR_PROFILE_ID, aS4DuplicateItem.getProfileID());
        microElement.setAttribute(ATTR_PMODE_ID, aS4DuplicateItem.getPModeID());
        return microElement;
    }

    @Nonnull
    @ContainsSoftMigration
    public AS4DuplicateItem convertToNative(@Nonnull IMicroElement iMicroElement) {
        Object object;
        OffsetDateTime offsetDateTime = (OffsetDateTime)iMicroElement.getAttributeValueWithConversion(ATTR_DT, OffsetDateTime.class);
        if (offsetDateTime == null && (object = (LocalDateTime)iMicroElement.getAttributeValueWithConversion(ATTR_DT, LocalDateTime.class)) != null) {
            offsetDateTime = OffsetDateTime.of((LocalDateTime)object, ZoneOffset.UTC);
        }
        object = iMicroElement.getAttributeValue(ATTR_MESSAGE_ID);
        String string = iMicroElement.getAttributeValue(ATTR_PROFILE_ID);
        String string2 = iMicroElement.getAttributeValue(ATTR_PMODE_ID);
        return new AS4DuplicateItem(offsetDateTime, (String)object, string, string2);
    }
}

