/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.incoming.soap;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.io.stream.HasInputStream;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.state.ESuccess;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.io.file.FileHelper;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.attachment.WSS4JAttachmentCallbackHandler;
import com.helger.phase4.config.AS4Configuration;
import com.helger.phase4.crypto.AS4SigningParams;
import com.helger.phase4.crypto.ECryptoAlgorithmSign;
import com.helger.phase4.crypto.ECryptoAlgorithmSignDigest;
import com.helger.phase4.crypto.ECryptoMode;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.crypto.IAS4DecryptParameterModifier;
import com.helger.phase4.ebms3header.Ebms3Error;
import com.helger.phase4.ebms3header.Ebms3UserMessage;
import com.helger.phase4.incoming.AS4IncomingMessageState;
import com.helger.phase4.incoming.soap.AS4KeyStoreCallbackHandler;
import com.helger.phase4.incoming.soap.ISoapHeaderElementProcessor;
import com.helger.phase4.logging.Phase4LoggerFactory;
import com.helger.phase4.model.error.EEbmsError;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.leg.PModeLeg;
import com.helger.phase4.wss.WSSConfigManager;
import com.helger.phase4.wss.WSSSynchronizer;
import com.helger.xml.XMLHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Provider;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.function.Supplier;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.wss4j.common.crypto.AlgorithmSuite;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SoapHeaderElementProcessorWSS4J
implements ISoapHeaderElementProcessor {
    public static final QName QNAME_SECURITY = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
    private static final Logger LOGGER = Phase4LoggerFactory.getLogger(SoapHeaderElementProcessorWSS4J.class);
    private final IAS4CryptoFactory m_aCryptoFactorySign;
    private final IAS4CryptoFactory m_aCryptoFactoryCrypt;
    private final Provider m_aSecurityProviderSignVerify;
    private final Supplier<? extends IPMode> m_aFallbackPModeProvider;
    private final IAS4DecryptParameterModifier m_aDecryptParameterModifier;
    private final AS4SigningParams m_aSigningParams;

    public SoapHeaderElementProcessorWSS4J(@Nonnull IAS4CryptoFactory iAS4CryptoFactory, @Nonnull IAS4CryptoFactory iAS4CryptoFactory2, @Nullable Provider provider, @Nonnull Supplier<? extends IPMode> supplier, @Nullable IAS4DecryptParameterModifier iAS4DecryptParameterModifier, @Nullable AS4SigningParams aS4SigningParams) {
        ValueEnforcer.notNull((Object)iAS4CryptoFactory, (String)"CryptoFactorySign");
        ValueEnforcer.notNull((Object)iAS4CryptoFactory2, (String)"CryptoFactoryCrypt");
        ValueEnforcer.notNull(supplier, (String)"FallbackPModeProvider");
        this.m_aCryptoFactorySign = iAS4CryptoFactory;
        this.m_aCryptoFactoryCrypt = iAS4CryptoFactory2;
        this.m_aSecurityProviderSignVerify = provider;
        this.m_aFallbackPModeProvider = supplier;
        this.m_aDecryptParameterModifier = iAS4DecryptParameterModifier;
        this.m_aSigningParams = aS4SigningParams;
    }

    @Nonnull
    private ESuccess _verifyAndDecrypt(@Nonnull Document document, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull AS4IncomingMessageState aS4IncomingMessageState, @Nonnull ICommonsList<Ebms3Error> iCommonsList2, @Nonnull Supplier<? extends WSSConfig> supplier) {
        Locale locale = aS4IncomingMessageState.getLocale();
        try {
            Object object;
            Object object2;
            Object object3;
            AlgorithmSuite algorithmSuite;
            PModeLeg pModeLeg;
            AS4KeyStoreCallbackHandler aS4KeyStoreCallbackHandler = new AS4KeyStoreCallbackHandler(this.m_aCryptoFactoryCrypt);
            WSS4JAttachmentCallbackHandler wSS4JAttachmentCallbackHandler = new WSS4JAttachmentCallbackHandler((Iterable<? extends WSS4JAttachment>)iCommonsList, aS4IncomingMessageState.getResourceHelper());
            WSSConfig wSSConfig = supplier.get();
            if (this.m_aDecryptParameterModifier != null) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Before modifyWSSConfig");
                }
                this.m_aDecryptParameterModifier.modifyWSSConfig(wSSConfig);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("After modifyWSSConfig");
                }
            }
            LOGGER.info("phase4 --- verify-decrypt:start");
            RequestData requestData = new RequestData();
            requestData.setCallbackHandler((CallbackHandler)aS4KeyStoreCallbackHandler);
            if (iCommonsList.isNotEmpty()) {
                requestData.setAttachmentCallbackHandler((CallbackHandler)wSS4JAttachmentCallbackHandler);
            }
            requestData.setSigVerCrypto(this.m_aCryptoFactorySign.getCrypto(ECryptoMode.DECRYPT_VERIFY));
            requestData.setDecCrypto(this.m_aCryptoFactoryCrypt.getCrypto(ECryptoMode.DECRYPT_VERIFY));
            requestData.setWssConfig(wSSConfig);
            requestData.setSignatureProvider(this.m_aSecurityProviderSignVerify);
            if (AS4Configuration.getConfig().getAsBoolean((Object)"phase4.incoming.verify.algorithms", true) && (pModeLeg = aS4IncomingMessageState.getEffectivePModeLeg()) != null && pModeLeg.getSecurity() != null) {
                algorithmSuite = new AlgorithmSuite();
                boolean bl = false;
                if (pModeLeg.getSecurity().getX509EncryptionAlgorithm() != null) {
                    object3 = pModeLeg.getSecurity().getX509EncryptionAlgorithm().getAlgorithmURI();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Testing that the received message was encrypted with algorithm '" + (String)object3 + "'");
                    }
                    algorithmSuite.addEncryptionMethod((String)object3);
                    bl = true;
                }
                if (pModeLeg.getSecurity().getX509SignatureAlgorithm() != null) {
                    object3 = pModeLeg.getSecurity().getX509SignatureAlgorithm().getAlgorithmURI();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Testing that the received message was signed with algorithm '" + (String)object3 + "'");
                    }
                    algorithmSuite.addSignatureMethod((String)object3);
                    bl = true;
                }
                if (bl) {
                    requestData.setAlgorithmSuite(algorithmSuite);
                }
            }
            PModeLeg pModeLeg2 = pModeLeg = this.m_aSigningParams != null && this.m_aSigningParams.hasSubjectCertConstraints() ? this.m_aSigningParams.getAllSubjectCertConstraints() : null;
            if (pModeLeg != null) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Applying setSubjectCertConstraints");
                }
                requestData.setSubjectCertConstraints((Collection)((Object)pModeLeg));
            }
            if (this.m_aDecryptParameterModifier != null) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Before modifyRequestData");
                }
                this.m_aDecryptParameterModifier.modifyRequestData(requestData);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("After modifyRequestData");
                }
            }
            algorithmSuite = new WSSecurityEngine();
            algorithmSuite.setWssConfig(wSSConfig);
            WSHandlerResult wSHandlerResult = algorithmSuite.processSecurityHeader(document, requestData);
            if (wSHandlerResult != null) {
                object3 = wSHandlerResult.getResults();
                LOGGER.info("phase4 --- verify-decrypt:end -- " + object3.size() + " results");
            } else {
                LOGGER.info("phase4 --- verify-decrypt:end -- found no security header");
                object3 = new CommonsArrayList();
            }
            X509Certificate x509Certificate = null;
            X509Certificate x509Certificate2 = null;
            int n = 0;
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                object2 = (WSSecurityEngineResult)iterator.next();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("WSSecurityEngineResult: " + String.valueOf(object2));
                }
                int n2 = (object = (Integer)object2.get((Object)"action")) != null ? (Integer)object : 0;
                n |= n2;
                X509Certificate x509Certificate3 = (X509Certificate)object2.get((Object)"x509-certificate");
                if (x509Certificate3 == null) continue;
                if (n2 == 2) {
                    if (x509Certificate == null) {
                        x509Certificate = x509Certificate3;
                        continue;
                    }
                    if (x509Certificate == x509Certificate3) continue;
                    LOGGER.warn("Found a second signing certificate");
                    continue;
                }
                if (n2 != 4) continue;
                if (x509Certificate2 == null) {
                    x509Certificate2 = x509Certificate3;
                    continue;
                }
                if (x509Certificate2 == x509Certificate3) continue;
                LOGGER.warn("Found a second decryption certificate");
            }
            aS4IncomingMessageState.setSoapWSS4JSecurityActions(n);
            aS4IncomingMessageState.setSigningCertificate(x509Certificate);
            aS4IncomingMessageState.setDecryptingCertificate(x509Certificate2);
            aS4IncomingMessageState.setDecryptedSoapDocument(document);
            LOGGER.info("phase4 --- attachment.storetemp:start");
            iterator = wSS4JAttachmentCallbackHandler.getAllResponseAttachments();
            object2 = iterator.iterator();
            while (object2.hasNext()) {
                object = (WSS4JAttachment)object2.next();
                File file = aS4IncomingMessageState.getResourceHelper().createTempFile();
                if (StreamHelper.copyByteStream().from(((WSS4JAttachment)object).getSourceStream()).closeFrom(true).to((OutputStream)FileHelper.getBufferedOutputStream((File)file)).closeTo(true).build().isFailure()) {
                    LOGGER.error("Failed to write response attachment to temporary file '" + file.getAbsolutePath() + "'");
                }
                ((WSS4JAttachment)object).setSourceStreamProvider((IHasInputStream)HasInputStream.multiple(() -> FileHelper.getBufferedInputStream((File)file)));
            }
            aS4IncomingMessageState.setDecryptedAttachments((ICommonsList<WSS4JAttachment>)iterator);
            LOGGER.info("phase4 --- attachment.storetemp:end");
            return ESuccess.SUCCESS;
        }
        catch (IllegalStateException | IndexOutOfBoundsException | WSSecurityException throwable) {
            Object object = "Error processing the WSSecurity Header";
            if (throwable instanceof WSSecurityException) {
                object = (String)object + " (WS Security error: " + String.valueOf(((WSSecurityException)throwable).getErrorCode()) + ")";
            }
            LOGGER.error((String)object, throwable);
            iCommonsList2.add((Object)EEbmsError.EBMS_FAILED_DECRYPTION.errorBuilder(locale).errorDetail((String)object, throwable).build());
            aS4IncomingMessageState.setSoapWSS4JException((Exception)throwable);
            return ESuccess.FAILURE;
        }
        catch (IOException iOException) {
            LOGGER.error("IO error processing the WSSSecurity Header", (Throwable)iOException);
            iCommonsList2.add((Object)EEbmsError.EBMS_OTHER.errorBuilder(locale).errorDetail("IO error processing the WSSSecurity Header", iOException).build());
            aS4IncomingMessageState.setSoapWSS4JException(iOException);
            return ESuccess.FAILURE;
        }
    }

    @Override
    @Nonnull
    public ESuccess processHeaderElement(@Nonnull Document document, @Nonnull Element element, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull AS4IncomingMessageState aS4IncomingMessageState, @Nonnull ICommonsList<Ebms3Error> iCommonsList2) {
        aS4IncomingMessageState.setCryptoFactorySign(this.m_aCryptoFactorySign);
        aS4IncomingMessageState.setCryptoFactoryCrypt(this.m_aCryptoFactoryCrypt);
        IPMode iPMode = aS4IncomingMessageState.getPMode();
        if (iPMode == null) {
            iPMode = this.m_aFallbackPModeProvider.get();
        }
        if (iPMode == null) {
            throw new IllegalStateException("No PMode contained in AS4 state - seems like Ebms3 Messaging header is missing!");
        }
        Locale locale = aS4IncomingMessageState.getLocale();
        PModeLeg pModeLeg = iPMode.getLeg1();
        Ebms3UserMessage ebms3UserMessage = aS4IncomingMessageState.getEbmsUserMessage();
        if (ebms3UserMessage != null && StringHelper.isNotEmpty((String)ebms3UserMessage.getMessageInfo().getRefToMessageId())) {
            pModeLeg = iPMode.getLeg2();
        }
        if (pModeLeg.getSecurity() != null) {
            Object object;
            Object object2;
            Element element2;
            Element element3 = XMLHelper.getFirstChildElementOfName((Node)element, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
            if (element3 != null) {
                element2 = XMLHelper.getFirstChildElementOfName((Node)(element3 = XMLHelper.getFirstChildElementOfName((Node)element3, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"SignedInfo")), (String)"http://www.w3.org/2000/09/xmldsig#", (String)"SignatureMethod");
                String string = element2 == null ? null : element2.getAttribute("Algorithm");
                object2 = ECryptoAlgorithmSign.getFromURIOrNull(string);
                if (object2 == null) {
                    String string2 = "Error processing the Security Header, your signing algorithm '" + string + "' is incorrect. Expected one of the following '" + Arrays.toString(ECryptoAlgorithmSign.values()) + "' algorithms";
                    LOGGER.error(string2);
                    iCommonsList2.add((Object)EEbmsError.EBMS_FAILED_AUTHENTICATION.errorBuilder(locale).errorDetail(string2).build());
                    return ESuccess.FAILURE;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Using signature algorithm " + String.valueOf(object2));
                }
                element3 = XMLHelper.getFirstChildElementOfName((Node)element3, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Reference");
                string = (element3 = XMLHelper.getFirstChildElementOfName((Node)element3, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"DigestMethod")) == null ? null : element3.getAttribute("Algorithm");
                object = ECryptoAlgorithmSignDigest.getFromURIOrNull(string);
                if (object == null) {
                    String string3 = "Error processing the Security Header - the signing digest algorithm is incorrect. Expected one of the following algorithms: '" + Arrays.toString(ECryptoAlgorithmSignDigest.values()) + "'";
                    LOGGER.error(string3);
                    iCommonsList2.add((Object)EEbmsError.EBMS_FAILED_AUTHENTICATION.errorBuilder(locale).errorDetail(string3).build());
                    return ESuccess.FAILURE;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Using signature digest algorithm " + String.valueOf(object));
                }
            }
            if (ebms3UserMessage != null) {
                boolean bl = aS4IncomingMessageState.isSoapBodyPayloadPresent();
                for (int i = 0; i < iCommonsList.size(); ++i) {
                    object2 = (String)((WSS4JAttachment)iCommonsList.get(i)).getHeaders().get("Content-ID");
                    if (StringHelper.isEmpty((String)object2)) {
                        LOGGER.error("The provided attachment ID in the 'Content-ID' header may not be empty.");
                        iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(locale).errorDetail("The provided attachment ID in the 'Content-ID' header may not be empty.").build());
                        return ESuccess.FAILURE;
                    }
                    if (!((String)object2).startsWith("<attachment=")) {
                        object = "The provided attachment ID '" + (String)object2 + "' in the 'Content-ID' header does not start with the required prefix '<attachment='";
                        LOGGER.error((String)object);
                        iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(locale).errorDetail((String)object).build());
                        return ESuccess.FAILURE;
                    }
                    if (!((String)object2).endsWith(">")) {
                        object = "The provided attachment ID '" + (String)object2 + "' in the 'Content-ID' header does not end with the required suffix '>'";
                        LOGGER.error((String)object);
                        iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(locale).errorDetail((String)object).build());
                        return ESuccess.FAILURE;
                    }
                    object2 = ((String)object2).substring("<attachment=".length(), ((String)object2).length() - ">".length());
                    object = ebms3UserMessage.getPayloadInfo().getPartInfoAtIndex((bl ? 1 : 0) + i).getHref();
                    if (((String)object).contains((CharSequence)object2)) continue;
                    String string = "The usermessage part information '" + (String)object + "' does not reference the respective attachment ID '" + (String)object2 + "'";
                    LOGGER.error(string);
                    iCommonsList2.add((Object)EEbmsError.EBMS_VALUE_INCONSISTENT.errorBuilder(locale).errorDetail(string).build());
                    return ESuccess.FAILURE;
                }
            }
            if ((element2 = AS4Configuration.isWSS4JSynchronizedSecurity() ? (ESuccess)WSSSynchronizer.call(() -> this._verifyAndDecrypt(document, iCommonsList, aS4IncomingMessageState, iCommonsList2, WSSConfigManager::createStaticWSSConfig)) : this._verifyAndDecrypt(document, iCommonsList, aS4IncomingMessageState, iCommonsList2, WSSConfigManager.getInstance()::createWSSConfig)).isFailure()) {
                return ESuccess.FAILURE;
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("PMode leg has no security defined - skipping Verification and Decryption step");
        }
        return ESuccess.SUCCESS;
    }
}

