/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.messaging.mime;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.http.header.HttpHeaderMap;
import com.helger.mail.cte.EContentTransferEncoding;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.messaging.mime.AS4MimeMessage;
import com.helger.phase4.messaging.mime.AS4SoapMimeMultipart;
import com.helger.phase4.messaging.mime.DataContentHandlerSoap12;
import com.helger.phase4.model.ESoapVersion;
import com.helger.phase4.util.AS4XMLHelper;
import jakarta.activation.CommandMap;
import jakarta.activation.DataHandler;
import jakarta.activation.MailcapCommandMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.mail.BodyPart;
import jakarta.mail.Header;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import java.nio.charset.Charset;
import java.util.function.BiConsumer;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;

public final class AS4MimeMessageHelper {
    private AS4MimeMessageHelper() {
    }

    @Nonnull
    public static AS4MimeMessage generateMimeMessage(@Nonnull ESoapVersion eSoapVersion, @Nonnull Document document, @Nullable ICommonsList<WSS4JAttachment> iCommonsList) throws MessagingException {
        ValueEnforcer.notNull((Object)((Object)eSoapVersion), (String)"SoapVersion");
        ValueEnforcer.notNull((Object)document, (String)"SoapEnvelope");
        Charset charset = AS4XMLHelper.XWS.getCharset();
        AS4SoapMimeMultipart aS4SoapMimeMultipart = new AS4SoapMimeMultipart(eSoapVersion);
        EContentTransferEncoding eContentTransferEncoding = EContentTransferEncoding.BINARY;
        String string = eSoapVersion.getMimeType(charset).getAsString();
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setDataHandler(new DataHandler((Object)new DOMSource(document), string));
        mimeBodyPart.setHeader("Content-Transfer-Encoding", eContentTransferEncoding.getID());
        aS4SoapMimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
        boolean bl = true;
        if (iCommonsList != null) {
            for (WSS4JAttachment wSS4JAttachment : iCommonsList) {
                wSS4JAttachment.addToMimeMultipart(aS4SoapMimeMultipart);
                if (wSS4JAttachment.isRepeatable()) continue;
                bl = false;
            }
        }
        Object object = new AS4MimeMessage((Session)null, bl);
        object.setContent((Multipart)aS4SoapMimeMultipart);
        object.saveChanges();
        return object;
    }

    public static void forEachHeaderAndRemoveAfterwards(@Nonnull MimeMessage mimeMessage, @Nonnull BiConsumer<String, String> biConsumer, boolean bl) throws MessagingException {
        CommonsArrayList commonsArrayList = new CommonsArrayList(mimeMessage.getAllHeaders());
        for (Header header : commonsArrayList) {
            biConsumer.accept(header.getName(), bl ? HttpHeaderMap.getUnifiedValue((String)header.getValue()) : header.getValue());
        }
        for (Header header : commonsArrayList) {
            mimeMessage.removeHeader(header.getName());
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public static HttpHeaderMap getAndRemoveAllHeaders(@Nonnull MimeMessage mimeMessage) throws MessagingException {
        HttpHeaderMap httpHeaderMap = new HttpHeaderMap();
        AS4MimeMessageHelper.forEachHeaderAndRemoveAfterwards(mimeMessage, (arg_0, arg_1) -> ((HttpHeaderMap)httpHeaderMap).addHeader(arg_0, arg_1), false);
        return httpHeaderMap;
    }

    static {
        MailcapCommandMap mailcapCommandMap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mailcapCommandMap.addMailcap(ESoapVersion.SOAP_12.getMimeType().getAsStringWithoutParameters() + ";; x-java-content-handler=" + DataContentHandlerSoap12.class.getName());
        CommandMap.setDefaultCommandMap((CommandMap)mailcapCommandMap);
    }
}

