/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.error;

import com.helger.base.lang.EnumHelper;
import com.helger.base.string.StringHelper;
import com.helger.diagnostics.error.IError;
import com.helger.phase4.model.error.EEbmsErrorCategory;
import com.helger.phase4.model.error.EEbmsErrorSeverity;
import com.helger.phase4.model.error.EEbmsErrorText;
import com.helger.phase4.model.error.IEbmsError;
import com.helger.text.display.IHasDisplayText;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public enum EEbmsError implements IEbmsError
{
    EBMS_VALUE_NOT_RECOGNIZED("EBMS:0001", EEbmsErrorSeverity.FAILURE, "ValueNotRecognized", EEbmsErrorText.VALUE_NOT_RECOGNIZED, EEbmsErrorCategory.CONTENT),
    EBMS_FEATURE_NOT_SUPPORTED("EBMS:0002", EEbmsErrorSeverity.WARNING, "FeatureNotSupported", EEbmsErrorText.FEATURE_NOT_SUPPORTED, EEbmsErrorCategory.CONTENT),
    EBMS_VALUE_INCONSISTENT("EBMS:0003", EEbmsErrorSeverity.FAILURE, "ValueInConsistent", EEbmsErrorText.VALUE_INCONSISTENT, EEbmsErrorCategory.CONTENT),
    EBMS_OTHER("EBMS:0004", EEbmsErrorSeverity.FAILURE, "Other", EEbmsErrorText.OTHER, EEbmsErrorCategory.CONTENT),
    EBMS_CONNECTION_FAILURE("EBMS:0005", EEbmsErrorSeverity.WARNING, "ConnectionFailure", EEbmsErrorText.CONNECTION_FAILURE, EEbmsErrorCategory.COMMUNICATION),
    EBMS_EMPTY_MESSAGE_PARTITION_CHANNEL("EBMS:0006", EEbmsErrorSeverity.FAILURE, "EmptyMessagePartitionChannel", EEbmsErrorText.EMPTY_MESSAGE_PARTITION_CHANNEL, EEbmsErrorCategory.COMMUNICATION),
    EBMS_MIME_INCONSISTENCY("EBMS:0007", EEbmsErrorSeverity.FAILURE, "MimeInconsistency", EEbmsErrorText.MIME_INCONSISTENCY, EEbmsErrorCategory.UNPACKAGING),
    EBMS_FEATURE_NOT_SUPPORTED_INCONSISTENCY("EBMS:0008", EEbmsErrorSeverity.FAILURE, "FeatureNotSupportedInconsistency", EEbmsErrorText.FEATURE_NOT_SUPPORTED_INCONSISTENT, EEbmsErrorCategory.UNPACKAGING),
    EBMS_INVALID_HEADER("EBMS:0009", EEbmsErrorSeverity.FAILURE, "InvalidHeader", EEbmsErrorText.INVALID_HEADER, EEbmsErrorCategory.UNPACKAGING),
    EBMS_PROCESSING_MODE_MISMATCH("EBMS:0010", EEbmsErrorSeverity.FAILURE, "ProcessingModeMismatch", EEbmsErrorText.PROCESSING_MODE_MISMATCH, EEbmsErrorCategory.PROCESSING),
    EBMS_EXTERNAL_PAYLOAD_ERROR("EBMS:0011", EEbmsErrorSeverity.FAILURE, "ExternalPayloadError", EEbmsErrorText.EXTERNAL_PAYLOAD_ERROR, EEbmsErrorCategory.PROCESSING),
    EBMS_FAILED_AUTHENTICATION("EBMS:0101", EEbmsErrorSeverity.FAILURE, "FailedAuthentication", EEbmsErrorText.FAILED_AUTHENTICATION, EEbmsErrorCategory.PROCESSING),
    EBMS_FAILED_DECRYPTION("EBMS:0102", EEbmsErrorSeverity.FAILURE, "FailedDecryption", EEbmsErrorText.FAILED_DECRYPTION, EEbmsErrorCategory.PROCESSING),
    EBMS_POLICY_NONCOMPLIANCE("EBMS:0103", EEbmsErrorSeverity.FAILURE, "PolicyNoncompliance", EEbmsErrorText.POLICY_NONCOMPLIANCE, EEbmsErrorCategory.PROCESSING),
    EBMS_DYSFUNCTIONAL_RELIABILITY("EBMS:0201", EEbmsErrorSeverity.FAILURE, "DysfunctionalReliability", EEbmsErrorText.DYSFUNCTIONAL_RELIABILITY, EEbmsErrorCategory.PROCESSING),
    EBMS_DELIVERY_FAILURE("EBMS:0202", EEbmsErrorSeverity.FAILURE, "DeliveryFailure", EEbmsErrorText.DELIVERY_FAILURE, EEbmsErrorCategory.COMMUNICATION),
    EBMS_MISSING_RECEIPT("EBMS:0301", EEbmsErrorSeverity.FAILURE, "MissingReceipt", EEbmsErrorText.MISSING_RECEIPT, EEbmsErrorCategory.COMMUNICATION),
    EBMS_INVALID_RECEIPT("EBMS:0302", EEbmsErrorSeverity.FAILURE, "InvalidReceipt", EEbmsErrorText.INVALID_RECEIPT, EEbmsErrorCategory.COMMUNICATION),
    EBMS_DECOMPRESSION_FAILURE("EBMS:0303", EEbmsErrorSeverity.FAILURE, "DecompressionFailure", EEbmsErrorText.DECOMPRESSION_FAILURE, EEbmsErrorCategory.COMMUNICATION);

    private final String m_sErrorCode;
    private final EEbmsErrorSeverity m_eSeverity;
    private final String m_sShortDescription;
    private final IHasDisplayText m_aDescription;
    private final EEbmsErrorCategory m_eCategory;

    private EEbmsError(@Nonnull String string2, @Nonnull EEbmsErrorSeverity eEbmsErrorSeverity, @Nonnull String string3, IHasDisplayText iHasDisplayText, EEbmsErrorCategory eEbmsErrorCategory) {
        this.m_sErrorCode = string2;
        this.m_eSeverity = eEbmsErrorSeverity;
        this.m_sShortDescription = string3;
        this.m_aDescription = iHasDisplayText;
        this.m_eCategory = eEbmsErrorCategory;
    }

    @Override
    @Nonnull
    public String getErrorCode() {
        return this.m_sErrorCode;
    }

    @Override
    @Nonnull
    public EEbmsErrorSeverity getSeverity() {
        return this.m_eSeverity;
    }

    @Override
    @Nonnull
    public String getShortDescription() {
        return this.m_sShortDescription;
    }

    @Override
    @Nonnull
    public IHasDisplayText getDescription() {
        return this.m_aDescription;
    }

    @Override
    @Nonnull
    public EEbmsErrorCategory getCategory() {
        return this.m_eCategory;
    }

    @Nullable
    public static EEbmsError getFromErrorCodeOrNull(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        return (EEbmsError)EnumHelper.findFirst(EEbmsError.class, eEbmsError -> eEbmsError.getErrorCode().equals(string));
    }

    @Nullable
    public static EEbmsError getFromIErrorOrNull(@Nullable IError iError) {
        if (iError == null) {
            return null;
        }
        return EEbmsError.getFromErrorCodeOrNull(iError.getErrorID());
    }
}

