/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode.leg;

import com.helger.base.state.EMandatory;
import com.helger.mime.IMimeType;
import com.helger.mime.MimeType;
import com.helger.mime.parse.MimeTypeParser;
import com.helger.mime.parse.MimeTypeParserException;
import com.helger.phase4.model.pmode.AbstractPModeMicroTypeConverter;
import com.helger.phase4.model.pmode.leg.PModePayloadProfile;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroQName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class PModePayloadProfileMicroTypeConverter
extends AbstractPModeMicroTypeConverter<PModePayloadProfile> {
    private static final IMicroQName ATTR_NAME = new MicroQName("Name");
    private static final IMicroQName ATTR_MIME_TYPE = new MicroQName("MimeType");
    private static final IMicroQName ATTR_XSD_FILENAME = new MicroQName("XSDFilename");
    private static final IMicroQName ATTR_MAX_SIZE_KB = new MicroQName("MaxSizeKB");
    private static final IMicroQName ATTR_MANDATORY = new MicroQName("Mandatory");

    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull PModePayloadProfile pModePayloadProfile, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_NAME, pModePayloadProfile.getName());
        microElement.setAttribute(ATTR_MIME_TYPE, pModePayloadProfile.getMimeType().getAsString());
        microElement.setAttribute(ATTR_XSD_FILENAME, pModePayloadProfile.getXSDFilename());
        if (pModePayloadProfile.hasMaxSizeKB()) {
            microElement.setAttribute(ATTR_MAX_SIZE_KB, pModePayloadProfile.getMaxSizeKB().intValue());
        }
        microElement.setAttribute(ATTR_MANDATORY, pModePayloadProfile.isMandatory());
        return microElement;
    }

    @Nonnull
    public PModePayloadProfile convertToNative(IMicroElement iMicroElement) {
        MimeType mimeType;
        String string = iMicroElement.getAttributeValue(ATTR_NAME);
        String string2 = iMicroElement.getAttributeValue(ATTR_MIME_TYPE);
        try {
            mimeType = MimeTypeParser.parseMimeType((String)string2);
        }
        catch (MimeTypeParserException mimeTypeParserException) {
            throw new IllegalArgumentException("Failed to parse MIME Type '" + string2 + "'", mimeTypeParserException);
        }
        String string3 = iMicroElement.getAttributeValue(ATTR_XSD_FILENAME);
        Integer n = (Integer)iMicroElement.getAttributeValueWithConversion(ATTR_MAX_SIZE_KB, Integer.class);
        EMandatory eMandatory = EMandatory.valueOf((boolean)iMicroElement.getAttributeValueAsBool(ATTR_MANDATORY, false));
        return new PModePayloadProfile(string, (IMimeType)mimeType, string3, n, eMandatory);
    }
}

