/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.peppol.servlet;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.IsSPIImplementation;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.datetime.XMLOffsetDateTime;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.error.IError;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.commons.string.StringHelper;
import com.helger.peppol.reporting.api.PeppolReportingItem;
import com.helger.peppol.sbdh.PeppolSBDHData;
import com.helger.peppol.sbdh.PeppolSBDHDataReadException;
import com.helger.peppol.sbdh.PeppolSBDHDataReader;
import com.helger.peppol.smp.ESMPTransportProfile;
import com.helger.peppol.smp.ISMPTransportProfile;
import com.helger.peppol.utils.PeppolCertificateHelper;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.peppolid.factory.IIdentifierFactory;
import com.helger.phase4.attachment.AS4DecompressException;
import com.helger.phase4.attachment.EAS4CompressionMode;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.ebms3header.Ebms3Error;
import com.helger.phase4.ebms3header.Ebms3SignalMessage;
import com.helger.phase4.ebms3header.Ebms3UserMessage;
import com.helger.phase4.incoming.IAS4IncomingMessageMetadata;
import com.helger.phase4.incoming.IAS4IncomingMessageState;
import com.helger.phase4.incoming.spi.AS4MessageProcessorResult;
import com.helger.phase4.incoming.spi.AS4SignalMessageProcessorResult;
import com.helger.phase4.incoming.spi.IAS4IncomingMessageProcessorSPI;
import com.helger.phase4.mgr.MetaAS4Manager;
import com.helger.phase4.model.error.EEbmsError;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.peppol.servlet.IPhase4PeppolIncomingSBDHandlerSPI;
import com.helger.phase4.peppol.servlet.Phase4PeppolDefaultReceiverConfiguration;
import com.helger.phase4.peppol.servlet.Phase4PeppolReceiverConfiguration;
import com.helger.phase4.peppol.servlet.Phase4PeppolServletException;
import com.helger.phase4.util.Phase4Exception;
import com.helger.sbdh.SBDMarshaller;
import com.helger.security.certificate.CertificateHelper;
import com.helger.smpclient.peppol.ISMPExtendedServiceMetadataProvider;
import com.helger.smpclient.peppol.PeppolWildcardSelector;
import com.helger.smpclient.peppol.SMPClientReadOnly;
import com.helger.xml.serialize.write.XMLWriter;
import com.helger.xsds.peppol.smp1.EndpointType;
import com.helger.xsds.peppol.smp1.SignedServiceMetadataType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.unece.cefact.namespaces.sbdh.StandardBusinessDocument;
import org.w3c.dom.Node;

@IsSPIImplementation
public class Phase4PeppolServletMessageProcessorSPI
implements IAS4IncomingMessageProcessorSPI {
    public static final ESMPTransportProfile DEFAULT_TRANSPORT_PROFILE = ESMPTransportProfile.TRANSPORT_PROFILE_PEPPOL_AS4_V2;
    private static final Logger LOGGER = LoggerFactory.getLogger(Phase4PeppolServletMessageProcessorSPI.class);
    private ICommonsList<IPhase4PeppolIncomingSBDHandlerSPI> m_aHandlers;
    private ISMPTransportProfile m_aTransportProfile = DEFAULT_TRANSPORT_PROFILE;
    private Phase4PeppolReceiverConfiguration m_aReceiverCheckData;

    @UsedViaReflection
    public Phase4PeppolServletMessageProcessorSPI() {
        this.m_aHandlers = ServiceLoaderHelper.getAllSPIImplementations(IPhase4PeppolIncomingSBDHandlerSPI.class);
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<IPhase4PeppolIncomingSBDHandlerSPI> getAllHandler() {
        return (ICommonsList)this.m_aHandlers.getClone();
    }

    @Nonnull
    public final Phase4PeppolServletMessageProcessorSPI setAllHandler(@Nonnull Iterable<? extends IPhase4PeppolIncomingSBDHandlerSPI> iterable) {
        ValueEnforcer.notNull(iterable, (String)"Handlers");
        this.m_aHandlers = new CommonsArrayList(iterable);
        if (this.m_aHandlers.isEmpty()) {
            LOGGER.warn("Phase4PeppolServletMessageProcessorSPI has an empty handler list - this means incoming messages are only checked and afterwards discarded");
        }
        return this;
    }

    @Nonnull
    public final ISMPTransportProfile getTransportProfile() {
        return this.m_aTransportProfile;
    }

    @Nonnull
    public final Phase4PeppolServletMessageProcessorSPI setTransportProfile(@Nonnull ISMPTransportProfile iSMPTransportProfile) {
        ValueEnforcer.notNull((Object)iSMPTransportProfile, (String)"TransportProfile");
        this.m_aTransportProfile = iSMPTransportProfile;
        return this;
    }

    @Nullable
    public final Phase4PeppolReceiverConfiguration getReceiverCheckData() {
        return this.m_aReceiverCheckData;
    }

    @Nonnull
    public final Phase4PeppolServletMessageProcessorSPI setReceiverCheckData(@Nullable Phase4PeppolReceiverConfiguration phase4PeppolReceiverConfiguration) {
        this.m_aReceiverCheckData = phase4PeppolReceiverConfiguration;
        return this;
    }

    @Nullable
    private EndpointType _getReceiverEndpoint(@Nonnull String string, @Nonnull ISMPExtendedServiceMetadataProvider iSMPExtendedServiceMetadataProvider, @Nullable IParticipantIdentifier iParticipantIdentifier, @Nullable IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nullable IProcessIdentifier iProcessIdentifier, @Nullable PeppolWildcardSelector.EMode eMode) throws Phase4PeppolServletException {
        if (iParticipantIdentifier == null || iDocumentTypeIdentifier == null || iProcessIdentifier == null || eMode == null) {
            return null;
        }
        try {
            SignedServiceMetadataType signedServiceMetadataType;
            boolean bl;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(string + "Looking up the endpoint of recipient " + iParticipantIdentifier.getURIEncoded() + " for " + iParticipantIdentifier.getURIEncoded() + " and " + iDocumentTypeIdentifier.getURIEncoded() + " and " + iProcessIdentifier.getURIEncoded() + " and " + this.m_aTransportProfile.getID() + "; wildcard-mode=" + String.valueOf(eMode));
            }
            EndpointType endpointType = (bl = "peppol-doctype-wildcard".equals(iDocumentTypeIdentifier.getScheme())) ? ((signedServiceMetadataType = iSMPExtendedServiceMetadataProvider.getWildcardServiceMetadataOrNull(iParticipantIdentifier, iDocumentTypeIdentifier, eMode)) == null ? null : SMPClientReadOnly.getEndpoint((SignedServiceMetadataType)signedServiceMetadataType, (IProcessIdentifier)iProcessIdentifier, (ISMPTransportProfile)this.m_aTransportProfile)) : iSMPExtendedServiceMetadataProvider.getEndpoint(iParticipantIdentifier, iDocumentTypeIdentifier, iProcessIdentifier, this.m_aTransportProfile);
            return endpointType;
        }
        catch (Exception exception) {
            throw new Phase4PeppolServletException(string + "Failed to retrieve endpoint of (" + iParticipantIdentifier.getURIEncoded() + ", " + iDocumentTypeIdentifier.getURIEncoded() + ", " + iProcessIdentifier.getURIEncoded() + ", " + this.m_aTransportProfile.getID() + ")", exception);
        }
    }

    private static void _checkIfReceiverEndpointURLMatches(@Nonnull String string, @Nonnull @Nonempty String string2, @Nonnull EndpointType endpointType) throws Phase4PeppolServletException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(string + "Our AP URL is " + string2);
        }
        String string3 = SMPClientReadOnly.getEndpointAddress((EndpointType)endpointType);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(string + "Recipient AP URL from SMP is " + string3);
        }
        if (string3 == null || !string3.contains(string2)) {
            String string4 = string + "Internal error: The request is targeted for '" + string3 + "' and is not for us (" + string2 + ")";
            LOGGER.error(string4);
            throw new Phase4PeppolServletException(string4);
        }
    }

    private static void _checkIfEndpointCertificateMatches(@Nonnull String string, @Nonnull X509Certificate x509Certificate, @Nonnull EndpointType endpointType) throws Phase4PeppolServletException {
        String string2 = endpointType.getCertificate();
        X509Certificate x509Certificate2 = null;
        try {
            x509Certificate2 = CertificateHelper.convertStringToCertficate((String)string2);
        }
        catch (CertificateException certificateException) {
            throw new Phase4PeppolServletException(string + "Internal error: Failed to convert looked up endpoint certificate string '" + string2 + "' to an X.509 certificate!", certificateException);
        }
        if (x509Certificate2 == null) {
            throw new Phase4PeppolServletException(string + "No certificate found in looked up endpoint! Is this AP maybe NOT contained in an SMP?");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(string + "Conformant recipient certificate present: " + x509Certificate2.toString());
        }
        if (!x509Certificate.getSerialNumber().equals(x509Certificate2.getSerialNumber())) {
            String string3 = string + "Certificate retrieved from SMP lookup (" + String.valueOf(x509Certificate2) + ") does not match this APs configured Certificate (" + String.valueOf(x509Certificate) + ") - different serial numbers - ignoring document";
            LOGGER.error(string3);
            throw new Phase4PeppolServletException(string3);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(string + "The certificate of the SMP lookup matches our certificate");
        }
    }

    @Nullable
    public static PeppolReportingItem createPeppolReportingItemForReceivedMessage(@Nonnull Ebms3UserMessage ebms3UserMessage, @Nonnull PeppolSBDHData peppolSBDHData, @Nonnull IAS4IncomingMessageState iAS4IncomingMessageState, @Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3) {
        Object object;
        OffsetDateTime offsetDateTime;
        ValueEnforcer.notNull((Object)ebms3UserMessage, (String)"UserMessage");
        ValueEnforcer.notNull((Object)peppolSBDHData, (String)"PeppolSBD");
        ValueEnforcer.notNull((Object)iAS4IncomingMessageState, (String)"State");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"C3ID");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"C4CountryCode");
        ValueEnforcer.notEmpty((CharSequence)string3, (String)"EndUserID");
        XMLOffsetDateTime xMLOffsetDateTime = ebms3UserMessage.getMessageInfo().getTimestamp();
        if (xMLOffsetDateTime != null) {
            offsetDateTime = xMLOffsetDateTime.getOffset() != null ? xMLOffsetDateTime.toOffsetDateTime() : OffsetDateTime.of(xMLOffsetDateTime.toLocalDateTime(), ZoneOffset.UTC);
        } else {
            object = peppolSBDHData.getCreationDateAndTime();
            if (object != null) {
                offsetDateTime = object.getOffset() != null ? object.toOffsetDateTime() : OffsetDateTime.of(object.toLocalDateTime(), ZoneOffset.UTC);
            } else {
                LOGGER.warn("Incoming messages does not contain a UserMessage/MessageInfo/Timestamp value and no SBDH CreationDateTime. Using current date time");
                offsetDateTime = MetaAS4Manager.getTimestampMgr().getCurrentDateTime();
            }
        }
        object = PeppolCertificateHelper.getSubjectCN((X509Certificate)iAS4IncomingMessageState.getSigningCertificate());
        try {
            String string4 = peppolSBDHData.getCountryC1();
            if (StringHelper.hasNoText((String)string4)) {
                string4 = "ZZ";
            }
            return PeppolReportingItem.builder().exchangeDateTime(offsetDateTime).directionReceiving().c2ID((String)object).c3ID(string).docTypeID(peppolSBDHData.getDocumentTypeAsIdentifier()).processID(peppolSBDHData.getProcessAsIdentifier()).transportProtocolPeppolAS4v2().c1CountryCode(string4).c4CountryCode(string2).endUserID(string3).build();
        }
        catch (IllegalStateException illegalStateException) {
            LOGGER.error("Not all mandatory fields are set. Cannot create Peppol Reporting Item", (Throwable)illegalStateException);
            return null;
        }
    }

    @OverrideOnDemand
    protected void afterSuccessfulPeppolProcessing(@Nonnull Ebms3UserMessage ebms3UserMessage, @Nonnull PeppolSBDHData peppolSBDHData, @Nonnull IAS4IncomingMessageState iAS4IncomingMessageState) {
    }

    @Nonnull
    public AS4MessageProcessorResult processAS4UserMessage(@Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nonnull HttpHeaderMap httpHeaderMap, @Nonnull Ebms3UserMessage ebms3UserMessage, @Nonnull IPMode iPMode, @Nullable Node node, @Nullable ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull IAS4IncomingMessageState iAS4IncomingMessageState, @Nonnull ICommonsList<Ebms3Error> iCommonsList2) {
        Object object;
        Object object22;
        Object object3;
        Object object4;
        Phase4PeppolReceiverConfiguration phase4PeppolReceiverConfiguration;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Invoking processAS4UserMessage");
        }
        String string = ebms3UserMessage.getMessageInfo().getMessageId();
        String string2 = ebms3UserMessage.getCollaborationInfo().getServiceValue();
        String string3 = ebms3UserMessage.getCollaborationInfo().getAction();
        String string4 = ebms3UserMessage.getCollaborationInfo().getConversationId();
        Locale locale = iAS4IncomingMessageState.getLocale();
        String string5 = "[" + string + "] ";
        Phase4PeppolReceiverConfiguration phase4PeppolReceiverConfiguration2 = phase4PeppolReceiverConfiguration = this.m_aReceiverCheckData != null ? this.m_aReceiverCheckData : Phase4PeppolDefaultReceiverConfiguration.getAsReceiverCheckData();
        if (LOGGER.isDebugEnabled()) {
            if (iPMode == null) {
                LOGGER.debug(string5 + "  No Source PMode present");
            } else {
                LOGGER.debug(string5 + "  Source PMode = " + (String)iPMode.getID());
            }
            LOGGER.debug(string5 + "  AS4 Message ID = '" + string + "'");
            LOGGER.debug(string5 + "  AS4 Service = '" + string2 + "'");
            LOGGER.debug(string5 + "  AS4 Action = '" + string3 + "'");
            LOGGER.debug(string5 + "  AS4 ConversationId = '" + string4 + "'");
            if (ebms3UserMessage.getMessageProperties() != null && ebms3UserMessage.getMessageProperties().hasPropertyEntries()) {
                LOGGER.debug(string5 + "  AS4 MessageProperties:");
                for (X509Certificate x509Certificate : ebms3UserMessage.getMessageProperties().getProperty()) {
                    LOGGER.debug(string5 + "    [" + x509Certificate.getName() + "] = [" + x509Certificate.getValue() + "]");
                }
            } else {
                LOGGER.debug(string5 + "  No AS4 Mesage Properties present");
            }
            if (node == null) {
                LOGGER.debug(string5 + "  No SOAP Body Payload present");
            } else {
                LOGGER.debug(string5 + "  SOAP Body Payload = " + XMLWriter.getNodeAsString((Node)node));
            }
        }
        if (!iAS4IncomingMessageState.isSoapDecrypted()) {
            LOGGER.error(string5 + "The received Peppol message seems not to be encrypted (properly).");
            iCommonsList2.add((Object)EEbmsError.EBMS_FAILED_DECRYPTION.errorBuilder(locale).refToMessageInError(string).errorDetail("The received Peppol message seems not to be encrypted (properly).").build());
            return AS4MessageProcessorResult.createFailure();
        }
        if (!iAS4IncomingMessageState.isSoapSignatureChecked()) {
            LOGGER.error(string5 + "The received Peppol message seems not to be signed (properly).");
            iCommonsList2.add((Object)EEbmsError.EBMS_FAILED_AUTHENTICATION.errorBuilder(locale).refToMessageInError(string).errorDetail("The received Peppol message seems not to be signed (properly).").build());
            return AS4MessageProcessorResult.createFailure();
        }
        if (phase4PeppolReceiverConfiguration.isCheckSigningCertificateRevocation()) {
            X509Certificate x509Certificate;
            object4 = MetaAS4Manager.getTimestampMgr().getCurrentDateTime();
            x509Certificate = iAS4IncomingMessageState.getSigningCertificate();
            object3 = phase4PeppolReceiverConfiguration.getAPCAChecker().checkCertificate(x509Certificate, (OffsetDateTime)object4);
            if (object3.isInvalid()) {
                String string6 = "The received Peppol message is signed with a Peppol AP certificate invalid at " + String.valueOf(object4) + ". Rejecting incoming message. Reason: " + object3.getReason();
                LOGGER.error(string5 + string6);
                iCommonsList2.add((Object)EEbmsError.EBMS_FAILED_AUTHENTICATION.errorBuilder(locale).refToMessageInError(string).errorDetail(string6).build());
                return AS4MessageProcessorResult.createFailure();
            }
        } else {
            LOGGER.warn(string5 + "The revocation check of the received signing certificate is disabled.");
        }
        object4 = new CommonsArrayList();
        if (iCommonsList != null) {
            int n = 0;
            for (Object object22 : iCommonsList) {
                Object object5;
                ReadAttachment readAttachment = new ReadAttachment();
                readAttachment.m_sID = object22.getId();
                readAttachment.m_sMimeType = object22.getMimeType();
                readAttachment.m_sUncompressedMimeType = object22.getUncompressedMimeType();
                readAttachment.m_aCharset = object22.getCharset();
                readAttachment.m_eCompressionMode = object22.getCompressionMode();
                try {
                    object5 = object22.getSourceStream();
                    try {
                        object = new NonBlockingByteArrayOutputStream();
                        if (StreamHelper.copyInputStreamToOutputStreamAndCloseOS((InputStream)object5, (OutputStream)object).isSuccess()) {
                            readAttachment.m_aPayloadBytes = object.getBufferOrCopy();
                        }
                    }
                    finally {
                        if (object5 != null) {
                            ((InputStream)object5).close();
                        }
                    }
                }
                catch (AS4DecompressException | IOException throwable) {
                    // empty catch block
                }
                if (readAttachment.m_aPayloadBytes == null) {
                    object5 = "Failed to decompress the payload of attachment #" + n;
                    LOGGER.error(string5 + (String)object5);
                    iCommonsList2.add((Object)EEbmsError.EBMS_DECOMPRESSION_FAILURE.errorBuilder(locale).refToMessageInError(string).errorDetail((String)object5).build());
                    return AS4MessageProcessorResult.createFailure();
                }
                object5 = new ErrorList();
                readAttachment.m_aSBDH = (StandardBusinessDocument)new SBDMarshaller().setCollectErrors((ErrorList)object5).read(readAttachment.m_aPayloadBytes);
                if (n == 0 && readAttachment.m_aSBDH == null) {
                    if (object5.isEmpty()) {
                        LOGGER.error(string5 + "Failed to read the provided SBDH document");
                        iCommonsList2.add((Object)EEbmsError.EBMS_OTHER.errorBuilder(locale).refToMessageInError(string).errorDetail("Failed to read the provided SBDH document").build());
                    } else {
                        object = object5.iterator();
                        while (object.hasNext()) {
                            IError iError = (IError)object.next();
                            String string7 = "Peppol SBDH Issue: " + iError.getAsString(locale);
                            LOGGER.error(string5 + string7);
                            iCommonsList2.add((Object)EEbmsError.EBMS_OTHER.errorBuilder(locale).refToMessageInError(string).errorDetail(string7).build());
                        }
                    }
                    return AS4MessageProcessorResult.createFailure();
                }
                object4.add((Object)readAttachment);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(string5 + "AS4 Attachment " + n + " with ID [" + readAttachment.m_sID + "] uses [" + readAttachment.m_sMimeType + (readAttachment.m_sUncompressedMimeType == null ? null : " - uncompressed " + readAttachment.m_sUncompressedMimeType) + "] and [" + StringHelper.getToString((Object)readAttachment.m_aCharset, (String)"no charset") + "] and length is " + (readAttachment.m_aPayloadBytes == null ? "<error>" : Integer.toString(readAttachment.m_aPayloadBytes.length)) + " bytes" + (readAttachment.m_eCompressionMode == null ? "" : " of compressed payload"));
                }
                ++n;
            }
        }
        if (object4.size() != 1) {
            String string8 = "In Peppol exactly one payload attachment is expected. This request has " + object4.size() + " attachments";
            LOGGER.error(string5 + string8);
            iCommonsList2.add((Object)EEbmsError.EBMS_OTHER.errorBuilder(locale).refToMessageInError(iAS4IncomingMessageState.getMessageID()).errorDetail(string8).build());
            return AS4MessageProcessorResult.createFailure();
        }
        ReadAttachment readAttachment = (ReadAttachment)object4.getFirstOrNull();
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(string5 + "Now evaluating the SBDH against Peppol rules");
            }
            object22 = phase4PeppolReceiverConfiguration.getSBDHIdentifierFactory();
            boolean bl = phase4PeppolReceiverConfiguration.isPerformSBDHValueChecks();
            boolean bl2 = phase4PeppolReceiverConfiguration.isCheckSBDHForMandatoryCountryC1();
            object = new PeppolSBDHDataReader((IIdentifierFactory)object22).setPerformValueChecks(bl).setCheckForCountryC1(bl2);
            object3 = object.extractData(readAttachment.standardBusinessDocument());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(string5 + "The provided SBDH is valid according to Peppol rules, with value checks being " + (bl ? "enabled" : "disabled"));
            }
        }
        catch (PeppolSBDHDataReadException peppolSBDHDataReadException) {
            LOGGER.error(string5 + "Failed to extract the Peppol data from SBDH.", (Throwable)peppolSBDHDataReadException);
            iCommonsList2.add((Object)EEbmsError.EBMS_OTHER.errorBuilder(locale).refToMessageInError(iAS4IncomingMessageState.getMessageID()).errorDetail("Failed to extract the Peppol data from SBDH.", (Throwable)peppolSBDHDataReadException).build());
            return AS4MessageProcessorResult.createFailure();
        }
        if (phase4PeppolReceiverConfiguration.isReceiverCheckEnabled()) {
            LOGGER.info(string5 + "Performing checks if the received data is registered in our SMP");
            try {
                object22 = object3.getReceiverAsIdentifier();
                IDocumentTypeIdentifier iDocumentTypeIdentifier = object3.getDocumentTypeAsIdentifier();
                IProcessIdentifier iProcessIdentifier = object3.getProcessAsIdentifier();
                object = this._getReceiverEndpoint(string5, phase4PeppolReceiverConfiguration.getSMPClient(), (IParticipantIdentifier)object22, iDocumentTypeIdentifier, iProcessIdentifier, phase4PeppolReceiverConfiguration.getWildcardSelectionMode());
                if (object == null) {
                    String string9 = "Failed to resolve SMP endpoint for provided receiver ID (" + (object22 == null ? "null" : object22.getURIEncoded()) + ")/documentType ID (" + (iDocumentTypeIdentifier == null ? "null" : iDocumentTypeIdentifier.getURIEncoded()) + ")/process ID (" + (iProcessIdentifier == null ? "null" : iProcessIdentifier.getURIEncoded()) + ")/transport profile (" + this.m_aTransportProfile.getID() + ") - not handling incoming AS4 document";
                    LOGGER.error(string5 + string9);
                    iCommonsList2.add((Object)EEbmsError.EBMS_OTHER.errorBuilder(locale).refToMessageInError(iAS4IncomingMessageState.getMessageID()).description(string9, locale).errorDetail("PEPPOL:NOT_SERVICED").build());
                    return AS4MessageProcessorResult.createFailure();
                }
                Phase4PeppolServletMessageProcessorSPI._checkIfReceiverEndpointURLMatches(string5, phase4PeppolReceiverConfiguration.getAS4EndpointURL(), (EndpointType)object);
                Phase4PeppolServletMessageProcessorSPI._checkIfEndpointCertificateMatches(string5, phase4PeppolReceiverConfiguration.getAPCertificate(), (EndpointType)object);
            }
            catch (Phase4Exception phase4Exception) {
                LOGGER.error(string5 + "The addressing data contained in the SBDH could not be verified", (Throwable)phase4Exception);
                iCommonsList2.add((Object)EEbmsError.EBMS_OTHER.errorBuilder(locale).refToMessageInError(iAS4IncomingMessageState.getMessageID()).errorDetail("The addressing data contained in the SBDH could not be verified", (Throwable)phase4Exception).build());
                return AS4MessageProcessorResult.createFailure();
            }
        } else {
            LOGGER.info(string5 + "Endpoint checks for incoming AS4 messages are disabled");
        }
        if (this.m_aHandlers.isEmpty()) {
            LOGGER.error(string5 + "No SPI handler is present - the message is unhandled and discarded!");
            if (GlobalDebug.isProductionMode()) {
                iCommonsList2.add((Object)EEbmsError.EBMS_OTHER.errorBuilder(locale).refToMessageInError(iAS4IncomingMessageState.getMessageID()).errorDetail("The phase4 implementation is marked as in production, but has no capabilities to process an incoming Peppol message. Unfortunately, the Peppol message needs to be rejected for that reason.").build());
            }
        } else {
            for (IPhase4PeppolIncomingSBDHandlerSPI iPhase4PeppolIncomingSBDHandlerSPI : this.m_aHandlers) {
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(string5 + "Invoking Peppol handler " + String.valueOf(iPhase4PeppolIncomingSBDHandlerSPI));
                    }
                    iPhase4PeppolIncomingSBDHandlerSPI.handleIncomingSBD(iAS4IncomingMessageMetadata, httpHeaderMap.getClone(), ebms3UserMessage.clone(), readAttachment.payloadBytes(), readAttachment.standardBusinessDocument(), (PeppolSBDHData)object3, iAS4IncomingMessageState, iCommonsList2);
                }
                catch (Exception exception) {
                    LOGGER.error(string5 + "The incoming Peppol message could not be processed.", (Throwable)exception);
                    iCommonsList2.add((Object)EEbmsError.EBMS_OTHER.errorBuilder(locale).refToMessageInError(iAS4IncomingMessageState.getMessageID()).errorDetail("The incoming Peppol message could not be processed.", (Throwable)exception).build());
                    return AS4MessageProcessorResult.createFailure();
                }
            }
            this.afterSuccessfulPeppolProcessing(ebms3UserMessage, (PeppolSBDHData)object3, iAS4IncomingMessageState);
        }
        return AS4MessageProcessorResult.createSuccess();
    }

    @Nonnull
    public AS4SignalMessageProcessorResult processAS4SignalMessage(@Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nonnull HttpHeaderMap httpHeaderMap, @Nonnull Ebms3SignalMessage ebms3SignalMessage, @Nullable IPMode iPMode, @Nonnull IAS4IncomingMessageState iAS4IncomingMessageState, @Nonnull ICommonsList<Ebms3Error> iCommonsList) {
        LOGGER.error("Invoking processAS4SignalMessage is not supported");
        throw new UnsupportedOperationException();
    }

    public void processAS4ResponseMessage(@Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nonnull IAS4IncomingMessageState iAS4IncomingMessageState, @Nonnull @Nonempty String string, @Nullable byte[] byArray, boolean bl) {
    }

    private static final class ReadAttachment {
        private String m_sID;
        private String m_sMimeType;
        private String m_sUncompressedMimeType;
        private Charset m_aCharset;
        private EAS4CompressionMode m_eCompressionMode;
        private byte[] m_aPayloadBytes;
        private StandardBusinessDocument m_aSBDH;

        private ReadAttachment() {
        }

        @Nullable
        public String getID() {
            return this.m_sID;
        }

        @Nullable
        public String getMimeType() {
            return this.m_sMimeType;
        }

        @Nullable
        public String getUncompressedMimeType() {
            return this.m_sUncompressedMimeType;
        }

        @Nullable
        public Charset getCharset() {
            return this.m_aCharset;
        }

        @Nullable
        public EAS4CompressionMode getCompressionMode() {
            return this.m_eCompressionMode;
        }

        @Nonnull
        @ReturnsMutableObject
        public byte[] payloadBytes() {
            return this.m_aPayloadBytes;
        }

        @Nonnull
        @ReturnsMutableObject
        public StandardBusinessDocument standardBusinessDocument() {
            return this.m_aSBDH;
        }
    }
}

