/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.profile.peppol;

import com.helger.http.security.TrustManagerTrustAll;
import com.helger.http.tls.ETLSVersion;
import com.helger.httpclient.HttpClientSettings;
import com.helger.phase4.CAS4Version;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.hc.core5.util.Timeout;

public class Phase4PeppolHttpClientSettings
extends HttpClientSettings {
    public static final Timeout DEFAULT_PEPPOL_CONNECTION_REQUEST_TIMEOUT = Timeout.ofSeconds((long)1L);
    public static final Timeout DEFAULT_PEPPOL_CONNECT_TIMEOUT = Timeout.ofSeconds((long)5L);
    public static final Timeout DEFAULT_PEPPOL_RESPONSE_TIMEOUT = Timeout.ofMinutes((long)2L);

    public Phase4PeppolHttpClientSettings() {
        try {
            SSLContext sSLContext = SSLContext.getInstance(ETLSVersion.TLS_12.getID());
            sSLContext.init(null, new TrustManager[]{new TrustManagerTrustAll(false)}, null);
            this.setSSLContext(sSLContext);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException("Failed to initialize SSLContext for Phase4PeppolHttpClientSettings", generalSecurityException);
        }
        this.setConnectionRequestTimeout(DEFAULT_PEPPOL_CONNECTION_REQUEST_TIMEOUT);
        this.setConnectTimeout(DEFAULT_PEPPOL_CONNECT_TIMEOUT);
        this.setResponseTimeout(DEFAULT_PEPPOL_RESPONSE_TIMEOUT);
        this.setUserAgent("phase4/" + CAS4Version.BUILD_VERSION + " https://github.com/phax/phase4");
    }
}

