/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.peppol;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.version.Version;
import com.helger.datetime.helper.PDTFactory;
import com.helger.diver.api.coord.DVRCoordinate;
import com.helger.io.resource.ClassPathResource;
import com.helger.io.resource.IReadableResource;
import com.helger.phive.api.executor.IValidationExecutor;
import com.helger.phive.api.executorset.IValidationExecutorSet;
import com.helger.phive.api.executorset.IValidationExecutorSetRegistry;
import com.helger.phive.api.executorset.ValidationExecutorSet;
import com.helger.phive.api.executorset.status.IValidationExecutorSetStatus;
import com.helger.phive.rules.api.PhiveRulesHelper;
import com.helger.phive.rules.api.PhiveRulesUBLHelper;
import com.helger.phive.xml.source.IValidationSourceXML;
import com.helger.phive.xml.xsd.ValidationExecutorXSD;
import com.helger.ubl21.UBL21Marshaller;
import com.helger.ubl23.UBL23Marshaller;
import jakarta.annotation.Nonnull;
import java.time.LocalDate;
import java.time.Month;
import java.time.OffsetDateTime;
import java.util.List;

@Immutable
public final class PeppolValidation2025_05 {
    public static final Version PEPPOL_VALIDATION_ARTEFACT_VERSION = new Version(2025, 5, 0);
    public static final String VERSION_STR = PEPPOL_VALIDATION_ARTEFACT_VERSION.getAsString(false);
    public static final LocalDate VALID_PER = PDTFactory.createLocalDate((int)2025, (Month)Month.AUGUST, (int)25);
    public static final OffsetDateTime VALID_PER_UTC = PDTFactory.createOffsetDateTimeUTC((LocalDate)VALID_PER);
    public static final String GROUP_ID = "eu.peppol.bis3";
    public static final DVRCoordinate VID_OPENPEPPOL_INVOICE_UBL_V3 = PhiveRulesHelper.createCoordinate((String)"eu.peppol.bis3", (String)"invoice", (String)VERSION_STR);
    public static final DVRCoordinate VID_OPENPEPPOL_CREDIT_NOTE_UBL_V3 = PhiveRulesHelper.createCoordinate((String)"eu.peppol.bis3", (String)"creditnote", (String)VERSION_STR);
    public static final DVRCoordinate VID_OPENPEPPOL_ORDER_V3 = PhiveRulesHelper.createCoordinate((String)"eu.peppol.bis3", (String)"order", (String)VERSION_STR);
    public static final DVRCoordinate VID_OPENPEPPOL_DESPATCH_ADVICE_V3 = PhiveRulesHelper.createCoordinate((String)"eu.peppol.bis3", (String)"despatch-advice", (String)VERSION_STR);
    public static final DVRCoordinate VID_OPENPEPPOL_CATALOGUE_V3 = PhiveRulesHelper.createCoordinate((String)"eu.peppol.bis3", (String)"catalogue", (String)VERSION_STR);
    public static final DVRCoordinate VID_OPENPEPPOL_CATALOGUE_RESPONSE_V3 = PhiveRulesHelper.createCoordinate((String)"eu.peppol.bis3", (String)"catalogue-response", (String)VERSION_STR);
    public static final DVRCoordinate VID_OPENPEPPOL_MLR_V3 = PhiveRulesHelper.createCoordinate((String)"eu.peppol.bis3", (String)"mlr", (String)VERSION_STR);
    public static final DVRCoordinate VID_OPENPEPPOL_ORDER_RESPONSE_V3 = PhiveRulesHelper.createCoordinate((String)"eu.peppol.bis3", (String)"order-response", (String)VERSION_STR);
    public static final DVRCoordinate VID_OPENPEPPOL_PUNCH_OUT_V3 = PhiveRulesHelper.createCoordinate((String)"eu.peppol.bis3", (String)"punch-out", (String)VERSION_STR);
    public static final DVRCoordinate VID_OPENPEPPOL_ORDER_AGREEMENT_V3 = PhiveRulesHelper.createCoordinate((String)"eu.peppol.bis3", (String)"order-agreement", (String)VERSION_STR);
    public static final DVRCoordinate VID_OPENPEPPOL_INVOICE_MESSAGE_RESPONSE_V3 = PhiveRulesHelper.createCoordinate((String)"eu.peppol.bis3", (String)"invoice-message-response", (String)VERSION_STR);
    public static final DVRCoordinate VID_OPENPEPPOL_ORDER_CHANGE_V3 = PhiveRulesHelper.createCoordinate((String)"eu.peppol.bis3", (String)"order-change", (String)VERSION_STR);
    public static final DVRCoordinate VID_OPENPEPPOL_ORDER_CANCELLATION_V3 = PhiveRulesHelper.createCoordinate((String)"eu.peppol.bis3", (String)"order-cancellation", (String)VERSION_STR);
    public static final DVRCoordinate VID_OPENPEPPOL_ORDER_RESPONSE_ADVANCED_V3 = PhiveRulesHelper.createCoordinate((String)"eu.peppol.bis3", (String)"order-response-advanced", (String)VERSION_STR);

    private PeppolValidation2025_05() {
    }

    @Nonnull
    private static ClassLoader _getCL() {
        return PeppolValidation2025_05.class.getClassLoader();
    }

    public static void init(@Nonnull IValidationExecutorSetRegistry<IValidationSourceXML> iValidationExecutorSetRegistry) {
        ValueEnforcer.notNull(iValidationExecutorSetRegistry, (String)"Registry");
        String string = " (" + VERSION_STR + ")";
        String string2 = "external/schematron/openpeppol/" + VERSION_STR + "/xslt/";
        ClassPathResource classPathResource = new ClassPathResource(string2 + "CEN-EN16931-UBL.xslt", PeppolValidation2025_05._getCL());
        ClassPathResource classPathResource2 = new ClassPathResource(string2 + "PEPPOL-EN16931-UBL.xslt", PeppolValidation2025_05._getCL());
        ClassPathResource classPathResource3 = new ClassPathResource(string2 + "PEPPOLBIS-T01.xslt", PeppolValidation2025_05._getCL());
        ClassPathResource classPathResource4 = new ClassPathResource(string2 + "PEPPOLBIS-T16.xslt", PeppolValidation2025_05._getCL());
        ClassPathResource classPathResource5 = new ClassPathResource(string2 + "PEPPOLBIS-T19.xslt", PeppolValidation2025_05._getCL());
        ClassPathResource classPathResource6 = new ClassPathResource(string2 + "PEPPOLBIS-T58.xslt", PeppolValidation2025_05._getCL());
        ClassPathResource classPathResource7 = new ClassPathResource(string2 + "PEPPOLBIS-T71.xslt", PeppolValidation2025_05._getCL());
        ClassPathResource classPathResource8 = new ClassPathResource(string2 + "PEPPOLBIS-T76.xslt", PeppolValidation2025_05._getCL());
        ClassPathResource classPathResource9 = new ClassPathResource(string2 + "PEPPOLBIS-T77.xslt", PeppolValidation2025_05._getCL());
        ClassPathResource classPathResource10 = new ClassPathResource(string2 + "PEPPOLBIS-T110.xslt", PeppolValidation2025_05._getCL());
        ClassPathResource classPathResource11 = new ClassPathResource(string2 + "PEPPOLBIS-T111.xslt", PeppolValidation2025_05._getCL());
        ClassPathResource classPathResource12 = new ClassPathResource(string2 + "PEPPOLBIS-T114.xslt", PeppolValidation2025_05._getCL());
        ClassPathResource classPathResource13 = new ClassPathResource(string2 + "PEPPOLBIS-T115.xslt", PeppolValidation2025_05._getCL());
        ClassPathResource classPathResource14 = new ClassPathResource(string2 + "PEPPOLBIS-T116.xslt", PeppolValidation2025_05._getCL());
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((DVRCoordinate)VID_OPENPEPPOL_INVOICE_UBL_V3, (String)("OpenPeppol UBL Invoice" + string + " (aka BIS Billing 3.0.19)"), (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)false, (OffsetDateTime)VALID_PER_UTC), (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllInvoiceXSDs()), PhiveRulesUBLHelper.createXSLT_UBL21((IReadableResource)classPathResource), PhiveRulesUBLHelper.createXSLT_UBL21((IReadableResource)classPathResource2)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((DVRCoordinate)VID_OPENPEPPOL_CREDIT_NOTE_UBL_V3, (String)("OpenPeppol UBL Credit Note" + string + " (aka BIS Billing 3.0.19)"), (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)false, (OffsetDateTime)VALID_PER_UTC), (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllCreditNoteXSDs()), PhiveRulesUBLHelper.createXSLT_UBL21((IReadableResource)classPathResource), PhiveRulesUBLHelper.createXSLT_UBL21((IReadableResource)classPathResource2)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((DVRCoordinate)VID_OPENPEPPOL_ORDER_V3, (String)("OpenPeppol Order" + string + " (aka BIS 3.0.15)"), (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)false, (OffsetDateTime)VALID_PER_UTC), (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllOrderXSDs()), PhiveRulesUBLHelper.createXSLT_UBL21((IReadableResource)classPathResource3)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((DVRCoordinate)VID_OPENPEPPOL_DESPATCH_ADVICE_V3, (String)("OpenPeppol Despatch Advice" + string + " (aka BIS 3.0.15)"), (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)false, (OffsetDateTime)VALID_PER_UTC), (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllDespatchAdviceXSDs()), PhiveRulesUBLHelper.createXSLT_UBL21((IReadableResource)classPathResource4)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((DVRCoordinate)VID_OPENPEPPOL_CATALOGUE_V3, (String)("OpenPeppol Catalogue" + string + " (aka BIS 3.0.15)"), (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)false, (OffsetDateTime)VALID_PER_UTC), (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllCatalogueXSDs()), PhiveRulesUBLHelper.createXSLT_UBL21((IReadableResource)classPathResource5)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((DVRCoordinate)VID_OPENPEPPOL_CATALOGUE_RESPONSE_V3, (String)("OpenPeppol Catalogue Response" + string + " (aka BIS 3.0.15)"), (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)false, (OffsetDateTime)VALID_PER_UTC), (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllApplicationResponseXSDs()), PhiveRulesUBLHelper.createXSLT_UBL21((IReadableResource)classPathResource6)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((DVRCoordinate)VID_OPENPEPPOL_MLR_V3, (String)("OpenPeppol MLR" + string + " (aka BIS 3.0.15)"), (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)false, (OffsetDateTime)VALID_PER_UTC), (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllApplicationResponseXSDs()), PhiveRulesUBLHelper.createXSLT_UBL21((IReadableResource)classPathResource7)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((DVRCoordinate)VID_OPENPEPPOL_ORDER_RESPONSE_V3, (String)("OpenPeppol Order Response" + string + " (aka BIS 3.0.15)"), (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)false, (OffsetDateTime)VALID_PER_UTC), (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllOrderResponseXSDs()), PhiveRulesUBLHelper.createXSLT_UBL21((IReadableResource)classPathResource8)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((DVRCoordinate)VID_OPENPEPPOL_PUNCH_OUT_V3, (String)("OpenPeppol Punch Out" + string + " (aka BIS 3.0.15)"), (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)false, (OffsetDateTime)VALID_PER_UTC), (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllCatalogueXSDs()), PhiveRulesUBLHelper.createXSLT_UBL21((IReadableResource)classPathResource9)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((DVRCoordinate)VID_OPENPEPPOL_ORDER_AGREEMENT_V3, (String)("OpenPeppol Order Agreement" + string + " (aka BIS 3.0.15)"), (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)false, (OffsetDateTime)VALID_PER_UTC), (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllOrderResponseXSDs()), PhiveRulesUBLHelper.createXSLT_UBL21((IReadableResource)classPathResource10)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((DVRCoordinate)VID_OPENPEPPOL_INVOICE_MESSAGE_RESPONSE_V3, (String)("OpenPeppol Invoice Message Response" + string + " (aka BIS 3.0.15)"), (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)false, (OffsetDateTime)VALID_PER_UTC), (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllApplicationResponseXSDs()), PhiveRulesUBLHelper.createXSLT_UBL21((IReadableResource)classPathResource11)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((DVRCoordinate)VID_OPENPEPPOL_ORDER_CHANGE_V3, (String)("OpenPeppol Order Change" + string + " (aka BIS 3.0.15)"), (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)false, (OffsetDateTime)VALID_PER_UTC), (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL23Marshaller.getAllOrderChangeXSDs()), PhiveRulesUBLHelper.createXSLT_UBL23((IReadableResource)classPathResource12)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((DVRCoordinate)VID_OPENPEPPOL_ORDER_CANCELLATION_V3, (String)("OpenPeppol Order Cancellation" + string + " (aka BIS 3.0.15)"), (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)false, (OffsetDateTime)VALID_PER_UTC), (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL23Marshaller.getAllOrderCancellationXSDs()), PhiveRulesUBLHelper.createXSLT_UBL23((IReadableResource)classPathResource13)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((DVRCoordinate)VID_OPENPEPPOL_ORDER_RESPONSE_ADVANCED_V3, (String)("OpenPeppol Order Response Advanced" + string + " (aka BIS 3.0.15)"), (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)false, (OffsetDateTime)VALID_PER_UTC), (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL23Marshaller.getAllOrderResponseXSDs()), PhiveRulesUBLHelper.createXSLT_UBL23((IReadableResource)classPathResource14)}));
    }
}

