/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.peppol;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.diver.api.coord.DVRCoordinate;
import com.helger.io.resource.ClassPathResource;
import com.helger.io.resource.IReadableResource;
import com.helger.phive.api.executor.IValidationExecutor;
import com.helger.phive.api.executorset.IValidationExecutorSet;
import com.helger.phive.api.executorset.IValidationExecutorSetRegistry;
import com.helger.phive.api.executorset.ValidationExecutorSet;
import com.helger.phive.api.executorset.status.IValidationExecutorSetStatus;
import com.helger.phive.rules.api.PhiveRulesHelper;
import com.helger.phive.rules.api.PhiveRulesUBLHelper;
import com.helger.phive.xml.source.IValidationSourceXML;
import com.helger.phive.xml.xsd.ValidationExecutorXSD;
import com.helger.ubl21.UBL21Marshaller;
import jakarta.annotation.Nonnull;
import java.util.List;

@Immutable
public final class PeppolValidationMLS {
    public static final String GROUP_ID = "org.peppol";
    public static final DVRCoordinate VID_OPENPEPPOL_MLS_V100 = PhiveRulesHelper.createCoordinate((String)"org.peppol", (String)"mls", (String)"1.0.0");

    private PeppolValidationMLS() {
    }

    @Nonnull
    private static ClassLoader _getCL() {
        return PeppolValidationMLS.class.getClassLoader();
    }

    public static void init(@Nonnull IValidationExecutorSetRegistry<IValidationSourceXML> iValidationExecutorSetRegistry) {
        ValueEnforcer.notNull(iValidationExecutorSetRegistry, (String)"Registry");
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((DVRCoordinate)VID_OPENPEPPOL_MLS_V100, (String)"Peppol Message Level Status v1.0.0", (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)false), (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllApplicationResponseXSDs()), PhiveRulesUBLHelper.createXSLT_UBL21((IReadableResource)new ClassPathResource("external/schematron/mls/1.0.0/xslt/peppol-mls-1.0.0.xslt", PeppolValidationMLS._getCL()))}));
    }
}

