/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.peppol;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.datetime.helper.PDTFactory;
import com.helger.diver.api.coord.DVRCoordinate;
import com.helger.io.resource.ClassPathResource;
import com.helger.io.resource.IReadableResource;
import com.helger.phive.api.executor.IValidationExecutor;
import com.helger.phive.api.executorset.IValidationExecutorSet;
import com.helger.phive.api.executorset.IValidationExecutorSetRegistry;
import com.helger.phive.api.executorset.ValidationExecutorSet;
import com.helger.phive.api.executorset.status.IValidationExecutorSetStatus;
import com.helger.phive.rules.api.PhiveRulesHelper;
import com.helger.phive.rules.api.PhiveRulesUBLHelper;
import com.helger.phive.xml.source.IValidationSourceXML;
import com.helger.phive.xml.xsd.ValidationExecutorXSD;
import com.helger.ubl21.UBL21Marshaller;
import com.helger.xml.namespace.IIterableNamespaceContext;
import com.helger.xml.namespace.MapBasedNamespaceContext;
import jakarta.annotation.Nonnull;
import java.time.LocalDate;
import java.time.Month;
import java.time.OffsetDateTime;
import java.util.List;

@Immutable
public final class PeppolValidationPintSG {
    public static final String GROUP_ID = "org.peppol.pint.sg";
    @Deprecated
    public static final DVRCoordinate VID_OPENPEPPOL_SG_PINT_UBL_INVOICE_1_1_0 = PhiveRulesHelper.createCoordinate((String)"org.peppol.pint.sg", (String)"invoice", (String)"1.1.0");
    @Deprecated
    public static final DVRCoordinate VID_OPENPEPPOL_SG_PINT_UBL_CREDIT_NOTE_1_1_0 = PhiveRulesHelper.createCoordinate((String)"org.peppol.pint.sg", (String)"creditnote", (String)"1.1.0");
    public static final LocalDate V1_2_0_VALID_PER = PDTFactory.createLocalDate((int)2025, (Month)Month.MARCH, (int)10);
    public static final OffsetDateTime V1_2_0_VALID_PER_UTC = PDTFactory.createOffsetDateTimeUTC((LocalDate)V1_2_0_VALID_PER);
    public static final DVRCoordinate VID_OPENPEPPOL_SG_PINT_UBL_INVOICE_1_2_0 = PhiveRulesHelper.createCoordinate((String)"org.peppol.pint.sg", (String)"invoice", (String)"1.2.0");
    public static final DVRCoordinate VID_OPENPEPPOL_SG_PINT_UBL_CREDIT_NOTE_1_2_0 = PhiveRulesHelper.createCoordinate((String)"org.peppol.pint.sg", (String)"creditnote", (String)"1.2.0");
    public static final LocalDate V1_3_0_VALID_PER = PDTFactory.createLocalDate((int)2025, (Month)Month.SEPTEMBER, (int)25);
    public static final OffsetDateTime V1_3_0_VALID_PER_UTC = PDTFactory.createOffsetDateTimeUTC((LocalDate)V1_3_0_VALID_PER);
    public static final DVRCoordinate VID_OPENPEPPOL_SG_PINT_UBL_INVOICE_1_3_0 = PhiveRulesHelper.createCoordinate((String)"org.peppol.pint.sg", (String)"invoice", (String)"1.3.0");
    public static final DVRCoordinate VID_OPENPEPPOL_SG_PINT_UBL_CREDIT_NOTE_1_3_0 = PhiveRulesHelper.createCoordinate((String)"org.peppol.pint.sg", (String)"creditnote", (String)"1.3.0");

    private PeppolValidationPintSG() {
    }

    @Nonnull
    private static ClassLoader _getCL() {
        return PeppolValidationPintSG.class.getClassLoader();
    }

    public static void init(@Nonnull IValidationExecutorSetRegistry<IValidationSourceXML> iValidationExecutorSetRegistry) {
        ValueEnforcer.notNull(iValidationExecutorSetRegistry, (String)"Registry");
        MapBasedNamespaceContext mapBasedNamespaceContext = PhiveRulesUBLHelper.createUBL21NSContext((String)UBL21Marshaller.invoice().getRootElementNamespaceURI());
        MapBasedNamespaceContext mapBasedNamespaceContext2 = PhiveRulesUBLHelper.createUBL21NSContext((String)UBL21Marshaller.creditNote().getRootElementNamespaceURI());
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((DVRCoordinate)VID_OPENPEPPOL_SG_PINT_UBL_INVOICE_1_1_0, (String)"Peppol PINT Singapore Invoice (UBL) 1.1.0", (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)true), (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllInvoiceXSDs()), PhiveRulesHelper.createXSLT((IReadableResource)new ClassPathResource("external/schematron/pint-sg/1.1.0/xslt/PINT-UBL-validation-preprocessed-inv.xslt", PeppolValidationPintSG._getCL()), (IIterableNamespaceContext)mapBasedNamespaceContext), PhiveRulesHelper.createXSLT((IReadableResource)new ClassPathResource("external/schematron/pint-sg/1.1.0/xslt/PINT-jurisdiction-aligned-rules-inv.xslt", PeppolValidationPintSG._getCL()), (IIterableNamespaceContext)mapBasedNamespaceContext)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((DVRCoordinate)VID_OPENPEPPOL_SG_PINT_UBL_CREDIT_NOTE_1_1_0, (String)"Peppol PINT Singapore Credit Note (UBL) 1.1.0", (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)true), (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllCreditNoteXSDs()), PhiveRulesHelper.createXSLT((IReadableResource)new ClassPathResource("external/schematron/pint-sg/1.1.0/xslt/PINT-UBL-validation-preprocessed-cn.xslt", PeppolValidationPintSG._getCL()), (IIterableNamespaceContext)mapBasedNamespaceContext2), PhiveRulesHelper.createXSLT((IReadableResource)new ClassPathResource("external/schematron/pint-sg/1.1.0/xslt/PINT-jurisdiction-aligned-rules-cn.xslt", PeppolValidationPintSG._getCL()), (IIterableNamespaceContext)mapBasedNamespaceContext2)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((DVRCoordinate)VID_OPENPEPPOL_SG_PINT_UBL_INVOICE_1_2_0, (String)"Peppol PINT Singapore Invoice (UBL) 1.2.0", (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)false, (OffsetDateTime)V1_2_0_VALID_PER_UTC), (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllInvoiceXSDs()), PhiveRulesHelper.createXSLT((IReadableResource)new ClassPathResource("external/schematron/pint-sg/1.2.0/xslt/PINT-UBL-validation-preprocessed.xslt", PeppolValidationPintSG._getCL()), (IIterableNamespaceContext)mapBasedNamespaceContext), PhiveRulesHelper.createXSLT((IReadableResource)new ClassPathResource("external/schematron/pint-sg/1.2.0/xslt/PINT-jurisdiction-aligned-rules.xslt", PeppolValidationPintSG._getCL()), (IIterableNamespaceContext)mapBasedNamespaceContext)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((DVRCoordinate)VID_OPENPEPPOL_SG_PINT_UBL_CREDIT_NOTE_1_2_0, (String)"Peppol PINT Singapore Credit Note (UBL) 1.2.0", (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)false, (OffsetDateTime)V1_2_0_VALID_PER_UTC), (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllCreditNoteXSDs()), PhiveRulesHelper.createXSLT((IReadableResource)new ClassPathResource("external/schematron/pint-sg/1.2.0/xslt/PINT-UBL-validation-preprocessed.xslt", PeppolValidationPintSG._getCL()), (IIterableNamespaceContext)mapBasedNamespaceContext2), PhiveRulesHelper.createXSLT((IReadableResource)new ClassPathResource("external/schematron/pint-sg/1.2.0/xslt/PINT-jurisdiction-aligned-rules.xslt", PeppolValidationPintSG._getCL()), (IIterableNamespaceContext)mapBasedNamespaceContext2)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((DVRCoordinate)VID_OPENPEPPOL_SG_PINT_UBL_INVOICE_1_3_0, (String)"Peppol PINT Singapore Invoice (UBL) 1.3.0", (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)false, (OffsetDateTime)V1_3_0_VALID_PER_UTC), (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllInvoiceXSDs()), PhiveRulesHelper.createXSLT((IReadableResource)new ClassPathResource("external/schematron/pint-sg/1.3.0/xslt/PINT-UBL-validation-preprocessed.xslt", PeppolValidationPintSG._getCL()), (IIterableNamespaceContext)mapBasedNamespaceContext), PhiveRulesHelper.createXSLT((IReadableResource)new ClassPathResource("external/schematron/pint-sg/1.3.0/xslt/PINT-jurisdiction-aligned-rules.xslt", PeppolValidationPintSG._getCL()), (IIterableNamespaceContext)mapBasedNamespaceContext)}));
        iValidationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.create((DVRCoordinate)VID_OPENPEPPOL_SG_PINT_UBL_CREDIT_NOTE_1_3_0, (String)"Peppol PINT Singapore Credit Note (UBL) 1.3.0", (IValidationExecutorSetStatus)PhiveRulesHelper.createSimpleStatus((boolean)false, (OffsetDateTime)V1_3_0_VALID_PER_UTC), (IValidationExecutor[])new IValidationExecutor[]{ValidationExecutorXSD.create((List)UBL21Marshaller.getAllCreditNoteXSDs()), PhiveRulesHelper.createXSLT((IReadableResource)new ClassPathResource("external/schematron/pint-sg/1.3.0/xslt/PINT-UBL-validation-preprocessed.xslt", PeppolValidationPintSG._getCL()), (IIterableNamespaceContext)mapBasedNamespaceContext2), PhiveRulesHelper.createXSLT((IReadableResource)new ClassPathResource("external/schematron/pint-sg/1.3.0/xslt/PINT-jurisdiction-aligned-rules.xslt", PeppolValidationPintSG._getCL()), (IIterableNamespaceContext)mapBasedNamespaceContext2)}));
    }
}

