/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.audit;

import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.misc.DevelopersNote;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.type.ObjectType;
import com.helger.photon.audit.IAuditor;
import com.helger.photon.audit.LoggingAuditor;
import com.helger.photon.audit.mock.MockCurrentUserIDProvider;
import com.helger.security.authentication.subject.user.ICurrentUserIDProvider;
import jakarta.annotation.Nonnull;

@ThreadSafe
public final class AuditHelper {
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    private static final IAuditor DEFAULT_AUDITOR;
    private static IAuditor s_aAuditor;

    private AuditHelper() {
    }

    @Nonnull
    public static IAuditor getAuditor() {
        return (IAuditor)RW_LOCK.readLockedGet(() -> s_aAuditor);
    }

    public static boolean isDefaultAuditorSet() {
        return RW_LOCK.readLockedBoolean(() -> EqualsHelper.identityEqual((Object)s_aAuditor, (Object)DEFAULT_AUDITOR));
    }

    public static void setAuditor(@Nonnull IAuditor iAuditor) {
        ValueEnforcer.notNull((Object)iAuditor, (String)"Auditor");
        RW_LOCK.writeLocked(() -> {
            s_aAuditor = iAuditor;
        });
    }

    public static void setDefaultAuditor() {
        AuditHelper.setAuditor(DEFAULT_AUDITOR);
    }

    public static void onAuditCreateSuccess(@Nonnull ObjectType objectType) {
        AuditHelper.getAuditor().onCreateSuccess(objectType, new Object[0]);
    }

    public static void onAuditCreateSuccess(@Nonnull ObjectType objectType, Object ... objectArray) {
        AuditHelper.getAuditor().onCreateSuccess(objectType, objectArray);
    }

    @Deprecated(forRemoval=false)
    @DevelopersNote(value="Use the version with parameters!")
    public static void onAuditCreateFailure(@Nonnull ObjectType objectType) {
        throw new UnsupportedOperationException();
    }

    public static void onAuditCreateFailure(@Nonnull ObjectType objectType, Object ... objectArray) {
        AuditHelper.getAuditor().onCreateFailure(objectType, objectArray);
    }

    @Deprecated(forRemoval=false)
    @DevelopersNote(value="Use the version with parameters!")
    public static void onAuditModifySuccess(@Nonnull ObjectType objectType, @Nonnull String string) {
        throw new UnsupportedOperationException();
    }

    public static void onAuditModifySuccess(@Nonnull ObjectType objectType, @Nonnull String string, Object ... objectArray) {
        AuditHelper.getAuditor().onModifySuccess(objectType, string, objectArray);
    }

    @Deprecated(forRemoval=false)
    @DevelopersNote(value="Use the version with parameters!")
    public static void onAuditModifyFailure(@Nonnull ObjectType objectType, @Nonnull String string) {
        throw new UnsupportedOperationException();
    }

    public static void onAuditModifyFailure(@Nonnull ObjectType objectType, @Nonnull String string, Object ... objectArray) {
        AuditHelper.getAuditor().onModifyFailure(objectType, string, objectArray);
    }

    @Deprecated(forRemoval=false)
    @DevelopersNote(value="Use the version with parameters!")
    public static void onAuditDeleteSuccess(@Nonnull ObjectType objectType) {
        throw new UnsupportedOperationException();
    }

    public static void onAuditDeleteSuccess(@Nonnull ObjectType objectType, Object ... objectArray) {
        AuditHelper.getAuditor().onDeleteSuccess(objectType, objectArray);
    }

    @Deprecated(forRemoval=false)
    @DevelopersNote(value="Use the version with parameters!")
    public static void onAuditDeleteFailure(@Nonnull ObjectType objectType) {
        throw new UnsupportedOperationException();
    }

    public static void onAuditDeleteFailure(@Nonnull ObjectType objectType, Object ... objectArray) {
        AuditHelper.getAuditor().onDeleteFailure(objectType, objectArray);
    }

    @Deprecated(forRemoval=false)
    @DevelopersNote(value="Use the version with parameters!")
    public static void onAuditUndeleteSuccess(@Nonnull ObjectType objectType) {
        throw new UnsupportedOperationException();
    }

    public static void onAuditUndeleteSuccess(@Nonnull ObjectType objectType, Object ... objectArray) {
        AuditHelper.getAuditor().onUndeleteSuccess(objectType, objectArray);
    }

    @Deprecated(forRemoval=false)
    @DevelopersNote(value="Use the version with parameters!")
    public static void onAuditUndeleteFailure(@Nonnull ObjectType objectType) {
        throw new UnsupportedOperationException();
    }

    public static void onAuditUndeleteFailure(@Nonnull ObjectType objectType, Object ... objectArray) {
        AuditHelper.getAuditor().onUndeleteFailure(objectType, objectArray);
    }

    public static void onAuditExecuteSuccess(@Nonnull String string, Object ... objectArray) {
        AuditHelper.getAuditor().onExecuteSuccess(string, objectArray);
    }

    public static void onAuditExecuteFailure(@Nonnull String string, Object ... objectArray) {
        AuditHelper.getAuditor().onExecuteFailure(string, objectArray);
    }

    public static void onAuditExecuteSuccess(@Nonnull ObjectType objectType, @Nonnull String string, Object ... objectArray) {
        AuditHelper.getAuditor().onExecuteSuccess(objectType, string, objectArray);
    }

    public static void onAuditExecuteFailure(@Nonnull ObjectType objectType, @Nonnull String string, Object ... objectArray) {
        AuditHelper.getAuditor().onExecuteFailure(objectType, string, objectArray);
    }

    static {
        s_aAuditor = DEFAULT_AUDITOR = new LoggingAuditor((ICurrentUserIDProvider)new MockCurrentUserIDProvider(null), "!DEFAULT-AUDITOR! ");
    }
}

