/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.io;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.callback.IThrowingRunnable;
import com.helger.commons.concurrent.BasicThreadFactory;
import com.helger.commons.concurrent.ExecutorServiceHelper;
import com.helger.commons.functional.IThrowingSupplier;
import com.helger.commons.log.ConditionalLogger;
import com.helger.commons.timing.StopWatch;
import com.helger.scope.IScope;
import com.helger.scope.singleton.AbstractGlobalSingleton;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhotonWorkerPool
extends AbstractGlobalSingleton {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhotonWorkerPool.class);
    private static final ConditionalLogger CONDLOG = new ConditionalLogger(LOGGER, false);
    private final ExecutorService m_aES;

    @Deprecated(forRemoval=false)
    @UsedViaReflection
    public PhotonWorkerPool() {
        this(Runtime.getRuntime().availableProcessors() * 2);
    }

    public PhotonWorkerPool(@Nonnegative int n) {
        this(Executors.newFixedThreadPool(n, (ThreadFactory)new BasicThreadFactory.Builder().daemon(true).namingPattern("ph-oton-worker-%d").build()));
    }

    public PhotonWorkerPool(@Nonnull ExecutorService executorService) {
        ValueEnforcer.notNull((Object)executorService, (String)"ExecutorService");
        this.m_aES = executorService;
    }

    @Nonnull
    public static PhotonWorkerPool getInstance() {
        return (PhotonWorkerPool)PhotonWorkerPool.getGlobalSingleton(PhotonWorkerPool.class);
    }

    public static boolean isSilentMode() {
        return CONDLOG.isDisabled();
    }

    public static boolean setSilentMode(boolean bl) {
        return !CONDLOG.setEnabled(!bl);
    }

    protected void onDestroy(@Nonnull IScope iScope) throws Exception {
        CONDLOG.debug(() -> "ph-oton worker pool about to be closed");
        ExecutorServiceHelper.shutdownAndWaitUntilAllTasksAreFinished((ExecutorService)this.m_aES);
        CONDLOG.info("ph-oton worker pool was closed!");
    }

    @Nonnull
    public CompletableFuture<Void> run(@Nonnull String string, @Nonnull Runnable runnable) {
        return CompletableFuture.runAsync(() -> {
            StopWatch stopWatch = StopWatch.createdStarted();
            CONDLOG.info(() -> "Starting '" + string + "'");
            try {
                runnable.run();
            }
            catch (RuntimeException runtimeException) {
                CONDLOG.error(() -> "Error running ph-oton runner " + String.valueOf(runnable), (Exception)runtimeException);
            }
            finally {
                stopWatch.stop();
                CONDLOG.info(() -> "Finished '" + string + "' after " + stopWatch.getMillis() + " milliseconds");
            }
        }, this.m_aES);
    }

    @Nonnull
    public CompletableFuture<Void> runThrowing(@Nonnull String string, @Nonnull IThrowingRunnable<? extends Exception> iThrowingRunnable) {
        return CompletableFuture.runAsync(() -> {
            StopWatch stopWatch = StopWatch.createdStarted();
            CONDLOG.info(() -> "Starting '" + string + "'");
            try {
                iThrowingRunnable.run();
            }
            catch (Exception exception) {
                CONDLOG.error(() -> "Error running ph-oton runner " + String.valueOf(iThrowingRunnable), exception);
            }
            finally {
                stopWatch.stop();
                CONDLOG.info(() -> "Finished '" + string + "' after " + stopWatch.getMillis() + " milliseconds");
            }
        }, this.m_aES);
    }

    @Nonnull
    public <T> CompletableFuture<T> supply(@Nonnull String string, @Nonnull Supplier<T> supplier) {
        return CompletableFuture.supplyAsync(() -> {
            StopWatch stopWatch = StopWatch.createdStarted();
            CONDLOG.info(() -> "Starting '" + string + "'");
            try {
                Object t = supplier.get();
                return t;
            }
            catch (RuntimeException runtimeException) {
                CONDLOG.error(() -> PhotonWorkerPool.lambda$supply$10((Supplier)supplier), (Exception)runtimeException);
                Object var4_5 = null;
                return var4_5;
            }
            finally {
                stopWatch.stop();
                CONDLOG.info(() -> "Finished '" + string + "' after " + stopWatch.getMillis() + " milliseconds");
            }
        }, this.m_aES);
    }

    @Nonnull
    public <T> CompletableFuture<T> supplyThrowing(@Nonnull String string, @Nonnull IThrowingSupplier<T, ? extends Exception> iThrowingSupplier) {
        return CompletableFuture.supplyAsync(() -> {
            StopWatch stopWatch = StopWatch.createdStarted();
            CONDLOG.info(() -> "Starting '" + string + "'");
            try {
                Object object = iThrowingSupplier.get();
                return object;
            }
            catch (Exception exception) {
                CONDLOG.error(() -> "Error running ph-oton supplier " + String.valueOf(iThrowingSupplier), exception);
                Object var4_5 = null;
                return var4_5;
            }
            finally {
                stopWatch.stop();
                CONDLOG.info(() -> "Finished '" + string + "' after " + stopWatch.getMillis() + " milliseconds");
            }
        }, this.m_aES);
    }

    private static /* synthetic */ String lambda$supply$10(Supplier supplier) {
        return "Error running ph-oton supplier " + String.valueOf(supplier);
    }
}

