/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz;

import com.helger.quartz.IJob;
import com.helger.quartz.IJobDetail;
import com.helger.quartz.JobDataMap;
import com.helger.quartz.JobKey;
import com.helger.quartz.impl.JobDetail;
import com.helger.quartz.utils.Key;
import java.util.Map;

public class JobBuilder {
    private JobKey m_aKey;
    private String m_sDescription;
    private Class<? extends IJob> m_aJobClass;
    private boolean m_bDurability;
    private boolean m_bShouldRecover;
    private JobDataMap m_aJobDataMap = new JobDataMap();

    protected JobBuilder() {
    }

    public static JobBuilder newJob() {
        return new JobBuilder();
    }

    public static JobBuilder newJob(Class<? extends IJob> clazz) {
        JobBuilder jobBuilder = new JobBuilder();
        jobBuilder.ofType(clazz);
        return jobBuilder;
    }

    public IJobDetail build() {
        JobDetail jobDetail = new JobDetail();
        jobDetail.setJobClass(this.m_aJobClass);
        jobDetail.setDescription(this.m_sDescription);
        if (this.m_aKey == null) {
            this.m_aKey = new JobKey(Key.createUniqueName(null), null);
        }
        jobDetail.setKey(this.m_aKey);
        jobDetail.setDurability(this.m_bDurability);
        jobDetail.setRequestsRecovery(this.m_bShouldRecover);
        if (!this.m_aJobDataMap.isEmpty()) {
            jobDetail.setJobDataMap(this.m_aJobDataMap);
        }
        return jobDetail;
    }

    public JobBuilder withIdentity(String string) {
        this.m_aKey = new JobKey(string, null);
        return this;
    }

    public JobBuilder withIdentity(String string, String string2) {
        this.m_aKey = new JobKey(string, string2);
        return this;
    }

    public JobBuilder withIdentity(JobKey jobKey) {
        this.m_aKey = jobKey;
        return this;
    }

    public JobBuilder withDescription(String string) {
        this.m_sDescription = string;
        return this;
    }

    public JobBuilder ofType(Class<? extends IJob> clazz) {
        this.m_aJobClass = clazz;
        return this;
    }

    public JobBuilder requestRecovery() {
        this.m_bShouldRecover = true;
        return this;
    }

    public JobBuilder requestRecovery(boolean bl) {
        this.m_bShouldRecover = bl;
        return this;
    }

    public JobBuilder storeDurably() {
        this.m_bDurability = true;
        return this;
    }

    public JobBuilder storeDurably(boolean bl) {
        this.m_bDurability = bl;
        return this;
    }

    public JobBuilder usingJobData(String string, String string2) {
        this.m_aJobDataMap.put(string, string2);
        return this;
    }

    public JobBuilder usingJobData(String string, Integer n) {
        this.m_aJobDataMap.put(string, n);
        return this;
    }

    public JobBuilder usingJobData(String string, Long l) {
        this.m_aJobDataMap.put(string, l);
        return this;
    }

    public JobBuilder usingJobData(String string, Float f) {
        this.m_aJobDataMap.put(string, f);
        return this;
    }

    public JobBuilder usingJobData(String string, Double d) {
        this.m_aJobDataMap.put(string, d);
        return this;
    }

    public JobBuilder usingJobData(String string, Boolean bl) {
        this.m_aJobDataMap.put(string, bl);
        return this;
    }

    public JobBuilder usingJobData(JobDataMap jobDataMap) {
        this.m_aJobDataMap.putAll((Map)((Object)jobDataMap));
        return this;
    }

    public JobBuilder setJobData(JobDataMap jobDataMap) {
        this.m_aJobDataMap = jobDataMap;
        return this;
    }
}

