/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.core;

import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.quartz.ITrigger;
import com.helger.quartz.JobPersistenceException;
import com.helger.quartz.SchedulerException;
import com.helger.quartz.core.JobRunShell;
import com.helger.quartz.core.QuartzScheduler;
import com.helger.quartz.core.QuartzSchedulerResources;
import com.helger.quartz.spi.IOperableTrigger;
import com.helger.quartz.spi.TriggerFiredBundle;
import com.helger.quartz.spi.TriggerFiredResult;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzSchedulerThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuartzSchedulerThread.class);
    private static final long DEFAULT_IDLE_WAIT_TIME = 30000L;
    private QuartzScheduler m_aQS;
    private QuartzSchedulerResources m_aQSRsrcs;
    private final Object m_aSigLock = new Object();
    private boolean m_bSignaled;
    private long m_nSignaledNextFireTime;
    private boolean m_bPaused;
    private final AtomicBoolean m_aHalted;
    private final Random m_aRandom = new Random();
    private long m_nIdleWaitTime = 30000L;
    private int m_nIdleWaitVariablness = 7000;

    QuartzSchedulerThread(QuartzScheduler quartzScheduler, QuartzSchedulerResources quartzSchedulerResources) {
        this(quartzScheduler, quartzSchedulerResources, quartzSchedulerResources.getMakeSchedulerThreadDaemon(), 5);
    }

    QuartzSchedulerThread(QuartzScheduler quartzScheduler, QuartzSchedulerResources quartzSchedulerResources, boolean bl, int n) {
        super(quartzScheduler.getSchedulerThreadGroup(), quartzSchedulerResources.getThreadName());
        this.m_aQS = quartzScheduler;
        this.m_aQSRsrcs = quartzSchedulerResources;
        this.setDaemon(bl);
        if (quartzSchedulerResources.isThreadsInheritInitializersClassLoadContext()) {
            LOGGER.info("QuartzSchedulerThread Inheriting ContextClassLoader of thread: " + Thread.currentThread().getName());
            this.setContextClassLoader(Thread.currentThread().getContextClassLoader());
        }
        this.setPriority(n);
        this.m_bPaused = true;
        this.m_aHalted = new AtomicBoolean(false);
    }

    void setIdleWaitTime(long l) {
        this.m_nIdleWaitTime = l;
        this.m_nIdleWaitVariablness = (int)((double)l * 0.2);
    }

    private long _getRandomizedIdleWaitTime() {
        return this.m_nIdleWaitTime - (long)this.m_aRandom.nextInt(this.m_nIdleWaitVariablness);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void togglePause(boolean bl) {
        Object object = this.m_aSigLock;
        synchronized (object) {
            this.m_bPaused = bl;
            if (this.m_bPaused) {
                this.signalSchedulingChange(0L);
            } else {
                this.m_aSigLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void halt(boolean bl) {
        Object object = this.m_aSigLock;
        synchronized (object) {
            this.m_aHalted.set(true);
            if (this.m_bPaused) {
                this.m_aSigLock.notifyAll();
            } else {
                this.signalSchedulingChange(0L);
            }
        }
        if (bl) {
            boolean bl2 = false;
            try {
                while (true) {
                    try {
                        this.join();
                    }
                    catch (InterruptedException interruptedException) {
                        bl2 = true;
                        continue;
                    }
                    break;
                }
            }
            finally {
                if (bl2) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    boolean isPaused() {
        return this.m_bPaused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalSchedulingChange(long l) {
        Object object = this.m_aSigLock;
        synchronized (object) {
            this.m_bSignaled = true;
            this.m_nSignaledNextFireTime = l;
            this.m_aSigLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSignaledSchedulingChange() {
        Object object = this.m_aSigLock;
        synchronized (object) {
            this.m_bSignaled = false;
            this.m_nSignaledNextFireTime = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isScheduleChanged() {
        Object object = this.m_aSigLock;
        synchronized (object) {
            return this.m_bSignaled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSignaledNextFireTime() {
        Object object = this.m_aSigLock;
        synchronized (object) {
            return this.m_nSignaledNextFireTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl = false;
        while (!this.m_aHalted.get()) {
            try {
                long l;
                ICommonsList<IOperableTrigger> iCommonsList;
                block43: {
                    Object object = this.m_aSigLock;
                    synchronized (object) {
                        while (this.m_bPaused && !this.m_aHalted.get()) {
                            try {
                                this.m_aSigLock.wait(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        if (this.m_aHalted.get()) {
                            break;
                        }
                    }
                    int n = this.m_aQSRsrcs.getThreadPool().blockForAvailableThreads();
                    if (n <= 0) continue;
                    iCommonsList = null;
                    l = System.currentTimeMillis();
                    this.clearSignaledSchedulingChange();
                    try {
                        iCommonsList = this.m_aQSRsrcs.getJobStore().acquireNextTriggers(l + this.m_nIdleWaitTime, Math.min(n, this.m_aQSRsrcs.getMaxBatchSize()), this.m_aQSRsrcs.getBatchTimeWindow());
                        bl = false;
                        if (!LOGGER.isDebugEnabled()) break block43;
                        LOGGER.debug("batch acquisition of " + (iCommonsList == null ? 0 : iCommonsList.size()) + " triggers");
                    }
                    catch (JobPersistenceException jobPersistenceException) {
                        if (!bl) {
                            this.m_aQS.notifySchedulerListenersError("An error occurred while scanning for the next triggers to fire.", jobPersistenceException);
                        }
                        bl = true;
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                        if (!bl) {
                            LOGGER.error("quartzSchedulerThreadLoop: RuntimeException " + runtimeException.getMessage(), (Throwable)runtimeException);
                        }
                        bl = true;
                        continue;
                    }
                }
                if (iCommonsList != null && !iCommonsList.isEmpty()) {
                    ICommonsList<TriggerFiredResult> iCommonsList2;
                    block44: {
                        l = System.currentTimeMillis();
                        long l2 = ((IOperableTrigger)iCommonsList.get(0)).getNextFireTime().getTime();
                        long l3 = l2 - l;
                        while (l3 > 2L) {
                            iCommonsList2 = this.m_aSigLock;
                            synchronized (iCommonsList2) {
                                if (this.m_aHalted.get()) {
                                    break;
                                }
                                if (!this._isCandidateNewTimeEarlierWithinReason(l2, false)) {
                                    try {
                                        l = System.currentTimeMillis();
                                        l3 = l2 - l;
                                        if (l3 >= 1L) {
                                            this.m_aSigLock.wait(l3);
                                        }
                                    }
                                    catch (InterruptedException interruptedException) {
                                        Thread.currentThread().interrupt();
                                    }
                                }
                            }
                            if (this._releaseIfScheduleChangedSignificantly((List<IOperableTrigger>)iCommonsList, l2)) break;
                            l = System.currentTimeMillis();
                            l3 = l2 - l;
                        }
                        if (iCommonsList.isEmpty()) continue;
                        iCommonsList2 = new CommonsArrayList();
                        boolean bl2 = true;
                        ICommonsList<TriggerFiredResult> iCommonsList3 = this.m_aSigLock;
                        synchronized (iCommonsList3) {
                            bl2 = !this.m_aHalted.get();
                        }
                        if (bl2) {
                            try {
                                iCommonsList3 = this.m_aQSRsrcs.getJobStore().triggersFired((List<IOperableTrigger>)iCommonsList);
                                if (iCommonsList3 == null) break block44;
                                iCommonsList2 = iCommonsList3;
                            }
                            catch (SchedulerException schedulerException) {
                                this.m_aQS.notifySchedulerListenersError("An error occurred while firing triggers '" + String.valueOf(iCommonsList) + "'", schedulerException);
                                for (Object object : iCommonsList) {
                                    this.m_aQSRsrcs.getJobStore().releaseAcquiredTrigger((IOperableTrigger)object);
                                }
                                continue;
                            }
                        }
                    }
                    for (int i = 0; i < iCommonsList2.size(); ++i) {
                        Object object;
                        TriggerFiredResult triggerFiredResult = (TriggerFiredResult)iCommonsList2.get(i);
                        object = triggerFiredResult.getTriggerFiredBundle();
                        Exception exception = triggerFiredResult.getException();
                        if (exception instanceof RuntimeException) {
                            LOGGER.error("RuntimeException while firing trigger " + String.valueOf(iCommonsList.get(i)), (Throwable)exception);
                            this.m_aQSRsrcs.getJobStore().releaseAcquiredTrigger((IOperableTrigger)iCommonsList.get(i));
                            continue;
                        }
                        if (object == null) {
                            this.m_aQSRsrcs.getJobStore().releaseAcquiredTrigger((IOperableTrigger)iCommonsList.get(i));
                            continue;
                        }
                        JobRunShell jobRunShell = null;
                        try {
                            jobRunShell = this.m_aQSRsrcs.getJobRunShellFactory().createJobRunShell((TriggerFiredBundle)object);
                            jobRunShell.initialize(this.m_aQS);
                        }
                        catch (SchedulerException schedulerException) {
                            this.m_aQSRsrcs.getJobStore().triggeredJobComplete((IOperableTrigger)iCommonsList.get(i), ((TriggerFiredBundle)object).getJobDetail(), ITrigger.ECompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_ERROR);
                            continue;
                        }
                        if (this.m_aQSRsrcs.getThreadPool().runInThread(jobRunShell)) continue;
                        LOGGER.error("ThreadPool.runInThread() return false!");
                        this.m_aQSRsrcs.getJobStore().triggeredJobComplete((IOperableTrigger)iCommonsList.get(i), ((TriggerFiredBundle)object).getJobDetail(), ITrigger.ECompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_ERROR);
                    }
                    continue;
                }
                long l4 = System.currentTimeMillis();
                long l5 = l4 + this._getRandomizedIdleWaitTime();
                long l6 = l5 - l4;
                Object object = this.m_aSigLock;
                synchronized (object) {
                    try {
                        if (!this.m_aHalted.get() && !this.isScheduleChanged()) {
                            this.m_aSigLock.wait(l6);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                LOGGER.error("Runtime error occurred in main trigger firing loop.", (Throwable)runtimeException);
            }
        }
        this.m_aQS = null;
        this.m_aQSRsrcs = null;
    }

    private boolean _releaseIfScheduleChangedSignificantly(List<IOperableTrigger> list, long l) {
        if (this._isCandidateNewTimeEarlierWithinReason(l, true)) {
            for (IOperableTrigger iOperableTrigger : list) {
                this.m_aQSRsrcs.getJobStore().releaseAcquiredTrigger(iOperableTrigger);
            }
            list.clear();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _isCandidateNewTimeEarlierWithinReason(long l, boolean bl) {
        Object object = this.m_aSigLock;
        synchronized (object) {
            long l2;
            boolean bl2;
            if (!this.isScheduleChanged()) {
                return false;
            }
            boolean bl3 = bl2 = this.getSignaledNextFireTime() == 0L || this.getSignaledNextFireTime() < l;
            if (bl2 && (l2 = l - System.currentTimeMillis()) < (this.m_aQSRsrcs.getJobStore().supportsPersistence() ? 70L : 7L)) {
                bl2 = false;
            }
            if (bl) {
                this.clearSignaledSchedulingChange();
            }
            return bl2;
        }
    }
}

