/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.impl;

import com.helger.collection.commons.ICommonsCollection;
import com.helger.quartz.IScheduler;
import com.helger.quartz.ISchedulerFactory;
import com.helger.quartz.SchedulerException;
import com.helger.quartz.core.QuartzScheduler;
import com.helger.quartz.core.QuartzSchedulerResources;
import com.helger.quartz.impl.DefaultThreadExecutor;
import com.helger.quartz.impl.SchedulerRepository;
import com.helger.quartz.impl.StdJobRunShellFactory;
import com.helger.quartz.impl.StdScheduler;
import com.helger.quartz.simpl.CascadingClassLoadHelper;
import com.helger.quartz.simpl.RAMJobStore;
import com.helger.quartz.simpl.SimpleThreadPool;
import com.helger.quartz.spi.IJobStore;
import com.helger.quartz.spi.ISchedulerPlugin;
import com.helger.quartz.spi.IThreadExecutor;
import com.helger.quartz.spi.IThreadPool;
import jakarta.annotation.Nonnull;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectSchedulerFactory
implements ISchedulerFactory {
    public static final String DEFAULT_INSTANCE_ID = "SIMPLE_NON_CLUSTERED";
    public static final String DEFAULT_SCHEDULER_NAME = "SimpleQuartzScheduler";
    private static final DefaultThreadExecutor DEFAULT_THREAD_EXECUTOR = new DefaultThreadExecutor();
    private static final int DEFAULT_BATCH_MAX_SIZE = 1;
    private static final long DEFAULT_BATCH_TIME_WINDOW = 0L;
    private boolean m_bInitialized = false;
    private static DirectSchedulerFactory s_aInstance = new DirectSchedulerFactory();
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectSchedulerFactory.class);

    protected DirectSchedulerFactory() {
    }

    @Nonnull
    public static DirectSchedulerFactory getInstance() {
        return s_aInstance;
    }

    public void createVolatileScheduler(int n) throws SchedulerException {
        SimpleThreadPool simpleThreadPool = new SimpleThreadPool(n, 5);
        simpleThreadPool.initialize();
        RAMJobStore rAMJobStore = new RAMJobStore();
        this.createScheduler(simpleThreadPool, rAMJobStore);
    }

    public void createScheduler(IThreadPool iThreadPool, IJobStore iJobStore) throws SchedulerException {
        this.createScheduler(DEFAULT_SCHEDULER_NAME, DEFAULT_INSTANCE_ID, iThreadPool, iJobStore);
    }

    public void createScheduler(String string, String string2, IThreadPool iThreadPool, IJobStore iJobStore) throws SchedulerException {
        this.createScheduler(string, string2, iThreadPool, iJobStore, -1L);
    }

    public void createScheduler(String string, String string2, IThreadPool iThreadPool, IJobStore iJobStore, long l) throws SchedulerException {
        this.createScheduler(string, string2, iThreadPool, iJobStore, null, l);
    }

    public void createScheduler(String string, String string2, IThreadPool iThreadPool, IJobStore iJobStore, Map<String, ISchedulerPlugin> map, long l) throws SchedulerException {
        this.createScheduler(string, string2, iThreadPool, DEFAULT_THREAD_EXECUTOR, iJobStore, map, l);
    }

    public void createScheduler(String string, String string2, IThreadPool iThreadPool, IThreadExecutor iThreadExecutor, IJobStore iJobStore, Map<String, ISchedulerPlugin> map, long l) throws SchedulerException {
        this.createScheduler(string, string2, iThreadPool, DEFAULT_THREAD_EXECUTOR, iJobStore, map, l, 1, 0L);
    }

    public void createScheduler(String string, String string2, IThreadPool iThreadPool, IThreadExecutor iThreadExecutor, IJobStore iJobStore, Map<String, ISchedulerPlugin> map, long l, int n, long l2) throws SchedulerException {
        StdJobRunShellFactory stdJobRunShellFactory = new StdJobRunShellFactory();
        iThreadPool.initialize();
        QuartzSchedulerResources quartzSchedulerResources = new QuartzSchedulerResources();
        quartzSchedulerResources.setName(string);
        quartzSchedulerResources.setInstanceId(string2);
        iThreadPool.setInstanceName(string);
        iThreadPool.setInstanceId(string2);
        quartzSchedulerResources.setJobRunShellFactory(stdJobRunShellFactory);
        quartzSchedulerResources.setThreadPool(iThreadPool);
        quartzSchedulerResources.setThreadExecutor(iThreadExecutor);
        quartzSchedulerResources.setJobStore(iJobStore);
        quartzSchedulerResources.setMaxBatchSize(n);
        quartzSchedulerResources.setBatchTimeWindow(l2);
        if (map != null) {
            for (ISchedulerPlugin object2 : map.values()) {
                quartzSchedulerResources.addSchedulerPlugin(object2);
            }
        }
        QuartzScheduler quartzScheduler = new QuartzScheduler(quartzSchedulerResources, l);
        CascadingClassLoadHelper cascadingClassLoadHelper = new CascadingClassLoadHelper();
        cascadingClassLoadHelper.initialize();
        iJobStore.setInstanceName(string);
        iJobStore.setInstanceId(string2);
        iJobStore.initialize(cascadingClassLoadHelper, quartzScheduler.getSchedulerSignaler());
        StdScheduler stdScheduler = new StdScheduler(quartzScheduler);
        stdJobRunShellFactory.initialize(stdScheduler);
        quartzScheduler.initialize();
        if (map != null) {
            for (Map.Entry<String, ISchedulerPlugin> entry : map.entrySet()) {
                entry.getValue().initialize(entry.getKey(), stdScheduler, cascadingClassLoadHelper);
            }
        }
        LOGGER.info("Quartz scheduler '" + stdScheduler.getSchedulerName());
        LOGGER.info("Quartz scheduler version: " + quartzScheduler.getVersion());
        SchedulerRepository schedulerRepository = SchedulerRepository.getInstance();
        quartzScheduler.addNoGCObject(schedulerRepository);
        schedulerRepository.bind(stdScheduler);
        this.m_bInitialized = true;
    }

    @Override
    public IScheduler getScheduler() throws SchedulerException {
        if (!this.m_bInitialized) {
            throw new SchedulerException("you must call createRemoteScheduler or createScheduler methods before calling getScheduler()");
        }
        return this.getScheduler(DEFAULT_SCHEDULER_NAME);
    }

    @Override
    public IScheduler getScheduler(String string) throws SchedulerException {
        SchedulerRepository schedulerRepository = SchedulerRepository.getInstance();
        return schedulerRepository.lookup(string);
    }

    @Override
    public ICommonsCollection<IScheduler> getAllSchedulers() throws SchedulerException {
        return SchedulerRepository.getInstance().lookupAll();
    }
}

