/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.impl;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.quartz.IScheduler;
import com.helger.quartz.SchedulerException;
import jakarta.annotation.Nonnull;

public class SchedulerRepository {
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final ICommonsMap<String, IScheduler> m_aSchedulers = new CommonsHashMap();

    private SchedulerRepository() {
    }

    @Nonnull
    public static SchedulerRepository getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void bind(IScheduler iScheduler) throws SchedulerException {
        String string = iScheduler.getSchedulerName();
        this.m_aRWLock.writeLockedThrowing(() -> {
            if (this.m_aSchedulers.containsKey((Object)string)) {
                throw new SchedulerException("Scheduler with name '" + string + "' already exists.");
            }
            this.m_aSchedulers.put((Object)string, (Object)iScheduler);
        });
    }

    public boolean remove(String string) {
        return this.m_aRWLock.writeLockedBoolean(() -> this.m_aSchedulers.remove((Object)string) != null);
    }

    public IScheduler lookup(String string) {
        return (IScheduler)this.m_aRWLock.readLockedGet(() -> (IScheduler)this.m_aSchedulers.get((Object)string));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IScheduler> lookupAll() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> this.m_aSchedulers.copyOfValues());
    }

    private static final class SingletonHolder {
        static final SchedulerRepository INSTANCE = new SchedulerRepository();

        private SingletonHolder() {
        }
    }
}

