/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.impl;

import com.helger.annotation.WillNotClose;
import com.helger.base.io.nonblocking.NonBlockingBufferedInputStream;
import com.helger.base.rt.NonBlockingProperties;
import com.helger.base.system.SystemProperties;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsCollection;
import com.helger.collection.commons.ICommonsList;
import com.helger.io.file.FileHelper;
import com.helger.io.resource.ClassPathResource;
import com.helger.quartz.IJobListener;
import com.helger.quartz.IMatcher;
import com.helger.quartz.IScheduler;
import com.helger.quartz.ISchedulerFactory;
import com.helger.quartz.ITriggerListener;
import com.helger.quartz.JobKey;
import com.helger.quartz.SchedulerConfigException;
import com.helger.quartz.SchedulerException;
import com.helger.quartz.TriggerKey;
import com.helger.quartz.core.IJobRunShellFactory;
import com.helger.quartz.core.QuartzScheduler;
import com.helger.quartz.core.QuartzSchedulerResources;
import com.helger.quartz.impl.DefaultThreadExecutor;
import com.helger.quartz.impl.SchedulerRepository;
import com.helger.quartz.impl.StdJobRunShellFactory;
import com.helger.quartz.impl.StdScheduler;
import com.helger.quartz.impl.matchers.EverythingMatcher;
import com.helger.quartz.simpl.CascadingClassLoadHelper;
import com.helger.quartz.simpl.RAMJobStore;
import com.helger.quartz.simpl.SimpleInstanceIdGenerator;
import com.helger.quartz.simpl.SimpleThreadPool;
import com.helger.quartz.simpl.SystemPropertyInstanceIdGenerator;
import com.helger.quartz.spi.IClassLoadHelper;
import com.helger.quartz.spi.IInstanceIdGenerator;
import com.helger.quartz.spi.IJobFactory;
import com.helger.quartz.spi.IJobStore;
import com.helger.quartz.spi.ISchedulerPlugin;
import com.helger.quartz.spi.IThreadExecutor;
import com.helger.quartz.spi.IThreadPool;
import com.helger.quartz.utils.PropertiesParser;
import jakarta.annotation.Nonnull;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StdSchedulerFactory
implements ISchedulerFactory {
    public static final String PROP_PROPERTIES_FILE = "org.quartz.properties";
    public static final String PROP_SCHED_INSTANCE_NAME = "org.quartz.scheduler.instanceName";
    public static final String PROP_SCHED_INSTANCE_ID = "org.quartz.scheduler.instanceId";
    public static final String PROP_SCHED_INSTANCE_ID_GENERATOR_PREFIX = "org.quartz.scheduler.instanceIdGenerator";
    public static final String PROP_SCHED_INSTANCE_ID_GENERATOR_CLASS = "org.quartz.scheduler.instanceIdGenerator.class";
    public static final String PROP_SCHED_THREAD_NAME = "org.quartz.scheduler.threadName";
    public static final String PROP_SCHED_BATCH_TIME_WINDOW = "org.quartz.scheduler.batchTriggerAcquisitionFireAheadTimeWindow";
    public static final String PROP_SCHED_MAX_BATCH_SIZE = "org.quartz.scheduler.batchTriggerAcquisitionMaxCount";
    public static final String PROP_SCHED_IDLE_WAIT_TIME = "org.quartz.scheduler.idleWaitTime";
    public static final String PROP_SCHED_MAKE_SCHEDULER_THREAD_DAEMON = "org.quartz.scheduler.makeSchedulerThreadDaemon";
    public static final String PROP_SCHED_SCHEDULER_THREADS_INHERIT_CONTEXT_CLASS_LOADER_OF_INITIALIZING_THREAD = "org.quartz.scheduler.threadsInheritContextClassLoaderOfInitializer";
    public static final String PROP_SCHED_CLASS_LOAD_HELPER_CLASS = "org.quartz.scheduler.classLoadHelper.class";
    public static final String PROP_SCHED_JOB_FACTORY_CLASS = "org.quartz.scheduler.jobFactory.class";
    public static final String PROP_SCHED_JOB_FACTORY_PREFIX = "org.quartz.scheduler.jobFactory";
    public static final String PROP_SCHED_INTERRUPT_JOBS_ON_SHUTDOWN = "org.quartz.scheduler.interruptJobsOnShutdown";
    public static final String PROP_SCHED_INTERRUPT_JOBS_ON_SHUTDOWN_WITH_WAIT = "org.quartz.scheduler.interruptJobsOnShutdownWithWait";
    public static final String PROP_SCHED_CONTEXT_PREFIX = "org.quartz.context.key";
    public static final String PROP_THREAD_POOL_PREFIX = "org.quartz.threadPool";
    public static final String PROP_THREAD_POOL_CLASS = "org.quartz.threadPool.class";
    public static final String PROP_JOB_STORE_PREFIX = "org.quartz.jobStore";
    public static final String PROP_JOB_STORE_LOCK_HANDLER_PREFIX = "org.quartz.jobStore.lockHandler";
    public static final String PROP_JOB_STORE_LOCK_HANDLER_CLASS = "org.quartz.jobStore.lockHandler.class";
    public static final String PROP_JOB_STORE_CLASS = "org.quartz.jobStore.class";
    public static final String PROP_JOB_STORE_USE_PROP = "org.quartz.jobStore.useProperties";
    public static final String PROP_PLUGIN_PREFIX = "org.quartz.plugin";
    public static final String PROP_PLUGIN_CLASS = "class";
    public static final String PROP_JOB_LISTENER_PREFIX = "org.quartz.jobListener";
    public static final String PROP_TRIGGER_LISTENER_PREFIX = "org.quartz.triggerListener";
    public static final String PROP_LISTENER_CLASS = "class";
    public static final String DEFAULT_INSTANCE_ID = "NON_CLUSTERED";
    public static final String AUTO_GENERATE_INSTANCE_ID = "AUTO";
    public static final String PROP_THREAD_EXECUTOR = "org.quartz.threadExecutor";
    public static final String PROP_THREAD_EXECUTOR_CLASS = "org.quartz.threadExecutor.class";
    public static final String SYSTEM_PROPERTY_AS_INSTANCE_ID = "SYS_PROP";
    public static final String DEFAULT_FILENAME = "quartz.properties";
    private static final Logger LOGGER = LoggerFactory.getLogger(StdSchedulerFactory.class);
    private SchedulerException m_aInitException;
    private String m_sPropSrc;
    private PropertiesParser m_aCfg;

    @Nonnull
    public StdSchedulerFactory initialize() throws SchedulerException {
        NonBlockingProperties nonBlockingProperties;
        block30: {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("StdSchedulerFactory.initalize");
            }
            if (this.m_aCfg != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("StdSchedulerFactory already initalized");
                }
                return this;
            }
            if (this.m_aInitException != null) {
                throw this.m_aInitException;
            }
            String string = SystemProperties.getPropertyValueOrNull((String)PROP_PROPERTIES_FILE);
            String string2 = string != null ? string : DEFAULT_FILENAME;
            File file = new File(string2);
            nonBlockingProperties = new NonBlockingProperties();
            if (file.exists()) {
                try {
                    this.m_sPropSrc = string != null ? "specified file: '" + string + "'" : "default file in current working dir: 'quartz.properties'";
                    try (NonBlockingBufferedInputStream nonBlockingBufferedInputStream = new NonBlockingBufferedInputStream((InputStream)new FileInputStream(string2));){
                        nonBlockingProperties.load((InputStream)nonBlockingBufferedInputStream);
                        break block30;
                    }
                }
                catch (IOException iOException) {
                    this.m_aInitException = new SchedulerException("Properties file: '" + string2 + "' could not be read.", iOException);
                    throw this.m_aInitException;
                }
            }
            if (string != null) {
                InputStream inputStream = ClassPathResource.getInputStream((String)string);
                if (inputStream == null) {
                    this.m_aInitException = new SchedulerException("Properties file: '" + string + "' could not be found.");
                    throw this.m_aInitException;
                }
                this.m_sPropSrc = "specified file: '" + string + "' in the class resource path.";
                try (NonBlockingBufferedInputStream nonBlockingBufferedInputStream = new NonBlockingBufferedInputStream(inputStream);){
                    nonBlockingProperties.load((InputStream)nonBlockingBufferedInputStream);
                    break block30;
                }
                catch (IOException iOException) {
                    this.m_aInitException = new SchedulerException("Properties file: '" + string + "' could not be read.", iOException);
                    throw this.m_aInitException;
                }
            }
            this.m_sPropSrc = "default resource file in Quartz package: 'quartz.properties'";
            InputStream inputStream = ClassPathResource.getInputStream((String)DEFAULT_FILENAME);
            if (inputStream == null) {
                inputStream = ClassPathResource.getInputStream((String)"quartz/quartz.properties");
            }
            if (inputStream == null) {
                this.m_aInitException = new SchedulerException("Default quartz.properties not found in class path");
                throw this.m_aInitException;
            }
            try (NonBlockingBufferedInputStream nonBlockingBufferedInputStream = new NonBlockingBufferedInputStream(inputStream);){
                nonBlockingProperties.load((InputStream)nonBlockingBufferedInputStream);
            }
            catch (IOException iOException) {
                this.m_aInitException = new SchedulerException("Resource properties file: quartz.properties could not be read from the classpath.", iOException);
                throw this.m_aInitException;
            }
        }
        return this.initialize(StdSchedulerFactory._overrideWithSysProps(nonBlockingProperties));
    }

    @Nonnull
    private static NonBlockingProperties _overrideWithSysProps(@Nonnull NonBlockingProperties nonBlockingProperties) {
        for (Map.Entry entry : SystemProperties.getAllProperties().entrySet()) {
            nonBlockingProperties.put((Object)((String)entry.getKey()), (Object)((String)entry.getValue()));
        }
        return nonBlockingProperties;
    }

    @Nonnull
    public StdSchedulerFactory initialize(String string) throws SchedulerException {
        if (this.m_aCfg != null) {
            return this;
        }
        if (this.m_aInitException != null) {
            throw this.m_aInitException;
        }
        NonBlockingProperties nonBlockingProperties = new NonBlockingProperties();
        try {
            InputStream inputStream = ClassPathResource.getInputStream((String)string);
            if (inputStream != null) {
                this.m_sPropSrc = "the specified file : '" + string + "' from the class resource path.";
            } else {
                inputStream = FileHelper.getInputStream((File)new File(string));
                this.m_sPropSrc = "the specified file : '" + string + "'";
            }
            try (NonBlockingBufferedInputStream nonBlockingBufferedInputStream = new NonBlockingBufferedInputStream(inputStream);){
                nonBlockingProperties.load(inputStream);
            }
        }
        catch (IOException iOException) {
            this.m_aInitException = new SchedulerException("Properties file: '" + string + "' could not be read.", iOException);
            throw this.m_aInitException;
        }
        return this.initialize(nonBlockingProperties);
    }

    @Nonnull
    public StdSchedulerFactory initialize(@Nonnull @WillNotClose InputStream inputStream) throws SchedulerException {
        if (this.m_aCfg != null) {
            return this;
        }
        if (this.m_aInitException != null) {
            throw this.m_aInitException;
        }
        NonBlockingProperties nonBlockingProperties = new NonBlockingProperties();
        if (inputStream != null) {
            try {
                nonBlockingProperties.load(inputStream);
                this.m_sPropSrc = "an externally opened InputStream.";
            }
            catch (IOException iOException) {
                this.m_aInitException = new SchedulerException("Error loading property data from InputStream", iOException);
                throw this.m_aInitException;
            }
        } else {
            this.m_aInitException = new SchedulerException("Error loading property data from InputStream - InputStream is null.");
            throw this.m_aInitException;
        }
        return this.initialize(nonBlockingProperties);
    }

    @Nonnull
    public StdSchedulerFactory initialize(NonBlockingProperties nonBlockingProperties) throws SchedulerException {
        if (this.m_sPropSrc == null) {
            this.m_sPropSrc = "an externally provided properties instance.";
        }
        this.m_aCfg = new PropertiesParser(nonBlockingProperties);
        return this;
    }

    private IScheduler _instantiate() throws SchedulerException {
        IThreadExecutor iThreadExecutor;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object52;
        Object object6;
        NonBlockingProperties nonBlockingProperties;
        ICommonsList<String> iCommonsList3;
        String string;
        NonBlockingProperties nonBlockingProperties2;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("StdSchedulerFactory._instantiate");
        }
        if (this.m_aCfg == null) {
            this.initialize();
        }
        if (this.m_aInitException != null) {
            throw this.m_aInitException;
        }
        IJobStore iJobStore = null;
        IThreadPool iThreadPool = null;
        QuartzScheduler quartzScheduler = null;
        String string2 = null;
        boolean bl = false;
        long l = -1L;
        SchedulerRepository schedulerRepository = SchedulerRepository.getInstance();
        String string3 = this.m_aCfg.getStringProperty(PROP_SCHED_INSTANCE_NAME, "MiniQuartzScheduler");
        String string4 = this.m_aCfg.getStringProperty(PROP_SCHED_THREAD_NAME, string3 + "_MiniQuartzSchedulerThread");
        String string5 = this.m_aCfg.getStringProperty(PROP_SCHED_INSTANCE_ID, DEFAULT_INSTANCE_ID);
        if (string5.equals(AUTO_GENERATE_INSTANCE_ID)) {
            bl = true;
            string2 = this.m_aCfg.getStringProperty(PROP_SCHED_INSTANCE_ID_GENERATOR_CLASS, SimpleInstanceIdGenerator.class.getName());
        } else if (string5.equals(SYSTEM_PROPERTY_AS_INSTANCE_ID)) {
            bl = true;
            string2 = SystemPropertyInstanceIdGenerator.class.getName();
        }
        String string6 = this.m_aCfg.getStringProperty(PROP_SCHED_CLASS_LOAD_HELPER_CLASS, CascadingClassLoadHelper.class.getName());
        String string7 = this.m_aCfg.getStringProperty(PROP_SCHED_JOB_FACTORY_CLASS, null);
        l = this.m_aCfg.getLongProperty(PROP_SCHED_IDLE_WAIT_TIME, l);
        if (l > -1L && l < 1000L) {
            throw new SchedulerException("org.quartz.scheduler.idleWaitTime of less than 1000ms is not legal.");
        }
        boolean bl2 = this.m_aCfg.getBooleanProperty(PROP_SCHED_MAKE_SCHEDULER_THREAD_DAEMON);
        boolean bl3 = this.m_aCfg.getBooleanProperty(PROP_SCHED_SCHEDULER_THREADS_INHERIT_CONTEXT_CLASS_LOADER_OF_INITIALIZING_THREAD);
        long l2 = this.m_aCfg.getLongProperty(PROP_SCHED_BATCH_TIME_WINDOW, 0L);
        int n = this.m_aCfg.getIntProperty(PROP_SCHED_MAX_BATCH_SIZE, 1);
        boolean bl4 = this.m_aCfg.getBooleanProperty(PROP_SCHED_INTERRUPT_JOBS_ON_SHUTDOWN, false);
        boolean bl5 = this.m_aCfg.getBooleanProperty(PROP_SCHED_INTERRUPT_JOBS_ON_SHUTDOWN_WITH_WAIT, false);
        NonBlockingProperties nonBlockingProperties3 = this.m_aCfg.getPropertyGroup(PROP_SCHED_CONTEXT_PREFIX, true);
        IClassLoadHelper iClassLoadHelper = null;
        try {
            iClassLoadHelper = (IClassLoadHelper)this._loadClass(string6).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new SchedulerConfigException("Unable to instantiate class load helper class: " + exception.getMessage(), exception);
        }
        iClassLoadHelper.initialize();
        IJobFactory iJobFactory = null;
        if (string7 != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Creating jobFactoryClass " + string7);
            }
            try {
                iJobFactory = (IJobFactory)iClassLoadHelper.loadClass(string7).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                throw new SchedulerConfigException("Unable to instantiate JobFactory class: " + exception.getMessage(), exception);
            }
            nonBlockingProperties2 = this.m_aCfg.getPropertyGroup(PROP_SCHED_JOB_FACTORY_PREFIX, true);
            try {
                this._setBeanProps(iJobFactory, nonBlockingProperties2);
            }
            catch (Exception exception) {
                this.m_aInitException = new SchedulerException("JobFactory class '" + string7 + "' props could not be configured.", exception);
                throw this.m_aInitException;
            }
        }
        IInstanceIdGenerator iInstanceIdGenerator = null;
        if (string2 != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Creating instanceIdGeneratorClass " + string2);
            }
            try {
                iInstanceIdGenerator = (IInstanceIdGenerator)iClassLoadHelper.loadClass(string2).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                throw new SchedulerConfigException("Unable to instantiate InstanceIdGenerator class: " + exception.getMessage(), exception);
            }
            nonBlockingProperties2 = this.m_aCfg.getPropertyGroup(PROP_SCHED_INSTANCE_ID_GENERATOR_PREFIX, true);
            try {
                this._setBeanProps(iInstanceIdGenerator, nonBlockingProperties2);
            }
            catch (Exception exception) {
                this.m_aInitException = new SchedulerException("InstanceIdGenerator class '" + string2 + "' props could not be configured.", exception);
                throw this.m_aInitException;
            }
        }
        if ((string = this.m_aCfg.getStringProperty(PROP_THREAD_POOL_CLASS, SimpleThreadPool.class.getName())) == null) {
            this.m_aInitException = new SchedulerException("ThreadPool class not specified. ");
            throw this.m_aInitException;
        }
        try {
            iThreadPool = (IThreadPool)iClassLoadHelper.loadClass(string).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            this.m_aInitException = new SchedulerException("ThreadPool class '" + string + "' could not be instantiated.", exception);
            throw this.m_aInitException;
        }
        nonBlockingProperties2 = this.m_aCfg.getPropertyGroup(PROP_THREAD_POOL_PREFIX, true);
        try {
            this._setBeanProps(iThreadPool, nonBlockingProperties2);
        }
        catch (Exception exception) {
            this.m_aInitException = new SchedulerException("ThreadPool class '" + string + "' props could not be configured.", exception);
            throw this.m_aInitException;
        }
        String string8 = this.m_aCfg.getStringProperty(PROP_JOB_STORE_CLASS, RAMJobStore.class.getName());
        if (string8 == null) {
            this.m_aInitException = new SchedulerException("JobStore class not specified. ");
            throw this.m_aInitException;
        }
        try {
            iJobStore = (IJobStore)iClassLoadHelper.loadClass(string8).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            this.m_aInitException = new SchedulerException("JobStore class '" + string8 + "' could not be instantiated.", exception);
            throw this.m_aInitException;
        }
        iJobStore.setInstanceName(string3);
        iJobStore.setInstanceId(string5);
        nonBlockingProperties2 = this.m_aCfg.getPropertyGroup(PROP_JOB_STORE_PREFIX, true, new String[]{PROP_JOB_STORE_LOCK_HANDLER_PREFIX});
        try {
            this._setBeanProps(iJobStore, nonBlockingProperties2);
        }
        catch (Exception exception) {
            this.m_aInitException = new SchedulerException("JobStore class '" + string8 + "' props could not be configured.", exception);
            throw this.m_aInitException;
        }
        ICommonsList<String> iCommonsList2 = this.m_aCfg.getPropertyGroups(PROP_PLUGIN_PREFIX);
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (ICommonsList<String> iCommonsList3 : iCommonsList2) {
            nonBlockingProperties = this.m_aCfg.getPropertyGroup("org.quartz.plugin." + (String)iCommonsList3, true);
            object6 = nonBlockingProperties.getProperty("class", null);
            if (object6 == null) {
                this.m_aInitException = new SchedulerException("SchedulerPlugin class not specified for plugin '" + iCommonsList3 + "'");
                throw this.m_aInitException;
            }
            object52 = null;
            try {
                object52 = (ISchedulerPlugin)iClassLoadHelper.loadClass((String)object6).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                this.m_aInitException = new SchedulerException("SchedulerPlugin class '" + object6 + "' could not be instantiated.", exception);
                throw this.m_aInitException;
            }
            try {
                this._setBeanProps(object52, nonBlockingProperties);
            }
            catch (Exception exception) {
                this.m_aInitException = new SchedulerException("JobStore SchedulerPlugin '" + object6 + "' props could not be configured.", exception);
                throw this.m_aInitException;
            }
            commonsArrayList.add(object52);
        }
        Class[] classArray = new Class[]{String.class};
        iCommonsList3 = this.m_aCfg.getPropertyGroups(PROP_JOB_LISTENER_PREFIX);
        nonBlockingProperties = new CommonsArrayList();
        for (Object object52 : iCommonsList3) {
            NonBlockingProperties nonBlockingProperties4 = this.m_aCfg.getPropertyGroup("org.quartz.jobListener." + (String)object52, true);
            String string9 = nonBlockingProperties4.getProperty("class", null);
            if (string9 == null) {
                this.m_aInitException = new SchedulerException("JobListener class not specified for listener '" + (String)object52 + "'");
                throw this.m_aInitException;
            }
            object4 = null;
            try {
                object4 = (IJobListener)iClassLoadHelper.loadClass(string9).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                this.m_aInitException = new SchedulerException("JobListener class '" + string9 + "' could not be instantiated.", exception);
                throw this.m_aInitException;
            }
            try {
                object3 = null;
                try {
                    object3 = object4.getClass().getMethod("setName", classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (object3 != null) {
                    ((Method)object3).invoke(object4, object52);
                }
                this._setBeanProps(object4, nonBlockingProperties4);
            }
            catch (Exception exception) {
                this.m_aInitException = new SchedulerException("JobListener '" + string9 + "' props could not be configured.", exception);
                throw this.m_aInitException;
            }
            nonBlockingProperties.add(object4);
        }
        object6 = this.m_aCfg.getPropertyGroups(PROP_TRIGGER_LISTENER_PREFIX);
        object52 = new CommonsArrayList();
        for (String string9 : object6) {
            object4 = this.m_aCfg.getPropertyGroup("org.quartz.triggerListener." + string9, true);
            object3 = object4.getProperty("class", null);
            if (object3 == null) {
                this.m_aInitException = new SchedulerException("TriggerListener class not specified for listener '" + string9 + "'");
                throw this.m_aInitException;
            }
            object2 = null;
            try {
                object2 = (ITriggerListener)iClassLoadHelper.loadClass((String)object3).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                this.m_aInitException = new SchedulerException("TriggerListener class '" + (String)object3 + "' could not be instantiated.", exception);
                throw this.m_aInitException;
            }
            try {
                object = null;
                try {
                    object = object2.getClass().getMethod("setName", classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (object != null) {
                    ((Method)object).invoke(object2, string9);
                }
                this._setBeanProps(object2, (NonBlockingProperties)object4);
            }
            catch (Exception exception) {
                this.m_aInitException = new SchedulerException("TriggerListener '" + (String)object3 + "' props could not be configured.", exception);
                throw this.m_aInitException;
            }
            object52.add(object2);
        }
        boolean bl6 = false;
        boolean bl7 = false;
        object4 = this.m_aCfg.getStringProperty(PROP_THREAD_EXECUTOR_CLASS);
        if (object4 != null) {
            nonBlockingProperties2 = this.m_aCfg.getPropertyGroup(PROP_THREAD_EXECUTOR, true);
            try {
                iThreadExecutor = (IThreadExecutor)iClassLoadHelper.loadClass((String)object4).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                LOGGER.info("Using custom implementation for ThreadExecutor: " + (String)object4);
                this._setBeanProps(iThreadExecutor, nonBlockingProperties2);
            }
            catch (Exception exception) {
                this.m_aInitException = new SchedulerException("ThreadExecutor class '" + (String)object4 + "' could not be instantiated.", exception);
                throw this.m_aInitException;
            }
        } else {
            LOGGER.info("Using default implementation for ThreadExecutor");
            iThreadExecutor = new DefaultThreadExecutor();
        }
        try {
            object3 = new StdJobRunShellFactory();
            if (bl) {
                try {
                    string5 = DEFAULT_INSTANCE_ID;
                    if (iJobStore.isClustered()) {
                        string5 = iInstanceIdGenerator.generateInstanceId();
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Couldn't generate instance Id!", (Throwable)exception);
                    throw new IllegalStateException("Cannot run without an instance id.");
                }
            }
            object2 = new QuartzSchedulerResources();
            ((QuartzSchedulerResources)object2).setName(string3);
            ((QuartzSchedulerResources)object2).setThreadName(string4);
            ((QuartzSchedulerResources)object2).setInstanceId(string5);
            ((QuartzSchedulerResources)object2).setJobRunShellFactory((IJobRunShellFactory)object3);
            ((QuartzSchedulerResources)object2).setMakeSchedulerThreadDaemon(bl2);
            ((QuartzSchedulerResources)object2).setThreadsInheritInitializersClassLoadContext(bl3);
            ((QuartzSchedulerResources)object2).setBatchTimeWindow(l2);
            ((QuartzSchedulerResources)object2).setMaxBatchSize(n);
            ((QuartzSchedulerResources)object2).setInterruptJobsOnShutdown(bl4);
            ((QuartzSchedulerResources)object2).setInterruptJobsOnShutdownWithWait(bl5);
            iThreadPool.setInstanceName(string3);
            iThreadPool.setInstanceId(string5);
            ((QuartzSchedulerResources)object2).setThreadExecutor(iThreadExecutor);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Initializing ThreadExecutor");
            }
            iThreadExecutor.initialize();
            ((QuartzSchedulerResources)object2).setThreadPool(iThreadPool);
            if (iThreadPool instanceof SimpleThreadPool) {
                object = (SimpleThreadPool)iThreadPool;
                if (bl3) {
                    ((SimpleThreadPool)object).setThreadsInheritContextClassLoaderOfInitializingThread(bl3);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Initializing ThreadPool");
            }
            iThreadPool.initialize();
            bl6 = true;
            ((QuartzSchedulerResources)object2).setJobStore(iJobStore);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Adding " + commonsArrayList.size() + " scheduler plugins");
            }
            for (ISchedulerPlugin iSchedulerPlugin : commonsArrayList) {
                ((QuartzSchedulerResources)object2).addSchedulerPlugin(iSchedulerPlugin);
            }
            quartzScheduler = new QuartzScheduler((QuartzSchedulerResources)object2, l);
            bl7 = true;
            object = this.instantiate((QuartzSchedulerResources)object2, quartzScheduler);
            if (iJobFactory != null) {
                quartzScheduler.setJobFactory(iJobFactory);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Initializing scheduler plugins");
            }
            for (int i = 0; i < commonsArrayList.size(); ++i) {
                ((ISchedulerPlugin)commonsArrayList.getAtIndex(i)).initialize((String)iCommonsList2.getAtIndex(i), (IScheduler)object, iClassLoadHelper);
            }
            for (Object object7 : nonBlockingProperties) {
                quartzScheduler.getListenerManager().addJobListener((IJobListener)object7, (IMatcher<JobKey>)EverythingMatcher.allJobs());
            }
            Iterator iterator = object52.iterator();
            while (iterator.hasNext()) {
                Object object7;
                object7 = (ITriggerListener)iterator.next();
                quartzScheduler.getListenerManager().addTriggerListener((ITriggerListener)object7, (IMatcher<TriggerKey>)EverythingMatcher.allTriggers());
            }
            for (Object object7 : nonBlockingProperties3.keySet()) {
                String string10 = nonBlockingProperties3.getProperty((String)object7);
                object.getContext().put(object7, string10);
            }
            iJobStore.setInstanceId(string5);
            iJobStore.setInstanceName(string3);
            iJobStore.setThreadPoolSize(iThreadPool.getPoolSize());
            iJobStore.initialize(iClassLoadHelper, quartzScheduler.getSchedulerSignaler());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Initializing JobRunShellFactory");
            }
            object3.initialize((IScheduler)object);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Initializing QuartzScheduler");
            }
            quartzScheduler.initialize();
            LOGGER.info("Quartz scheduler '" + object.getSchedulerName() + "' initialized from " + this.m_sPropSrc);
            LOGGER.info("Quartz scheduler version: " + quartzScheduler.getVersion());
            quartzScheduler.addNoGCObject(schedulerRepository);
            schedulerRepository.bind((IScheduler)object);
            return object;
        }
        catch (Exception exception) {
            StdSchedulerFactory._shutdownFromInstantiateException(iThreadPool, quartzScheduler, bl6, bl7);
            throw exception;
        }
    }

    private static void _shutdownFromInstantiateException(IThreadPool iThreadPool, QuartzScheduler quartzScheduler, boolean bl, boolean bl2) {
        try {
            if (bl2) {
                quartzScheduler.shutdown(false);
            } else if (bl) {
                iThreadPool.shutdown(false);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Got another exception while shutting down after instantiation exception", (Throwable)exception);
        }
    }

    @Nonnull
    protected IScheduler instantiate(QuartzSchedulerResources quartzSchedulerResources, QuartzScheduler quartzScheduler) {
        return new StdScheduler(quartzScheduler);
    }

    private void _setBeanProps(Object object, NonBlockingProperties nonBlockingProperties) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, IntrospectionException, SchedulerConfigException {
        nonBlockingProperties.remove((Object)"class");
        BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        PropertiesParser propertiesParser = new PropertiesParser(nonBlockingProperties);
        for (String string : nonBlockingProperties.keySet()) {
            String string2 = string.substring(0, 1).toUpperCase(Locale.US);
            String string3 = "set" + string2 + string.substring(1);
            Method method = StdSchedulerFactory._getSetMethod(string3, propertyDescriptorArray);
            try {
                if (method == null) {
                    throw new NoSuchMethodException("No setter for property '" + string + "'");
                }
                Class<?>[] classArray = method.getParameterTypes();
                if (classArray.length != 1) {
                    throw new NoSuchMethodException("No 1-argument setter for property '" + string + "'");
                }
                PropertiesParser propertiesParser2 = propertiesParser;
                String string4 = propertiesParser.getStringProperty(string);
                if (string4 != null && string4.startsWith("$@")) {
                    string4 = string4.substring(2);
                    propertiesParser2 = this.m_aCfg;
                } else {
                    string4 = string;
                }
                if (classArray[0].equals(Integer.TYPE)) {
                    method.invoke(object, propertiesParser2.getIntProperty(string4));
                    continue;
                }
                if (classArray[0].equals(Long.TYPE)) {
                    method.invoke(object, propertiesParser2.getLongProperty(string4));
                    continue;
                }
                if (classArray[0].equals(Float.TYPE)) {
                    method.invoke(object, Float.valueOf(propertiesParser2.getFloatProperty(string4)));
                    continue;
                }
                if (classArray[0].equals(Double.TYPE)) {
                    method.invoke(object, propertiesParser2.getDoubleProperty(string4));
                    continue;
                }
                if (classArray[0].equals(Boolean.TYPE)) {
                    method.invoke(object, propertiesParser2.getBooleanProperty(string4));
                    continue;
                }
                if (classArray[0].equals(String.class)) {
                    method.invoke(object, propertiesParser2.getStringProperty(string4));
                    continue;
                }
                throw new NoSuchMethodException("No primitive-type setter for property '" + string + "'");
            }
            catch (NumberFormatException numberFormatException) {
                throw new SchedulerConfigException("Could not parse property '" + string + "' into correct data type: " + numberFormatException.toString());
            }
        }
    }

    private static Method _getSetMethod(String string, PropertyDescriptor[] propertyDescriptorArray) {
        for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
            Method method = propertyDescriptor.getWriteMethod();
            if (method == null || !method.getName().equals(string)) continue;
            return method;
        }
        return null;
    }

    private Class<?> _loadClass(String string) throws ClassNotFoundException, SchedulerConfigException {
        try {
            ClassLoader classLoader = this._findClassloader();
            if (classLoader != null) {
                return classLoader.loadClass(string);
            }
            throw new SchedulerConfigException("Unable to find a class loader on the current thread or class.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.getClass().getClassLoader() != null) {
                return this.getClass().getClassLoader().loadClass(string);
            }
            throw classNotFoundException;
        }
    }

    private ClassLoader _findClassloader() {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
            thread.setContextClassLoader(classLoader);
        }
        return classLoader;
    }

    private String _getSchedulerName() {
        return this.m_aCfg.getStringProperty(PROP_SCHED_INSTANCE_NAME, "MiniQuartzScheduler");
    }

    @Override
    public IScheduler getScheduler() throws SchedulerException {
        SchedulerRepository schedulerRepository;
        IScheduler iScheduler;
        if (this.m_aCfg == null) {
            this.initialize();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Looking up scheduler with name '" + this._getSchedulerName() + "'");
        }
        if ((iScheduler = (schedulerRepository = SchedulerRepository.getInstance()).lookup(this._getSchedulerName())) != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Reusing existing scheduler with name '" + this._getSchedulerName() + "'");
            }
            if (iScheduler.isShutdown()) {
                schedulerRepository.remove(this._getSchedulerName());
            } else {
                return iScheduler;
            }
        }
        iScheduler = this._instantiate();
        return iScheduler;
    }

    public static IScheduler getDefaultScheduler() throws SchedulerException {
        StdSchedulerFactory stdSchedulerFactory = new StdSchedulerFactory();
        return stdSchedulerFactory.getScheduler();
    }

    @Override
    public IScheduler getScheduler(String string) throws SchedulerException {
        return SchedulerRepository.getInstance().lookup(string);
    }

    @Override
    public ICommonsCollection<IScheduler> getAllSchedulers() throws SchedulerException {
        return SchedulerRepository.getInstance().lookupAll();
    }
}

