/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.impl.calendar;

import com.helger.collection.commons.CommonsTreeSet;
import com.helger.collection.commons.ICommonsSortedSet;
import com.helger.quartz.ICalendar;
import com.helger.quartz.impl.calendar.AbstractCalendar;
import jakarta.annotation.Nonnull;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.SortedSet;
import java.util.TimeZone;

public class HolidayCalendar
extends AbstractCalendar<HolidayCalendar> {
    private final ICommonsSortedSet<Date> m_aDates = new CommonsTreeSet();

    public HolidayCalendar(@Nonnull HolidayCalendar holidayCalendar) {
        super(holidayCalendar);
        this.m_aDates.addAll(holidayCalendar.m_aDates);
    }

    public HolidayCalendar() {
        this(null, null);
    }

    public HolidayCalendar(ICalendar iCalendar) {
        this(iCalendar, null);
    }

    public HolidayCalendar(TimeZone timeZone) {
        this(null, timeZone);
    }

    public HolidayCalendar(ICalendar iCalendar, TimeZone timeZone) {
        super(iCalendar, timeZone);
    }

    @Override
    public boolean isTimeIncluded(long l) {
        if (!super.isTimeIncluded(l)) {
            return false;
        }
        Date date = this.getStartOfDayJavaCalendar(l).getTime();
        return !this.m_aDates.contains((Object)date);
    }

    @Override
    public long getNextIncludedTime(long l) {
        long l2 = l;
        long l3 = super.getNextIncludedTime(l2);
        if (l3 > 0L && l3 > l2) {
            l2 = l3;
        }
        Calendar calendar = this.getStartOfDayJavaCalendar(l2);
        while (!this.isTimeIncluded(calendar.getTime().getTime())) {
            calendar.add(5, 1);
        }
        return calendar.getTime().getTime();
    }

    public void addExcludedDate(Date date) {
        Date date2 = this.getStartOfDayJavaCalendar(date.getTime()).getTime();
        this.m_aDates.add((Object)date2);
    }

    public void removeExcludedDate(Date date) {
        Date date2 = this.getStartOfDayJavaCalendar(date.getTime()).getTime();
        this.m_aDates.remove((Object)date2);
    }

    public SortedSet<Date> getExcludedDates() {
        return Collections.unmodifiableSortedSet(this.m_aDates);
    }

    @Override
    @Nonnull
    public HolidayCalendar getClone() {
        return new HolidayCalendar(this);
    }
}

