/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.impl.triggers;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.datetime.helper.PDTFactory;
import com.helger.quartz.CQuartz;
import com.helger.quartz.CalendarIntervalScheduleBuilder;
import com.helger.quartz.EIntervalUnit;
import com.helger.quartz.ICalendar;
import com.helger.quartz.ICalendarIntervalTrigger;
import com.helger.quartz.ITrigger;
import com.helger.quartz.QCloneUtils;
import com.helger.quartz.SchedulerException;
import com.helger.quartz.impl.triggers.AbstractTrigger;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class CalendarIntervalTrigger
extends AbstractTrigger<CalendarIntervalTrigger>
implements ICalendarIntervalTrigger {
    private Date m_aStartTime;
    private Date m_aEndTime;
    private Date m_aNextFireTime;
    private Date m_aPreviousFireTime;
    private int m_nRepeatInterval = 0;
    private EIntervalUnit m_eRepeatIntervalUnit = EIntervalUnit.DAY;
    private TimeZone m_aTimeZone;
    private boolean m_bPreserveHourOfDayAcrossDaylightSavings = false;
    private boolean m_bSkipDayIfHourDoesNotExist = false;
    private int m_nTimesTriggered = 0;

    public CalendarIntervalTrigger(@Nonnull CalendarIntervalTrigger calendarIntervalTrigger) {
        super(calendarIntervalTrigger);
        this.m_aStartTime = QCloneUtils.getClone(calendarIntervalTrigger.m_aStartTime);
        this.m_aEndTime = QCloneUtils.getClone(calendarIntervalTrigger.m_aEndTime);
        this.m_aNextFireTime = QCloneUtils.getClone(calendarIntervalTrigger.m_aNextFireTime);
        this.m_aPreviousFireTime = QCloneUtils.getClone(calendarIntervalTrigger.m_aPreviousFireTime);
        this.m_nRepeatInterval = calendarIntervalTrigger.m_nRepeatInterval;
        this.m_eRepeatIntervalUnit = calendarIntervalTrigger.m_eRepeatIntervalUnit;
        this.m_aTimeZone = QCloneUtils.getClone(calendarIntervalTrigger.m_aTimeZone);
        this.m_bPreserveHourOfDayAcrossDaylightSavings = calendarIntervalTrigger.m_bPreserveHourOfDayAcrossDaylightSavings;
        this.m_bSkipDayIfHourDoesNotExist = calendarIntervalTrigger.m_bSkipDayIfHourDoesNotExist;
        this.m_nTimesTriggered = calendarIntervalTrigger.m_nTimesTriggered;
    }

    public CalendarIntervalTrigger() {
    }

    public CalendarIntervalTrigger(String string, EIntervalUnit eIntervalUnit, int n) {
        this(string, null, eIntervalUnit, n);
    }

    public CalendarIntervalTrigger(String string, String string2, EIntervalUnit eIntervalUnit, int n) {
        this(string, string2, new Date(), null, eIntervalUnit, n);
    }

    public CalendarIntervalTrigger(String string, Date date, Date date2, EIntervalUnit eIntervalUnit, int n) {
        this(string, null, date, date2, eIntervalUnit, n);
    }

    public CalendarIntervalTrigger(String string, String string2, Date date, Date date2, EIntervalUnit eIntervalUnit, int n) {
        super(string, string2);
        this.setStartTime(date);
        this.setEndTime(date2);
        this.setRepeatIntervalUnit(eIntervalUnit);
        this.setRepeatInterval(n);
    }

    public CalendarIntervalTrigger(String string, String string2, String string3, String string4, Date date, Date date2, EIntervalUnit eIntervalUnit, int n) {
        super(string, string2, string3, string4);
        this.setStartTime(date);
        this.setEndTime(date2);
        this.setRepeatIntervalUnit(eIntervalUnit);
        this.setRepeatInterval(n);
    }

    @Override
    public final Date getStartTime() {
        if (this.m_aStartTime == null) {
            this.m_aStartTime = new Date();
        }
        return this.m_aStartTime;
    }

    @Override
    public final void setStartTime(Date date) {
        ValueEnforcer.notNull((Object)date, (String)"StartTime");
        Date date2 = this.getEndTime();
        if (date2 != null && date2.before(date)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        this.m_aStartTime = date;
    }

    @Override
    @Nullable
    public final Date getEndTime() {
        return this.m_aEndTime;
    }

    @Override
    public final void setEndTime(@Nullable Date date) {
        Date date2 = this.getStartTime();
        if (date2 != null && date != null && date2.after(date)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        this.m_aEndTime = date;
    }

    @Override
    public EIntervalUnit getRepeatIntervalUnit() {
        return this.m_eRepeatIntervalUnit;
    }

    public void setRepeatIntervalUnit(EIntervalUnit eIntervalUnit) {
        this.m_eRepeatIntervalUnit = eIntervalUnit;
    }

    @Override
    public int getRepeatInterval() {
        return this.m_nRepeatInterval;
    }

    public void setRepeatInterval(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Repeat interval must be >= 0");
        }
        this.m_nRepeatInterval = n;
    }

    @Override
    public TimeZone getTimeZone() {
        if (this.m_aTimeZone == null) {
            this.m_aTimeZone = TimeZone.getDefault();
        }
        return this.m_aTimeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.m_aTimeZone = timeZone;
    }

    @Override
    public boolean isPreserveHourOfDayAcrossDaylightSavings() {
        return this.m_bPreserveHourOfDayAcrossDaylightSavings;
    }

    public void setPreserveHourOfDayAcrossDaylightSavings(boolean bl) {
        this.m_bPreserveHourOfDayAcrossDaylightSavings = bl;
    }

    @Override
    public boolean isSkipDayIfHourDoesNotExist() {
        return this.m_bSkipDayIfHourDoesNotExist;
    }

    public void setSkipDayIfHourDoesNotExist(boolean bl) {
        this.m_bSkipDayIfHourDoesNotExist = bl;
    }

    @Override
    public int getTimesTriggered() {
        return this.m_nTimesTriggered;
    }

    public void setTimesTriggered(int n) {
        this.m_nTimesTriggered = n;
    }

    @Override
    protected boolean validateMisfireInstruction(ITrigger.EMisfireInstruction eMisfireInstruction) {
        switch (eMisfireInstruction) {
            case MISFIRE_INSTRUCTION_IGNORE_MISFIRE_POLICY: 
            case MISFIRE_INSTRUCTION_SMART_POLICY: 
            case MISFIRE_INSTRUCTION_FIRE_ONCE_NOW: 
            case MISFIRE_INSTRUCTION_DO_NOTHING: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void updateAfterMisfire(ICalendar iCalendar) {
        ITrigger.EMisfireInstruction eMisfireInstruction = this.getMisfireInstruction();
        if (eMisfireInstruction == ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_SMART_POLICY) {
            eMisfireInstruction = ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_FIRE_ONCE_NOW;
        }
        switch (eMisfireInstruction) {
            case MISFIRE_INSTRUCTION_IGNORE_MISFIRE_POLICY: {
                return;
            }
            case MISFIRE_INSTRUCTION_FIRE_ONCE_NOW: {
                this.setNextFireTime(new Date());
                break;
            }
            case MISFIRE_INSTRUCTION_DO_NOTHING: {
                Date date = this.getFireTimeAfter(new Date());
                while (date != null && iCalendar != null && !iCalendar.isTimeIncluded(date.getTime())) {
                    date = this.getFireTimeAfter(date);
                }
                this.setNextFireTime(date);
                break;
            }
        }
    }

    @Override
    public void triggered(ICalendar iCalendar) {
        ++this.m_nTimesTriggered;
        this.m_aPreviousFireTime = this.m_aNextFireTime;
        this.m_aNextFireTime = this.getFireTimeAfter(this.m_aNextFireTime);
        while (this.m_aNextFireTime != null && iCalendar != null && !iCalendar.isTimeIncluded(this.m_aNextFireTime.getTime())) {
            this.m_aNextFireTime = this.getFireTimeAfter(this.m_aNextFireTime);
            if (this.m_aNextFireTime == null) break;
            Calendar calendar = PDTFactory.createCalendar();
            calendar.setTime(this.m_aNextFireTime);
            if (calendar.get(1) <= CQuartz.MAX_YEAR) continue;
            this.m_aNextFireTime = null;
        }
    }

    @Override
    public void updateWithNewCalendar(ICalendar iCalendar, long l) {
        this.m_aNextFireTime = this.getFireTimeAfter(this.m_aPreviousFireTime);
        if (this.m_aNextFireTime == null || iCalendar == null) {
            return;
        }
        Date date = new Date();
        while (this.m_aNextFireTime != null && !iCalendar.isTimeIncluded(this.m_aNextFireTime.getTime())) {
            long l2;
            this.m_aNextFireTime = this.getFireTimeAfter(this.m_aNextFireTime);
            if (this.m_aNextFireTime == null) break;
            Calendar calendar = PDTFactory.createCalendar();
            calendar.setTime(this.m_aNextFireTime);
            if (calendar.get(1) > CQuartz.MAX_YEAR) {
                this.m_aNextFireTime = null;
            }
            if (this.m_aNextFireTime == null || !this.m_aNextFireTime.before(date) || (l2 = date.getTime() - this.m_aNextFireTime.getTime()) < l) continue;
            this.m_aNextFireTime = this.getFireTimeAfter(this.m_aNextFireTime);
        }
    }

    @Override
    public Date computeFirstFireTime(ICalendar iCalendar) {
        this.m_aNextFireTime = this.getStartTime();
        while (this.m_aNextFireTime != null && iCalendar != null && !iCalendar.isTimeIncluded(this.m_aNextFireTime.getTime())) {
            this.m_aNextFireTime = this.getFireTimeAfter(this.m_aNextFireTime);
            if (this.m_aNextFireTime == null) break;
            Calendar calendar = PDTFactory.createCalendar();
            calendar.setTime(this.m_aNextFireTime);
            if (calendar.get(1) <= CQuartz.MAX_YEAR) continue;
            return null;
        }
        return this.m_aNextFireTime;
    }

    @Override
    public Date getNextFireTime() {
        return this.m_aNextFireTime;
    }

    @Override
    public Date getPreviousFireTime() {
        return this.m_aPreviousFireTime;
    }

    @Override
    public void setNextFireTime(Date date) {
        this.m_aNextFireTime = date;
    }

    @Override
    public void setPreviousFireTime(Date date) {
        this.m_aPreviousFireTime = date;
    }

    @Override
    public Date getFireTimeAfter(Date date) {
        return this.getFireTimeAfter(date, false);
    }

    protected Date getFireTimeAfter(Date date, boolean bl) {
        long l;
        Date date2 = date;
        if (date2 == null) {
            date2 = new Date();
        }
        long l2 = this.getStartTime().getTime();
        long l3 = date2.getTime();
        long l4 = l = this.getEndTime() == null ? Long.MAX_VALUE : this.getEndTime().getTime();
        if (!bl && l <= l3) {
            return null;
        }
        if (l3 < l2) {
            return new Date(l2);
        }
        long l5 = 1L + (l3 - l2) / 1000L;
        Date date3 = null;
        long l6 = this.getRepeatInterval();
        Calendar calendar = PDTFactory.createCalendar();
        calendar.setTime(date2);
        Calendar calendar2 = PDTFactory.createCalendar();
        if (this.m_aTimeZone != null) {
            calendar2.setTimeZone(this.m_aTimeZone);
        }
        calendar2.setTime(this.getStartTime());
        calendar2.setLenient(true);
        if (this.getRepeatIntervalUnit().equals((Object)EIntervalUnit.SECOND)) {
            long l7 = l5 / l6;
            if (l5 % l6 != 0L) {
                ++l7;
            }
            calendar2.add(13, this.getRepeatInterval() * (int)l7);
            date3 = calendar2.getTime();
        } else if (this.getRepeatIntervalUnit().equals((Object)EIntervalUnit.MINUTE)) {
            long l8 = l5 / (l6 * 60L);
            if (l5 % (l6 * 60L) != 0L) {
                ++l8;
            }
            calendar2.add(12, this.getRepeatInterval() * (int)l8);
            date3 = calendar2.getTime();
        } else if (this.getRepeatIntervalUnit().equals((Object)EIntervalUnit.HOUR)) {
            long l9 = l5 / (l6 * 60L * 60L);
            if (l5 % (l6 * 60L * 60L) != 0L) {
                ++l9;
            }
            calendar2.add(11, this.getRepeatInterval() * (int)l9);
            date3 = calendar2.getTime();
        } else {
            int n = calendar2.get(11);
            if (this.getRepeatIntervalUnit().equals((Object)EIntervalUnit.DAY)) {
                calendar2.setLenient(true);
                long l10 = l5 / (l6 * 24L * 60L * 60L);
                if (l10 > 20L) {
                    l10 = l10 < 50L ? (long)((double)l10 * 0.8) : (l10 < 500L ? (long)((double)l10 * 0.9) : (long)((double)l10 * 0.95));
                    calendar2.add(6, (int)((long)this.getRepeatInterval() * l10));
                }
                while (!calendar2.getTime().after(date2) && calendar2.get(1) < CQuartz.MAX_YEAR) {
                    calendar2.add(6, this.getRepeatInterval());
                }
                while (this.daylightSavingHourShiftOccurredAndAdvanceNeeded(calendar2, n, date2) && calendar2.get(1) < CQuartz.MAX_YEAR) {
                    calendar2.add(6, this.getRepeatInterval());
                }
                date3 = calendar2.getTime();
            } else if (this.getRepeatIntervalUnit().equals((Object)EIntervalUnit.WEEK)) {
                calendar2.setLenient(true);
                long l11 = l5 / (l6 * 7L * 24L * 60L * 60L);
                if (l11 > 20L) {
                    l11 = l11 < 50L ? (long)((double)l11 * 0.8) : (l11 < 500L ? (long)((double)l11 * 0.9) : (long)((double)l11 * 0.95));
                    calendar2.add(3, (int)((long)this.getRepeatInterval() * l11));
                }
                while (!calendar2.getTime().after(date2) && calendar2.get(1) < CQuartz.MAX_YEAR) {
                    calendar2.add(3, this.getRepeatInterval());
                }
                while (this.daylightSavingHourShiftOccurredAndAdvanceNeeded(calendar2, n, date2) && calendar2.get(1) < CQuartz.MAX_YEAR) {
                    calendar2.add(3, this.getRepeatInterval());
                }
                date3 = calendar2.getTime();
            } else if (this.getRepeatIntervalUnit().equals((Object)EIntervalUnit.MONTH)) {
                calendar2.setLenient(true);
                while (!calendar2.getTime().after(date2) && calendar2.get(1) < CQuartz.MAX_YEAR) {
                    calendar2.add(2, this.getRepeatInterval());
                }
                while (this.daylightSavingHourShiftOccurredAndAdvanceNeeded(calendar2, n, date2) && calendar2.get(1) < CQuartz.MAX_YEAR) {
                    calendar2.add(2, this.getRepeatInterval());
                }
                date3 = calendar2.getTime();
            } else if (this.getRepeatIntervalUnit().equals((Object)EIntervalUnit.YEAR)) {
                while (!calendar2.getTime().after(date2) && calendar2.get(1) < CQuartz.MAX_YEAR) {
                    calendar2.add(1, this.getRepeatInterval());
                }
                while (this.daylightSavingHourShiftOccurredAndAdvanceNeeded(calendar2, n, date2) && calendar2.get(1) < CQuartz.MAX_YEAR) {
                    calendar2.add(1, this.getRepeatInterval());
                }
                date3 = calendar2.getTime();
            }
        }
        if (!bl && l <= date3.getTime()) {
            return null;
        }
        return date3;
    }

    private boolean daylightSavingHourShiftOccurredAndAdvanceNeeded(Calendar calendar, int n, Date date) {
        if (this.isPreserveHourOfDayAcrossDaylightSavings() && calendar.get(11) != n) {
            calendar.set(11, n);
            if (calendar.get(11) != n) {
                return this.isSkipDayIfHourDoesNotExist();
            }
            return !calendar.getTime().after(date);
        }
        return false;
    }

    @Override
    public Date getFinalFireTime() {
        if (this.getEndTime() == null) {
            return null;
        }
        Date date = new Date(this.getEndTime().getTime() - 1000L);
        if ((date = this.getFireTimeAfter(date, true)).equals(this.getEndTime())) {
            return date;
        }
        Calendar calendar = PDTFactory.createCalendar();
        if (this.m_aTimeZone != null) {
            calendar.setTimeZone(this.m_aTimeZone);
        }
        calendar.setTime(date);
        calendar.setLenient(true);
        if (this.getRepeatIntervalUnit().equals((Object)EIntervalUnit.SECOND)) {
            calendar.add(13, -1 * this.getRepeatInterval());
        } else if (this.getRepeatIntervalUnit().equals((Object)EIntervalUnit.MINUTE)) {
            calendar.add(12, -1 * this.getRepeatInterval());
        } else if (this.getRepeatIntervalUnit().equals((Object)EIntervalUnit.HOUR)) {
            calendar.add(11, -1 * this.getRepeatInterval());
        } else if (this.getRepeatIntervalUnit().equals((Object)EIntervalUnit.DAY)) {
            calendar.add(6, -1 * this.getRepeatInterval());
        } else if (this.getRepeatIntervalUnit().equals((Object)EIntervalUnit.WEEK)) {
            calendar.add(3, -1 * this.getRepeatInterval());
        } else if (this.getRepeatIntervalUnit().equals((Object)EIntervalUnit.MONTH)) {
            calendar.add(2, -1 * this.getRepeatInterval());
        } else if (this.getRepeatIntervalUnit().equals((Object)EIntervalUnit.YEAR)) {
            calendar.add(1, -1 * this.getRepeatInterval());
        }
        return calendar.getTime();
    }

    @Override
    public boolean mayFireAgain() {
        return this.getNextFireTime() != null;
    }

    @Override
    public void validate() throws SchedulerException {
        super.validate();
        if (this.m_nRepeatInterval < 1) {
            throw new SchedulerException("Repeat Interval cannot be zero.");
        }
    }

    public CalendarIntervalScheduleBuilder getScheduleBuilder() {
        CalendarIntervalScheduleBuilder calendarIntervalScheduleBuilder = CalendarIntervalScheduleBuilder.calendarIntervalSchedule().withInterval(this.getRepeatInterval(), this.getRepeatIntervalUnit());
        switch (this.getMisfireInstruction()) {
            case MISFIRE_INSTRUCTION_DO_NOTHING: {
                calendarIntervalScheduleBuilder.withMisfireHandlingInstructionDoNothing();
                break;
            }
            case MISFIRE_INSTRUCTION_FIRE_ONCE_NOW: {
                calendarIntervalScheduleBuilder.withMisfireHandlingInstructionFireAndProceed();
            }
        }
        return calendarIntervalScheduleBuilder;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public CalendarIntervalTrigger getClone() {
        return new CalendarIntervalTrigger(this);
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

