/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.listeners;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsLinkedList;
import com.helger.collection.commons.ICommonsList;
import com.helger.quartz.IJobDetail;
import com.helger.quartz.ISchedulerListener;
import com.helger.quartz.ITrigger;
import com.helger.quartz.JobKey;
import com.helger.quartz.SchedulerException;
import com.helger.quartz.TriggerKey;
import jakarta.annotation.Nonnull;

public class BroadcastSchedulerListener
implements ISchedulerListener {
    private final ICommonsList<ISchedulerListener> m_aListeners = new CommonsLinkedList();

    public BroadcastSchedulerListener() {
    }

    public BroadcastSchedulerListener(Iterable<? extends ISchedulerListener> iterable) {
        this.m_aListeners.addAll(iterable);
    }

    public void addListener(@Nonnull ISchedulerListener iSchedulerListener) {
        ValueEnforcer.notNull((Object)iSchedulerListener, (String)"Listener");
        this.m_aListeners.add((Object)iSchedulerListener);
    }

    public boolean removeListener(ISchedulerListener iSchedulerListener) {
        return this.m_aListeners.remove((Object)iSchedulerListener);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ISchedulerListener> getListeners() {
        return (ICommonsList)this.m_aListeners.getClone();
    }

    @Override
    public void jobAdded(IJobDetail iJobDetail) {
        this.m_aListeners.forEach(iSchedulerListener -> iSchedulerListener.jobAdded(iJobDetail));
    }

    @Override
    public void jobDeleted(JobKey jobKey) {
        this.m_aListeners.forEach(iSchedulerListener -> iSchedulerListener.jobDeleted(jobKey));
    }

    @Override
    public void jobScheduled(ITrigger iTrigger) {
        this.m_aListeners.forEach(iSchedulerListener -> iSchedulerListener.jobScheduled(iTrigger));
    }

    @Override
    public void jobUnscheduled(TriggerKey triggerKey) {
        this.m_aListeners.forEach(iSchedulerListener -> iSchedulerListener.jobUnscheduled(triggerKey));
    }

    @Override
    public void triggerFinalized(ITrigger iTrigger) {
        this.m_aListeners.forEach(iSchedulerListener -> iSchedulerListener.triggerFinalized(iTrigger));
    }

    @Override
    public void triggerPaused(TriggerKey triggerKey) {
        this.m_aListeners.forEach(iSchedulerListener -> iSchedulerListener.triggerPaused(triggerKey));
    }

    @Override
    public void triggersPaused(String string) {
        this.m_aListeners.forEach(iSchedulerListener -> iSchedulerListener.triggersPaused(string));
    }

    @Override
    public void triggerResumed(TriggerKey triggerKey) {
        this.m_aListeners.forEach(iSchedulerListener -> iSchedulerListener.triggerResumed(triggerKey));
    }

    @Override
    public void triggersResumed(String string) {
        this.m_aListeners.forEach(iSchedulerListener -> iSchedulerListener.triggersResumed(string));
    }

    @Override
    public void schedulingDataCleared() {
        this.m_aListeners.forEach(ISchedulerListener::schedulingDataCleared);
    }

    @Override
    public void jobPaused(JobKey jobKey) {
        this.m_aListeners.forEach(iSchedulerListener -> iSchedulerListener.jobPaused(jobKey));
    }

    @Override
    public void jobsPaused(String string) {
        this.m_aListeners.forEach(iSchedulerListener -> iSchedulerListener.jobsPaused(string));
    }

    @Override
    public void jobResumed(JobKey jobKey) {
        this.m_aListeners.forEach(iSchedulerListener -> iSchedulerListener.jobResumed(jobKey));
    }

    @Override
    public void jobsResumed(String string) {
        this.m_aListeners.forEach(iSchedulerListener -> iSchedulerListener.jobsResumed(string));
    }

    @Override
    public void schedulerError(String string, SchedulerException schedulerException) {
        this.m_aListeners.forEach(iSchedulerListener -> iSchedulerListener.schedulerError(string, schedulerException));
    }

    @Override
    public void schedulerStarted() {
        this.m_aListeners.forEach(ISchedulerListener::schedulerStarted);
    }

    @Override
    public void schedulerStarting() {
        this.m_aListeners.forEach(ISchedulerListener::schedulerStarting);
    }

    @Override
    public void schedulerInStandbyMode() {
        this.m_aListeners.forEach(ISchedulerListener::schedulerInStandbyMode);
    }

    @Override
    public void schedulerShutdown() {
        this.m_aListeners.forEach(ISchedulerListener::schedulerShutdown);
    }

    @Override
    public void schedulerShuttingdown() {
        this.m_aListeners.forEach(ISchedulerListener::schedulerShuttingdown);
    }
}

