/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.simpl;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.quartz.JobKey;
import com.helger.quartz.TriggerKey;
import com.helger.quartz.spi.IOperableTrigger;
import jakarta.annotation.Nonnull;

final class TriggerWrapper {
    public static final int STATE_WAITING = 0;
    public static final int STATE_ACQUIRED = 1;
    public static final int STATE_EXECUTING = 2;
    public static final int STATE_COMPLETE = 3;
    public static final int STATE_PAUSED = 4;
    public static final int STATE_BLOCKED = 5;
    public static final int STATE_PAUSED_BLOCKED = 6;
    public static final int STATE_ERROR = 7;
    final TriggerKey m_aKey;
    final JobKey m_aJobKey;
    final IOperableTrigger m_aTrigger;
    int m_nState = 0;

    TriggerWrapper(@Nonnull IOperableTrigger iOperableTrigger) {
        ValueEnforcer.notNull((Object)iOperableTrigger, (String)"Trigger");
        this.m_aTrigger = iOperableTrigger;
        this.m_aKey = iOperableTrigger.getKey();
        this.m_aJobKey = iOperableTrigger.getJobKey();
    }

    public IOperableTrigger getTrigger() {
        return this.m_aTrigger;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        TriggerWrapper triggerWrapper = (TriggerWrapper)object;
        return this.m_aKey.equals(triggerWrapper.m_aKey);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aKey).getHashCode();
    }
}

