/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.utils.counter.sampled;

import com.helger.quartz.utils.CircularLossyQueue;
import com.helger.quartz.utils.counter.Counter;
import com.helger.quartz.utils.counter.sampled.ISampledCounter;
import com.helger.quartz.utils.counter.sampled.SampledCounterConfig;
import com.helger.quartz.utils.counter.sampled.TimeStampedCounterValue;
import jakarta.annotation.Nonnull;
import java.util.TimerTask;

public class SampledCounter
extends Counter
implements ISampledCounter {
    private static final int MILLIS_PER_SEC = 1000;
    protected final CircularLossyQueue<TimeStampedCounterValue> m_aHistory;
    protected final boolean m_bResetOnSample;
    private final TimerTask m_aSamplerTask;
    private final long m_nIntervalMillis;

    public SampledCounter(@Nonnull SampledCounterConfig sampledCounterConfig) {
        super(sampledCounterConfig.getInitialValue());
        this.m_nIntervalMillis = (long)sampledCounterConfig.getIntervalSecs() * 1000L;
        this.m_aHistory = new CircularLossyQueue(sampledCounterConfig.getHistorySize());
        this.m_bResetOnSample = sampledCounterConfig.isResetOnSample();
        this.m_aSamplerTask = new TimerTask(){

            @Override
            public void run() {
                SampledCounter.this.recordSample();
            }
        };
        this.recordSample();
    }

    @Override
    public TimeStampedCounterValue getMostRecentSample() {
        return this.m_aHistory.peek();
    }

    @Override
    public TimeStampedCounterValue[] getAllSampleValues() {
        return this.m_aHistory.toArray((TimeStampedCounterValue[])new TimeStampedCounterValue[this.m_aHistory.depth()]);
    }

    @Override
    public void shutdown() {
        if (this.m_aSamplerTask != null) {
            this.m_aSamplerTask.cancel();
        }
    }

    public TimerTask getTimerTask() {
        return this.m_aSamplerTask;
    }

    public long getIntervalMillis() {
        return this.m_nIntervalMillis;
    }

    void recordSample() {
        long l = this.m_bResetOnSample ? this.getAndReset() : this.getValue();
        long l2 = System.currentTimeMillis();
        TimeStampedCounterValue timeStampedCounterValue = new TimeStampedCounterValue(l2, l);
        this.m_aHistory.push(timeStampedCounterValue);
    }

    @Override
    public long getAndReset() {
        return this.getAndSet(0L);
    }
}

