/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.schxslt.xslt2;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.timing.StopWatch;
import com.helger.io.file.FilenameHelper;
import com.helger.io.file.SimpleFileIO;
import com.helger.io.resource.ClassPathResource;
import com.helger.io.resource.IReadableResource;
import com.helger.schematron.SchematronDebug;
import com.helger.schematron.SchematronInterruptedException;
import com.helger.schematron.api.xslt.ISchematronXSLTBasedProvider;
import com.helger.schematron.saxon.SchematronTransformerFactory;
import com.helger.schematron.schxslt.xslt2.EStepSchXslt_XSLT2;
import com.helger.schematron.schxslt.xslt2.TransformerCustomizerSchXslt_XSLT2;
import com.helger.xml.XMLFactory;
import com.helger.xml.serialize.write.XMLWriter;
import com.helger.xml.serialize.write.XMLWriterSettings;
import com.helger.xml.transform.TransformSourceFactory;
import com.helger.xml.transform.XMLTransformerFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.nio.charset.Charset;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@NotThreadSafe
public class SchematronProviderXSLTFromSchXslt_XSLT2
implements ISchematronXSLTBasedProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchematronProviderXSLTFromSchXslt_XSLT2.class);
    public static final String SCHEMATRON_DIRECTORY_XSLT2 = "/xslt/2.0/";
    public static final String XSLT2_STEP1 = "/xslt/2.0/include.xsl";
    public static final String XSLT2_STEP2 = "/xslt/2.0/expand.xsl";
    public static final String XSLT2_STEP3 = "/xslt/2.0/compile-for-svrl.xsl";
    private static Templates s_aStep1;
    private static Templates s_aStep2;
    private static Templates s_aStep3;
    private final IReadableResource m_aSchematronResource;
    private final TransformerCustomizerSchXslt_XSLT2 m_aTransformerCustomizer;
    private Document m_aSchematronXSLTDoc;
    private Templates m_aSchematronXSLTTemplates;

    public static void cacheXSLTTemplates() {
        TransformerFactory transformerFactory = SchematronTransformerFactory.getDefaultSaxonFirst();
        ClassLoader classLoader = SchematronProviderXSLTFromSchXslt_XSLT2.class.getClassLoader();
        if (s_aStep1 == null) {
            SchematronDebug.getDebugLogger().info("Creating SchXslt step 1 template");
            s_aStep1 = XMLTransformerFactory.newTemplates((TransformerFactory)transformerFactory, (IReadableResource)new ClassPathResource(XSLT2_STEP1, classLoader));
            if (s_aStep1 == null) {
                throw new IllegalStateException("Failed to compile '/xslt/2.0/include.xsl'");
            }
            SchematronDebug.getDebugLogger().info("Finished creating XSLT step 1 template");
            if (Thread.interrupted()) {
                throw new SchematronInterruptedException("after cached XSLT step 1");
            }
        }
        if (s_aStep2 == null) {
            SchematronDebug.getDebugLogger().info("Creating SchXslt step 2 template");
            s_aStep2 = XMLTransformerFactory.newTemplates((TransformerFactory)transformerFactory, (IReadableResource)new ClassPathResource(XSLT2_STEP2, classLoader));
            if (s_aStep2 == null) {
                throw new IllegalStateException("Failed to compile '/xslt/2.0/expand.xsl'");
            }
            SchematronDebug.getDebugLogger().info("Finished creating XSLT step 2 template");
            if (Thread.interrupted()) {
                throw new SchematronInterruptedException("after cached XSLT step 2");
            }
        }
        if (s_aStep3 == null) {
            SchematronDebug.getDebugLogger().info("Creating SchXslt step 3 template");
            s_aStep3 = XMLTransformerFactory.newTemplates((TransformerFactory)transformerFactory, (IReadableResource)new ClassPathResource(XSLT2_STEP3, classLoader));
            if (s_aStep3 == null) {
                throw new IllegalStateException("Failed to compile '/xslt/2.0/compile-for-svrl.xsl'");
            }
            SchematronDebug.getDebugLogger().info("Finished creating XSLT step 3 template");
            if (Thread.interrupted()) {
                throw new SchematronInterruptedException("after cached XSLT step 3");
            }
        }
    }

    @Nonnull
    public static Document createSchematronXSLT(@Nonnull IReadableResource iReadableResource, @Nonnull TransformerCustomizerSchXslt_XSLT2 transformerCustomizerSchXslt_XSLT2) throws TransformerException {
        Object object;
        Object object2;
        if (Thread.interrupted()) {
            throw new SchematronInterruptedException("before XSLT starts");
        }
        SchematronProviderXSLTFromSchXslt_XSLT2.cacheXSLTTemplates();
        Document document = XMLFactory.newDocument();
        Object object3 = StopWatch.createdStarted();
        Object object4 = new DOMResult(document);
        Object object5 = s_aStep1.newTransformer();
        transformerCustomizerSchXslt_XSLT2.customize(EStepSchXslt_XSLT2.SCH2XSLT_1, (Transformer)object5);
        StreamSource streamSource = TransformSourceFactory.create((IReadableResource)iReadableResource);
        SchematronDebug.getDebugLogger().info(() -> "Now applying XSLT step 1 on " + String.valueOf(iReadableResource));
        ((Transformer)object5).transform(streamSource, (Result)object4);
        object3.stop();
        SchematronDebug.getDebugLogger().info(() -> SchematronProviderXSLTFromSchXslt_XSLT2.lambda$createSchematronXSLT$1(iReadableResource, (StopWatch)object3));
        if (Thread.interrupted()) {
            throw new SchematronInterruptedException("after XSLT step 1");
        }
        object3 = XMLFactory.newDocument();
        object4 = StopWatch.createdStarted();
        object5 = new DOMResult((Node)object3);
        Object object6 = s_aStep2.newTransformer();
        transformerCustomizerSchXslt_XSLT2.customize(EStepSchXslt_XSLT2.SCH2XSLT_2, (Transformer)object6);
        Object object7 = TransformSourceFactory.create((Node)document);
        if (((DOMSource)object7).getSystemId() == null) {
            ((DOMSource)object7).setSystemId(streamSource.getSystemId());
        }
        SchematronDebug.getDebugLogger().info(() -> "Now applying XSLT step 2 on " + String.valueOf(iReadableResource));
        ((Transformer)object6).transform((Source)object7, (Result)object5);
        object4.stop();
        SchematronDebug.getDebugLogger().info(() -> SchematronProviderXSLTFromSchXslt_XSLT2.lambda$createSchematronXSLT$3(iReadableResource, (StopWatch)object4));
        if (SchematronDebug.isSaveIntermediateXSLTFiles()) {
            object2 = XMLWriter.getNodeAsString((Node)object3);
            object = new File(SchematronDebug.getIntermediateMinifiedSCHFolder(), FilenameHelper.getWithoutPath((String)iReadableResource.getPath()) + ".min-xslt.sch");
            SchematronDebug.getDebugLogger().info(() -> SchematronProviderXSLTFromSchXslt_XSLT2.lambda$createSchematronXSLT$4((File)object));
            if (SimpleFileIO.writeFile((File)object, (String)object2, (Charset)XMLWriterSettings.DEFAULT_XML_CHARSET_OBJ).isSuccess()) {
                LOGGER.info("Successfully wrote intermediate XSLT file '" + ((File)object).getAbsolutePath() + "'");
            } else {
                LOGGER.error("Failed to wrote intermediate XSLT file '" + ((File)object).getAbsolutePath() + "'");
            }
        }
        if (Thread.interrupted()) {
            throw new SchematronInterruptedException("after XSLT step 2");
        }
        object4 = XMLFactory.newDocument();
        object5 = StopWatch.createdStarted();
        object6 = new DOMResult((Node)object4);
        object7 = s_aStep3.newTransformer();
        transformerCustomizerSchXslt_XSLT2.customize(EStepSchXslt_XSLT2.SCH2XSLT_3, (Transformer)object7);
        object2 = TransformSourceFactory.create((Node)object3);
        if (((DOMSource)object2).getSystemId() == null) {
            ((DOMSource)object2).setSystemId(streamSource.getSystemId());
        }
        SchematronDebug.getDebugLogger().info(() -> "Now applying XSLT step 3 on " + String.valueOf(iReadableResource));
        ((Transformer)object7).transform((Source)object2, (Result)object6);
        object5.stop();
        SchematronDebug.getDebugLogger().info(() -> SchematronProviderXSLTFromSchXslt_XSLT2.lambda$createSchematronXSLT$6(iReadableResource, (StopWatch)object5));
        if (SchematronDebug.isSaveIntermediateXSLTFiles()) {
            object = XMLWriter.getNodeAsString((Node)object4);
            File file = new File(SchematronDebug.getIntermediateFinalXSLTFolder(), FilenameHelper.getWithoutPath((String)iReadableResource.getPath()) + ".xslt");
            SchematronDebug.getDebugLogger().info(() -> "Storing intermediate XSLT file to '" + file.getAbsolutePath() + "'");
            if (SimpleFileIO.writeFile((File)file, (String)object, (Charset)XMLWriterSettings.DEFAULT_XML_CHARSET_OBJ).isSuccess()) {
                LOGGER.info("Successfully wrote intermediate XSLT file '" + file.getAbsolutePath() + "'");
            } else {
                LOGGER.error("Failed to wrote intermediate XSLT file '" + file.getAbsolutePath() + "'");
            }
        }
        if (Thread.interrupted()) {
            throw new SchematronInterruptedException("after XSLT step 3");
        }
        return object4;
    }

    public SchematronProviderXSLTFromSchXslt_XSLT2(@Nonnull IReadableResource iReadableResource, @Nonnull TransformerCustomizerSchXslt_XSLT2 transformerCustomizerSchXslt_XSLT2) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"SchematronResource");
        ValueEnforcer.notNull((Object)transformerCustomizerSchXslt_XSLT2, (String)"TransformerCustomizer");
        this.m_aSchematronResource = iReadableResource;
        this.m_aTransformerCustomizer = transformerCustomizerSchXslt_XSLT2;
    }

    public void convertSchematronToXSLT() {
        if (this.m_aSchematronXSLTDoc != null) {
            throw new IllegalStateException("The conversion from Schematron to XSLT already happened");
        }
        try {
            this.m_aSchematronXSLTDoc = SchematronProviderXSLTFromSchXslt_XSLT2.createSchematronXSLT(this.m_aSchematronResource, this.m_aTransformerCustomizer);
            TransformerFactory transformerFactory = SchematronTransformerFactory.getDefaultSaxonFirst();
            this.m_aTransformerCustomizer.customize(transformerFactory);
            this.m_aSchematronXSLTTemplates = XMLTransformerFactory.newTemplates((TransformerFactory)transformerFactory, (Source)TransformSourceFactory.create((Node)this.m_aSchematronXSLTDoc));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Finished creating XSLT Template on " + String.valueOf(this.m_aSchematronResource));
            }
        }
        catch (SchematronInterruptedException schematronInterruptedException) {
            throw schematronInterruptedException;
        }
        catch (Exception exception) {
            LOGGER.error("SchXslt preprocessor error", (Throwable)exception);
        }
        if (Thread.interrupted()) {
            throw new SchematronInterruptedException("after XSLT template was created");
        }
    }

    @Nonnull
    public IReadableResource getSchematronResource() {
        return this.m_aSchematronResource;
    }

    public boolean isValidSchematron() {
        return this.m_aSchematronXSLTTemplates != null;
    }

    @Nullable
    public Document getXSLTDocument() {
        return this.m_aSchematronXSLTDoc;
    }

    @Nullable
    public Transformer getXSLTTransformer() throws TransformerConfigurationException {
        return this.m_aSchematronXSLTTemplates == null ? null : this.m_aSchematronXSLTTemplates.newTransformer();
    }

    private static /* synthetic */ String lambda$createSchematronXSLT$6(IReadableResource iReadableResource, StopWatch stopWatch) {
        return "Finished applying SchXslt step 3 on " + String.valueOf(iReadableResource) + " after " + stopWatch.getMillis() + "ms";
    }

    private static /* synthetic */ String lambda$createSchematronXSLT$4(File file) {
        return "Storing intermediate XSLT file to '" + file.getAbsolutePath() + "'";
    }

    private static /* synthetic */ String lambda$createSchematronXSLT$3(IReadableResource iReadableResource, StopWatch stopWatch) {
        return "Finished applying SchXslt step 2 on " + String.valueOf(iReadableResource) + " after " + stopWatch.getMillis() + "ms";
    }

    private static /* synthetic */ String lambda$createSchematronXSLT$1(IReadableResource iReadableResource, StopWatch stopWatch) {
        return "Finished applying SchXslt step 1 on " + String.valueOf(iReadableResource) + " after " + stopWatch.getMillis() + "ms";
    }
}

