/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.sch;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.timing.StopWatch;
import com.helger.io.file.FilenameHelper;
import com.helger.io.file.SimpleFileIO;
import com.helger.io.resource.ClassPathResource;
import com.helger.io.resource.IReadableResource;
import com.helger.schematron.SchematronDebug;
import com.helger.schematron.SchematronInterruptedException;
import com.helger.schematron.api.xslt.ISchematronXSLTBasedProvider;
import com.helger.schematron.saxon.SchematronTransformerFactory;
import com.helger.schematron.sch.EStepSCH;
import com.helger.schematron.sch.TransformerCustomizerSCH;
import com.helger.xml.XMLFactory;
import com.helger.xml.serialize.write.XMLWriter;
import com.helger.xml.serialize.write.XMLWriterSettings;
import com.helger.xml.transform.TransformSourceFactory;
import com.helger.xml.transform.XMLTransformerFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.nio.charset.Charset;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@NotThreadSafe
public class SchematronProviderXSLTFromSCH
implements ISchematronXSLTBasedProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchematronProviderXSLTFromSCH.class);
    public static final String SCHEMATRON_DIRECTORY_XSLT2 = "external/schematron/20100710-xslt2/";
    public static final String XSLT2_STEP1 = "external/schematron/20100710-xslt2/iso_dsdl_include.xsl";
    public static final String XSLT2_STEP2 = "external/schematron/20100710-xslt2/iso_abstract_expand.xsl";
    public static final String XSLT2_STEP3 = "external/schematron/20100710-xslt2/iso_svrl_for_xslt2.xsl";
    private static Templates s_aStep1;
    private static Templates s_aStep2;
    private static Templates s_aStep3;
    private final IReadableResource m_aSchematronResource;
    private final TransformerCustomizerSCH m_aTransformerCustomizer;
    private Document m_aSchematronXSLTDoc;
    private Templates m_aSchematronXSLTTemplates;

    public static void cacheXSLTTemplates() {
        TransformerFactory transformerFactory = SchematronTransformerFactory.getDefaultSaxonFirst();
        ClassLoader classLoader = SchematronProviderXSLTFromSCH.class.getClassLoader();
        if (s_aStep1 == null) {
            SchematronDebug.getDebugLogger().info("Creating XSLT step 1 template");
            s_aStep1 = XMLTransformerFactory.newTemplates((TransformerFactory)transformerFactory, (IReadableResource)new ClassPathResource(XSLT2_STEP1, classLoader));
            if (s_aStep1 == null) {
                throw new IllegalStateException("Failed to compile 'external/schematron/20100710-xslt2/iso_dsdl_include.xsl'");
            }
            SchematronDebug.getDebugLogger().info("Finished creating XSLT step 1 template");
            if (Thread.interrupted()) {
                throw new SchematronInterruptedException("after cached XSLT step 1");
            }
        }
        if (s_aStep2 == null) {
            SchematronDebug.getDebugLogger().info("Creating XSLT step 2 template");
            s_aStep2 = XMLTransformerFactory.newTemplates((TransformerFactory)transformerFactory, (IReadableResource)new ClassPathResource(XSLT2_STEP2, classLoader));
            if (s_aStep2 == null) {
                throw new IllegalStateException("Failed to compile 'external/schematron/20100710-xslt2/iso_abstract_expand.xsl'");
            }
            SchematronDebug.getDebugLogger().info("Finished creating XSLT step 2 template");
            if (Thread.interrupted()) {
                throw new SchematronInterruptedException("after cached XSLT step 2");
            }
        }
        if (s_aStep3 == null) {
            SchematronDebug.getDebugLogger().info("Creating XSLT step 3 template");
            s_aStep3 = XMLTransformerFactory.newTemplates((TransformerFactory)transformerFactory, (IReadableResource)new ClassPathResource(XSLT2_STEP3, classLoader));
            if (s_aStep3 == null) {
                throw new IllegalStateException("Failed to compile 'external/schematron/20100710-xslt2/iso_svrl_for_xslt2.xsl'");
            }
            SchematronDebug.getDebugLogger().info("Finished creating XSLT step 3 template");
            if (Thread.interrupted()) {
                throw new SchematronInterruptedException("after cached XSLT step 3");
            }
        }
    }

    @Nonnull
    public static Document createSchematronXSLT(@Nonnull IReadableResource iReadableResource, @Nonnull TransformerCustomizerSCH transformerCustomizerSCH) throws TransformerException {
        Object object;
        String string;
        Object object2;
        if (Thread.interrupted()) {
            throw new SchematronInterruptedException("before XSLT starts");
        }
        SchematronProviderXSLTFromSCH.cacheXSLTTemplates();
        Document document = XMLFactory.newDocument();
        Object object3 = StopWatch.createdStarted();
        Object object4 = new DOMResult(document);
        Object object5 = s_aStep1.newTransformer();
        transformerCustomizerSCH.customize(EStepSCH.SCH2XSLT_1, (Transformer)object5);
        StreamSource streamSource = TransformSourceFactory.create((IReadableResource)iReadableResource);
        SchematronDebug.getDebugLogger().info(() -> "Now applying XSLT step 1 on " + String.valueOf(iReadableResource));
        ((Transformer)object5).transform(streamSource, (Result)object4);
        object3.stop();
        SchematronDebug.getDebugLogger().info(() -> SchematronProviderXSLTFromSCH.lambda$createSchematronXSLT$1(iReadableResource, (StopWatch)object3));
        if (Thread.interrupted()) {
            throw new SchematronInterruptedException("after XSLT step 1");
        }
        object3 = XMLFactory.newDocument();
        object4 = StopWatch.createdStarted();
        object5 = new DOMResult((Node)object3);
        Object object6 = s_aStep2.newTransformer();
        transformerCustomizerSCH.customize(EStepSCH.SCH2XSLT_2, (Transformer)object6);
        Object object7 = TransformSourceFactory.create((Node)document);
        if (((DOMSource)object7).getSystemId() == null) {
            ((DOMSource)object7).setSystemId(streamSource.getSystemId());
        }
        SchematronDebug.getDebugLogger().info(() -> "Now applying XSLT step 2 on " + String.valueOf(iReadableResource));
        ((Transformer)object6).transform((Source)object7, (Result)object5);
        object4.stop();
        SchematronDebug.getDebugLogger().info(() -> SchematronProviderXSLTFromSCH.lambda$createSchematronXSLT$3(iReadableResource, (StopWatch)object4));
        if (SchematronDebug.isSaveIntermediateXSLTFiles()) {
            object2 = XMLWriter.getNodeAsString((Node)object3);
            string = FilenameHelper.getWithoutPath((String)iReadableResource.getPath());
            if (StringHelper.isEmpty((String)string)) {
                string = "in-memory";
            }
            object = new File(SchematronDebug.getIntermediateMinifiedSCHFolder(), string + ".min-xslt.sch");
            SchematronDebug.getDebugLogger().info(() -> SchematronProviderXSLTFromSCH.lambda$createSchematronXSLT$4((File)object));
            if (SimpleFileIO.writeFile((File)object, (String)object2, (Charset)XMLWriterSettings.DEFAULT_XML_CHARSET_OBJ).isSuccess()) {
                LOGGER.info("Successfully wrote intermediate XSLT file '" + ((File)object).getAbsolutePath() + "'");
            } else {
                LOGGER.error("Failed to wrote intermediate XSLT file '" + ((File)object).getAbsolutePath() + "'");
            }
        }
        if (Thread.interrupted()) {
            throw new SchematronInterruptedException("after XSLT step 2");
        }
        object4 = XMLFactory.newDocument();
        object5 = StopWatch.createdStarted();
        object6 = new DOMResult((Node)object4);
        object7 = s_aStep3.newTransformer();
        transformerCustomizerSCH.customize(EStepSCH.SCH2XSLT_3, (Transformer)object7);
        object2 = TransformSourceFactory.create((Node)object3);
        if (((DOMSource)object2).getSystemId() == null) {
            ((DOMSource)object2).setSystemId(streamSource.getSystemId());
        }
        SchematronDebug.getDebugLogger().info(() -> "Now applying XSLT step 3 on " + String.valueOf(iReadableResource));
        ((Transformer)object7).transform((Source)object2, (Result)object6);
        object5.stop();
        SchematronDebug.getDebugLogger().info(() -> SchematronProviderXSLTFromSCH.lambda$createSchematronXSLT$6(iReadableResource, (StopWatch)object5));
        if (SchematronDebug.isSaveIntermediateXSLTFiles()) {
            string = XMLWriter.getNodeAsString((Node)object4);
            object = FilenameHelper.getWithoutPath((String)iReadableResource.getPath());
            if (StringHelper.isEmpty((String)object)) {
                object = "in-memory";
            }
            File file = new File(SchematronDebug.getIntermediateFinalXSLTFolder(), (String)object + ".xslt");
            SchematronDebug.getDebugLogger().info(() -> "Storing intermediate XSLT file to '" + file.getAbsolutePath() + "'");
            if (SimpleFileIO.writeFile((File)file, (String)string, (Charset)XMLWriterSettings.DEFAULT_XML_CHARSET_OBJ).isSuccess()) {
                LOGGER.info("Successfully wrote intermediate XSLT file '" + file.getAbsolutePath() + "'");
            } else {
                LOGGER.error("Failed to wrote intermediate XSLT file '" + file.getAbsolutePath() + "'");
            }
        }
        if (Thread.interrupted()) {
            throw new SchematronInterruptedException("after XSLT step 3");
        }
        return object4;
    }

    protected SchematronProviderXSLTFromSCH(@Nonnull IReadableResource iReadableResource, @Nonnull TransformerCustomizerSCH transformerCustomizerSCH) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"SchematronResource");
        ValueEnforcer.notNull((Object)transformerCustomizerSCH, (String)"TransformerCustomizer");
        this.m_aSchematronResource = iReadableResource;
        this.m_aTransformerCustomizer = transformerCustomizerSCH;
    }

    public void convertSchematronToXSLT() {
        if (this.m_aSchematronXSLTDoc != null) {
            throw new IllegalStateException("The conversion from Schematron to XSLT already happened");
        }
        try {
            this.m_aSchematronXSLTDoc = SchematronProviderXSLTFromSCH.createSchematronXSLT(this.m_aSchematronResource, this.m_aTransformerCustomizer);
            TransformerFactory transformerFactory = SchematronTransformerFactory.getDefaultSaxonFirst();
            this.m_aTransformerCustomizer.customize(transformerFactory);
            this.m_aSchematronXSLTTemplates = XMLTransformerFactory.newTemplates((TransformerFactory)transformerFactory, (Source)TransformSourceFactory.create((Node)this.m_aSchematronXSLTDoc));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Finished creating XSLT Template on " + String.valueOf(this.m_aSchematronResource));
            }
        }
        catch (SchematronInterruptedException schematronInterruptedException) {
            throw schematronInterruptedException;
        }
        catch (Exception exception) {
            LOGGER.error("Schematron preprocessor error", (Throwable)exception);
        }
        if (Thread.interrupted()) {
            throw new SchematronInterruptedException("after XSLT template was created");
        }
    }

    @Nonnull
    public final IReadableResource getSchematronResource() {
        return this.m_aSchematronResource;
    }

    public boolean isValidSchematron() {
        return this.m_aSchematronXSLTTemplates != null;
    }

    @Nullable
    public final Document getXSLTDocument() {
        return this.m_aSchematronXSLTDoc;
    }

    @Nullable
    public Transformer getXSLTTransformer() throws TransformerConfigurationException {
        return this.m_aSchematronXSLTTemplates == null ? null : this.m_aSchematronXSLTTemplates.newTransformer();
    }

    private static /* synthetic */ String lambda$createSchematronXSLT$6(IReadableResource iReadableResource, StopWatch stopWatch) {
        return "Finished applying XSLT step 3 on " + String.valueOf(iReadableResource) + " after " + stopWatch.getMillis() + "ms";
    }

    private static /* synthetic */ String lambda$createSchematronXSLT$4(File file) {
        return "Storing intermediate XSLT file to '" + file.getAbsolutePath() + "'";
    }

    private static /* synthetic */ String lambda$createSchematronXSLT$3(IReadableResource iReadableResource, StopWatch stopWatch) {
        return "Finished applying XSLT step 2 on " + String.valueOf(iReadableResource) + " after " + stopWatch.getMillis() + "ms";
    }

    private static /* synthetic */ String lambda$createSchematronXSLT$1(IReadableResource iReadableResource, StopWatch stopWatch) {
        return "Finished applying XSLT step 1 on " + String.valueOf(iReadableResource) + " after " + stopWatch.getMillis() + "ms";
    }
}

