/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.sch;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.OverrideOnDemand;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.io.resource.ClassPathResource;
import com.helger.io.resource.FileSystemResource;
import com.helger.io.resource.IReadableResource;
import com.helger.io.resource.URLResource;
import com.helger.io.resource.inmemory.ReadableResourceByteArray;
import com.helger.io.resource.inmemory.ReadableResourceInputStream;
import com.helger.schematron.api.xslt.AbstractSchematronXSLTBasedResource;
import com.helger.schematron.api.xslt.ISchematronXSLTBasedProvider;
import com.helger.schematron.sch.SchematronResourceSCHCache;
import com.helger.schematron.sch.TransformerCustomizerSCH;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;

@NotThreadSafe
public class SchematronResourceSCH
extends AbstractSchematronXSLTBasedResource<SchematronResourceSCH> {
    private String m_sPhase;
    private String m_sLanguageCode;
    private boolean m_bForceCacheResult = false;

    public SchematronResourceSCH(@Nonnull IReadableResource iReadableResource) {
        super(iReadableResource);
    }

    @Nullable
    public final String getPhase() {
        return this.m_sPhase;
    }

    public final void setPhase(@Nullable String string) {
        this.m_sPhase = string;
    }

    @Nullable
    public final String getLanguageCode() {
        return this.m_sLanguageCode;
    }

    public final void setLanguageCode(@Nullable String string) {
        this.m_sLanguageCode = string;
    }

    public final boolean isForceCacheResult() {
        return this.m_bForceCacheResult;
    }

    public final void setForceCacheResult(boolean bl) {
        this.m_bForceCacheResult = bl;
    }

    @Nonnull
    protected final TransformerCustomizerSCH applyDefaultValuesOnTransformerCustomizer(@Nonnull TransformerCustomizerSCH transformerCustomizerSCH) {
        ValueEnforcer.notNull((Object)transformerCustomizerSCH, (String)"TransformerCustomizer");
        transformerCustomizerSCH.setErrorListener(this.getErrorListener()).setURIResolver(this.getURIResolver()).setParameters((Map<String, ?>)this.parameters()).setPhase(this.m_sPhase).setLanguageCode(this.m_sLanguageCode).setForceCacheResult(this.m_bForceCacheResult);
        return transformerCustomizerSCH;
    }

    @Nonnull
    @OverrideOnDemand
    protected TransformerCustomizerSCH createTransformerCustomizer() {
        return this.applyDefaultValuesOnTransformerCustomizer(new TransformerCustomizerSCH());
    }

    @Nullable
    public ISchematronXSLTBasedProvider getXSLTProvider() {
        TransformerCustomizerSCH transformerCustomizerSCH = this.createTransformerCustomizer();
        if (this.isUseCache()) {
            return SchematronResourceSCHCache.getSchematronXSLTProvider(this.getResource(), transformerCustomizerSCH);
        }
        return SchematronResourceSCHCache.createSchematronXSLTProvider(this.getResource(), transformerCustomizerSCH);
    }

    @Nonnull
    public static SchematronResourceSCH fromClassPath(@Nonnull @Nonempty String string) {
        return new SchematronResourceSCH((IReadableResource)new ClassPathResource(string));
    }

    @Nonnull
    public static SchematronResourceSCH fromClassPath(@Nonnull @Nonempty String string, @Nullable ClassLoader classLoader) {
        return new SchematronResourceSCH((IReadableResource)new ClassPathResource(string, classLoader));
    }

    @Nonnull
    public static SchematronResourceSCH fromFile(@Nonnull @Nonempty String string) {
        return new SchematronResourceSCH((IReadableResource)new FileSystemResource(string));
    }

    @Nonnull
    public static SchematronResourceSCH fromFile(@Nonnull File file) {
        return new SchematronResourceSCH((IReadableResource)new FileSystemResource(file));
    }

    @Nonnull
    public static SchematronResourceSCH fromURL(@Nonnull @Nonempty String string) throws MalformedURLException {
        return new SchematronResourceSCH((IReadableResource)new URLResource(string));
    }

    @Nonnull
    public static SchematronResourceSCH fromURL(@Nonnull URL uRL) {
        return new SchematronResourceSCH((IReadableResource)new URLResource(uRL));
    }

    @Nonnull
    public static SchematronResourceSCH fromInputStream(@Nonnull @Nonempty String string, @Nonnull InputStream inputStream) {
        return new SchematronResourceSCH((IReadableResource)new ReadableResourceInputStream(string, inputStream));
    }

    @Nonnull
    public static SchematronResourceSCH fromByteArray(@Nonnull byte[] byArray) {
        return new SchematronResourceSCH((IReadableResource)new ReadableResourceByteArray(byArray));
    }

    @Nonnull
    public static SchematronResourceSCH fromString(@Nonnull String string, @Nonnull Charset charset) {
        return SchematronResourceSCH.fromByteArray(string.getBytes(charset));
    }
}

