/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.xslt;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.io.resource.IReadableResource;
import com.helger.schematron.api.xslt.ISchematronXSLTBasedProvider;
import com.helger.schematron.saxon.SchematronTransformerFactory;
import com.helger.xml.serialize.read.DOMReader;
import com.helger.xml.transform.DefaultTransformURIResolver;
import com.helger.xml.transform.TransformSourceFactory;
import jakarta.annotation.Nullable;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@NotThreadSafe
public class SchematronProviderXSLTPrebuild
implements ISchematronXSLTBasedProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchematronProviderXSLTPrebuild.class);
    private Document m_aSchematronXSLTDoc;
    private Templates m_aSchematronXSLTTemplates;

    public SchematronProviderXSLTPrebuild(@Nullable IReadableResource iReadableResource, @Nullable ErrorListener errorListener, @Nullable URIResolver uRIResolver) {
        try {
            this.m_aSchematronXSLTDoc = DOMReader.readXMLDOM((IReadableResource)iReadableResource);
            TransformerFactory transformerFactory = SchematronTransformerFactory.createTransformerFactorySaxonFirst((ClassLoader)SchematronProviderXSLTPrebuild.class.getClassLoader(), (ErrorListener)errorListener, (URIResolver)new DefaultTransformURIResolver(uRIResolver));
            this.m_aSchematronXSLTTemplates = transformerFactory.newTemplates(TransformSourceFactory.create((Node)this.m_aSchematronXSLTDoc));
        }
        catch (Exception exception) {
            LOGGER.error("XSLT read/compilation error for " + String.valueOf(iReadableResource), (Throwable)exception);
        }
    }

    public boolean isValidSchematron() {
        return this.m_aSchematronXSLTTemplates != null;
    }

    @Nullable
    public Document getXSLTDocument() {
        return this.m_aSchematronXSLTDoc;
    }

    @Nullable
    public Transformer getXSLTTransformer() throws TransformerConfigurationException {
        return this.m_aSchematronXSLTTemplates == null ? null : this.m_aSchematronXSLTTemplates.newTransformer();
    }
}

