/*
 * Decompiled with CFR 0.152.
 */
package com.helger.dns.resolve;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.dns.config.DNSConfig;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.function.Consumer;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.SimpleResolver;

@Immutable
public final class ResolverHelper {
    private ResolverHelper() {
    }

    public static void defaultCustomizeResolver(@Nonnull Resolver resolver) {
        resolver.setTimeout(DNSConfig.getResolverTimeout());
    }

    public static void defaultCustomizeExtendedResolver(@Nonnull ExtendedResolver extendedResolver) {
        ResolverHelper.defaultCustomizeResolver((Resolver)extendedResolver);
        extendedResolver.setRetries(DNSConfig.getResolverRetryCount());
    }

    public static void forEachDefaultResolver(@Nonnull Consumer<? super SimpleResolver> consumer) {
        ValueEnforcer.notNull(consumer, (String)"Consumer");
        for (InetSocketAddress inetSocketAddress : ResolverConfig.getCurrentConfig().servers()) {
            if (inetSocketAddress == null) continue;
            SimpleResolver simpleResolver = new SimpleResolver(inetSocketAddress);
            ResolverHelper.defaultCustomizeResolver((Resolver)simpleResolver);
            consumer.accept((SimpleResolver)simpleResolver);
        }
    }

    public static void forEachResolver(@Nullable Iterable<? extends InetAddress> iterable, @Nonnull Consumer<? super SimpleResolver> consumer) {
        if (iterable != null) {
            for (InetAddress inetAddress : iterable) {
                if (inetAddress == null) continue;
                SimpleResolver simpleResolver = new SimpleResolver(inetAddress);
                ResolverHelper.defaultCustomizeResolver((Resolver)simpleResolver);
                consumer.accept((SimpleResolver)simpleResolver);
            }
        }
    }

    private static boolean _isContained(ICommonsList<Resolver> iCommonsList, SimpleResolver simpleResolver) {
        InetSocketAddress inetSocketAddress = simpleResolver.getAddress();
        return iCommonsList.containsAny(resolver -> ((SimpleResolver)resolver).getAddress().equals(inetSocketAddress));
    }

    @Nonnull
    public static ExtendedResolver createExtendedResolver(@Nullable Iterable<? extends InetAddress> iterable) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        ResolverHelper.forEachResolver(iterable, arg_0 -> ResolverHelper.lambda$createExtendedResolver$1((ICommonsList)commonsArrayList, arg_0));
        ResolverHelper.forEachDefaultResolver(arg_0 -> ResolverHelper.lambda$createExtendedResolver$2((ICommonsList)commonsArrayList, arg_0));
        ExtendedResolver extendedResolver = new ExtendedResolver((Iterable)commonsArrayList);
        ResolverHelper.defaultCustomizeExtendedResolver(extendedResolver);
        return extendedResolver;
    }

    private static /* synthetic */ void lambda$createExtendedResolver$2(ICommonsList iCommonsList, SimpleResolver simpleResolver) {
        if (!ResolverHelper._isContained((ICommonsList<Resolver>)iCommonsList, simpleResolver)) {
            iCommonsList.add((Object)simpleResolver);
        }
    }

    private static /* synthetic */ void lambda$createExtendedResolver$1(ICommonsList iCommonsList, SimpleResolver simpleResolver) {
        if (!ResolverHelper._isContained((ICommonsList<Resolver>)iCommonsList, simpleResolver)) {
            iCommonsList.add((Object)simpleResolver);
        }
    }
}

