/*
 * Decompiled with CFR 0.152.
 */
package com.helger.network.networkinterface;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsCollection;
import com.helger.collection.hierarchy.IChildrenProvider;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.NetworkInterface;
import java.util.Enumeration;

@Immutable
public class ChildrenProviderNetworkInterface
implements IChildrenProvider<NetworkInterface> {
    public boolean hasChildren(@Nonnull NetworkInterface networkInterface) {
        return networkInterface.getSubInterfaces().hasMoreElements();
    }

    @Nonnegative
    public int getChildCount(@Nonnull NetworkInterface networkInterface) {
        return CollectionHelper.getSize(networkInterface.getSubInterfaces());
    }

    @Nullable
    public ICommonsCollection<NetworkInterface> getAllChildren(@Nonnull NetworkInterface networkInterface) {
        Enumeration<NetworkInterface> enumeration = networkInterface.getSubInterfaces();
        return enumeration.hasMoreElements() ? new CommonsArrayList(enumeration) : null;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }
}

