/*
 * Decompiled with CFR 0.152.
 */
package com.helger.network.proxy.settings;

import com.helger.base.CGlobal;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.string.StringHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketAddress;

public interface IProxySettings {
    @Nonnull
    public Proxy.Type getProxyType();

    @Nullable
    public String getProxyHost();

    public int getProxyPort();

    @Nullable
    public String getProxyUserName();

    default public boolean hasProxyUserName() {
        return StringHelper.isNotEmpty((String)this.getProxyUserName());
    }

    @Nullable
    public String getProxyPassword();

    default public boolean hasProxyPassword() {
        return this.getProxyPassword() != null;
    }

    default public boolean hasInetSocketAddress(@Nullable InetSocketAddress inetSocketAddress) {
        return inetSocketAddress != null && EqualsHelper.equals((Object)inetSocketAddress.getHostString(), (Object)this.getProxyHost()) && this.getProxyPort() == inetSocketAddress.getPort();
    }

    public boolean hasSocketAddress(@Nullable SocketAddress var1);

    @Nonnull
    default public Proxy getAsProxy() {
        return this.getAsProxy(true);
    }

    @Nonnull
    public Proxy getAsProxy(boolean var1);

    @Nullable
    default public PasswordAuthentication getAsPasswordAuthentication() {
        if (!this.hasProxyUserName()) {
            return null;
        }
        String string = this.getProxyPassword();
        return new PasswordAuthentication(this.getProxyUserName(), string == null ? CGlobal.EMPTY_CHAR_ARRAY : string.toCharArray());
    }
}

