/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.mock;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.array.ArrayHelper;
import com.helger.base.charset.CharsetHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.nonblocking.NonBlockingByteArrayOutputStream;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.string.StringHelper;
import com.helger.base.system.SystemHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.collection.commons.ICommonsSet;
import com.helger.http.header.HttpHeaderMap;
import com.helger.mime.IMimeType;
import com.helger.mime.MimeType;
import com.helger.mime.MimeTypeHelper;
import com.helger.mime.parse.MimeTypeParser;
import com.helger.mime.parse.MimeTypeParserException;
import com.helger.network.port.SchemeDefaultPortMapper;
import com.helger.servlet.io.AbstractServletOutputStream;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class MockHttpServletResponse
implements HttpServletResponse {
    public static final int DEFAULT_SERVER_PORT = SchemeDefaultPortMapper.getDefaultPortOrThrow((String)"http");
    public static final Charset DEFAULT_CHARSET_OBJ = StandardCharsets.UTF_8;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final Logger LOGGER = LoggerFactory.getLogger(MockHttpServletResponse.class);
    private boolean m_bOutputStreamAccessAllowed = true;
    private boolean m_bWriterAccessAllowed = true;
    private Charset m_aCharacterEncoding = DEFAULT_CHARSET_OBJ;
    private final NonBlockingByteArrayOutputStream m_aContent = new NonBlockingByteArrayOutputStream();
    private final ServletOutputStream m_aOS = new AbstractServletOutputStream(){

        public void write(int n) throws IOException {
            MockHttpServletResponse.this.m_aContent.write(n);
            super.flush();
            MockHttpServletResponse.this._setCommittedIfBufferSizeExceeded();
        }

        public void flush() throws IOException {
            super.flush();
            MockHttpServletResponse.this.setCommitted(true);
        }
    };
    private PrintWriter m_aWriter;
    private long m_nContentLength = 0L;
    private String m_sContentType;
    private int m_nBufferSize = 4096;
    private boolean m_bCommitted;
    private Locale m_aLocale = Locale.getDefault();
    private final ICommonsList<Cookie> m_aCookies = new CommonsArrayList();
    private final HttpHeaderMap m_aHeaders = new HttpHeaderMap();
    private int m_nStatus = 200;
    private String m_sErrorMessage;
    private String m_sRedirectedUrl;
    private String m_sForwardedUrl;
    private String m_sIncludedUrl;
    private String m_sEncodeUrlSuffix;
    private String m_sEncodeRedirectUrlSuffix;

    public void setOutputStreamAccessAllowed(boolean bl) {
        this.m_bOutputStreamAccessAllowed = bl;
    }

    public boolean isOutputStreamAccessAllowed() {
        return this.m_bOutputStreamAccessAllowed;
    }

    public void setWriterAccessAllowed(boolean bl) {
        this.m_bWriterAccessAllowed = bl;
    }

    public boolean isWriterAccessAllowed() {
        return this.m_bWriterAccessAllowed;
    }

    public void setCharacterEncoding(@Nullable String string) {
        this.setCharacterEncoding(CharsetHelper.getCharsetFromNameOrNull((String)string));
    }

    public void setCharacterEncoding(@Nullable Charset charset) {
        this.m_aCharacterEncoding = charset;
    }

    @Nullable
    public String getCharacterEncoding() {
        return this.m_aCharacterEncoding == null ? null : this.m_aCharacterEncoding.name();
    }

    @Nullable
    public Charset getCharacterEncodingObj() {
        return this.m_aCharacterEncoding;
    }

    @Nonnull
    public Charset getCharacterEncodingObjOrDefault() {
        Charset charset = this.getCharacterEncodingObj();
        if (charset == null) {
            charset = SystemHelper.getSystemCharset();
        }
        return charset;
    }

    @Nonnull
    public ServletOutputStream getOutputStream() {
        if (!this.m_bOutputStreamAccessAllowed) {
            throw new IllegalStateException("OutputStream access not allowed");
        }
        return this.m_aOS;
    }

    @Nonnull
    public PrintWriter getWriter() {
        if (!this.m_bWriterAccessAllowed) {
            throw new IllegalStateException("Writer access not allowed");
        }
        if (this.m_aWriter == null) {
            OutputStreamWriter outputStreamWriter = StreamHelper.createWriter((OutputStream)this.m_aContent, (Charset)this.getCharacterEncodingObjOrDefault());
            this.m_aWriter = new ResponsePrintWriter(outputStreamWriter);
        }
        return this.m_aWriter;
    }

    @Nonnull
    @ReturnsMutableCopy
    public byte[] getContentAsByteArray() {
        this.flushBuffer();
        return this.m_aContent.toByteArray();
    }

    @Nonnull
    public String getContentAsString(@Nonnull Charset charset) {
        this.flushBuffer();
        return this.m_aContent.getAsString(charset);
    }

    public void setContentLength(int n) {
        this.m_nContentLength = n;
    }

    public int getContentLength() {
        return (int)this.m_nContentLength;
    }

    public void setContentType(@Nullable String string) {
        this.m_sContentType = string;
        if (string != null) {
            try {
                MimeType mimeType = MimeTypeParser.parseMimeType((String)string);
                String string2 = MimeTypeHelper.getCharsetNameFromMimeType((IMimeType)mimeType);
                if (string2 != null) {
                    this.setCharacterEncoding(string2);
                }
            }
            catch (MimeTypeParserException mimeTypeParserException) {
                LOGGER.warn("Passed content type '" + string + "' cannot be parsed as a MIME type");
            }
        }
    }

    @Nullable
    public String getContentType() {
        return this.m_sContentType;
    }

    public void setBufferSize(int n) {
        this.m_nBufferSize = n;
    }

    public int getBufferSize() {
        return this.m_nBufferSize;
    }

    public void flushBuffer() {
        this.setCommitted(true);
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Cannot reset buffer - response is already committed");
        }
        this.m_aContent.reset();
        this.m_aWriter = null;
    }

    private void _setCommittedIfBufferSizeExceeded() {
        int n = this.getBufferSize();
        if (n > 0 && this.m_aContent.size() > n) {
            this.setCommitted(true);
        }
    }

    public void setCommitted(boolean bl) {
        this.m_bCommitted = bl;
    }

    public boolean isCommitted() {
        return this.m_bCommitted;
    }

    public void reset() {
        this.resetBuffer();
        this.m_aCharacterEncoding = null;
        this.m_nContentLength = 0L;
        this.m_sContentType = null;
        this.m_aLocale = null;
        this.m_aCookies.clear();
        this.m_aHeaders.removeAll();
        this.m_nStatus = 200;
        this.m_sErrorMessage = null;
    }

    public void setLocale(@Nullable Locale locale) {
        this.m_aLocale = locale;
    }

    @Nullable
    public Locale getLocale() {
        return this.m_aLocale;
    }

    public void addCookie(@Nonnull Cookie cookie) {
        ValueEnforcer.notNull((Object)cookie, (String)"Cookie");
        this.m_aCookies.add((Object)cookie);
    }

    @Nonnull
    @ReturnsMutableCopy
    public Cookie[] getCookies() {
        return (Cookie[])ArrayHelper.createArray(this.m_aCookies, Cookie.class);
    }

    @Nullable
    public Cookie getCookie(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Name");
        for (Cookie cookie : this.m_aCookies) {
            if (!string.equals(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    public boolean containsHeader(@Nullable String string) {
        return this.m_aHeaders.containsHeaders(string);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<String> getHeaderNames() {
        return this.m_aHeaders.getAllHeaderNames();
    }

    @Nullable
    public String getHeader(@Nullable String string) {
        ICommonsList iCommonsList = this.m_aHeaders.getAllHeaderValues(string);
        return iCommonsList == null ? null : (String)iCommonsList.getFirstOrNull();
    }

    @Nonnull
    public ICommonsList<String> getHeaders(@Nullable String string) {
        return this.m_aHeaders.getAllHeaderValues(string);
    }

    @Nullable
    public String encodeURL(@Nullable String string) {
        if (StringHelper.isNotEmpty((String)this.m_sEncodeUrlSuffix)) {
            return StringHelper.getNotNull((String)string) + this.m_sEncodeUrlSuffix;
        }
        return string;
    }

    @Nullable
    public String encodeRedirectURL(@Nullable String string) {
        if (StringHelper.isNotEmpty((String)this.m_sEncodeRedirectUrlSuffix)) {
            return StringHelper.getNotNull((String)string) + this.m_sEncodeRedirectUrlSuffix;
        }
        return string;
    }

    @Deprecated(forRemoval=false)
    public String encodeUrl(@Nullable String string) {
        return this.encodeURL(string);
    }

    @Deprecated(forRemoval=false)
    public String encodeRedirectUrl(@Nullable String string) {
        return this.encodeRedirectURL(string);
    }

    public void sendError(int n, @Nullable String string) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Cannot set error status - response is already committed");
        }
        this.m_nStatus = n;
        this.m_sErrorMessage = string;
        this.setCommitted(true);
    }

    public void sendError(int n) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Cannot set error status - response is already committed");
        }
        this.m_nStatus = n;
        this.setCommitted(true);
    }

    public void sendRedirect(@Nonnull String string) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Cannot send redirect - response is already committed");
        }
        ValueEnforcer.notNull((Object)string, (String)"URL");
        this.m_sRedirectedUrl = string;
        this.setCommitted(true);
    }

    @Nullable
    public String getRedirectedUrl() {
        return this.m_sRedirectedUrl;
    }

    public void setDateHeader(@Nullable String string, long l) {
        this._setHeaderValue(string, Long.toString(l));
    }

    public void addDateHeader(@Nullable String string, long l) {
        this._addHeaderValue(string, Long.toString(l));
    }

    public void setHeader(@Nullable String string, @Nullable String string2) {
        this._setHeaderValue(string, string2);
    }

    public void addHeader(@Nullable String string, @Nullable String string2) {
        this._addHeaderValue(string, string2);
    }

    public void setIntHeader(@Nullable String string, int n) {
        this._setHeaderValue(string, Integer.toString(n));
    }

    public void addIntHeader(@Nullable String string, int n) {
        this._addHeaderValue(string, Integer.toString(n));
    }

    private void _setHeaderValue(@Nullable String string, @Nullable String string2) {
        this._doAddHeaderValue(string, string2, true);
    }

    private void _addHeaderValue(@Nullable String string, @Nullable String string2) {
        this._doAddHeaderValue(string, string2, false);
    }

    private void _doAddHeaderValue(@Nullable String string, @Nullable String string2, boolean bl) {
        if (bl || !this.m_aHeaders.containsHeaders(string)) {
            this.m_aHeaders.addHeader(string, string2);
        }
    }

    public void setStatus(int n) {
        this.m_nStatus = n;
    }

    @Deprecated(forRemoval=false)
    public void setStatus(int n, @Nullable String string) {
        this.m_nStatus = n;
        this.m_sErrorMessage = string;
    }

    public int getStatus() {
        return this.m_nStatus;
    }

    @Nullable
    public String getErrorMessage() {
        return this.m_sErrorMessage;
    }

    public void setForwardedUrl(@Nullable String string) {
        this.m_sForwardedUrl = string;
    }

    @Nullable
    public String getForwardedUrl() {
        return this.m_sForwardedUrl;
    }

    public void setIncludedUrl(@Nullable String string) {
        this.m_sIncludedUrl = string;
    }

    @Nullable
    public String getIncludedUrl() {
        return this.m_sIncludedUrl;
    }

    public void setEncodeUrlSuffix(@Nullable String string) {
        this.m_sEncodeUrlSuffix = string;
    }

    @Nullable
    public String getEncodeUrlSuffix() {
        return this.m_sEncodeUrlSuffix;
    }

    public void setEncodeRedirectUrlSuffix(@Nullable String string) {
        this.m_sEncodeRedirectUrlSuffix = string;
    }

    @Nullable
    public String getEncodeRedirectUrlSuffix() {
        return this.m_sEncodeRedirectUrlSuffix;
    }

    public void setContentLengthLong(long l) {
        this.m_nContentLength = l;
    }

    private class ResponsePrintWriter
    extends PrintWriter {
        public ResponsePrintWriter(Writer writer) {
            super(writer, true);
        }

        @Override
        public void write(char[] cArray, int n, int n2) {
            super.write(cArray, n, n2);
            super.flush();
            MockHttpServletResponse.this._setCommittedIfBufferSizeExceeded();
        }

        @Override
        public void write(String string, int n, int n2) {
            super.write(string, n, n2);
            super.flush();
            MockHttpServletResponse.this._setCommittedIfBufferSizeExceeded();
        }

        @Override
        public void write(int n) {
            super.write(n);
            super.flush();
            MockHttpServletResponse.this._setCommittedIfBufferSizeExceeded();
        }

        @Override
        public void flush() {
            super.flush();
            MockHttpServletResponse.this.setCommitted(true);
        }
    }
}

