/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.response;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.http.header.HttpHeaderMap;
import com.helger.http.header.specific.AcceptEncodingList;
import com.helger.servlet.request.RequestHelper;
import com.helger.servlet.response.EResponseStreamType;
import com.helger.servlet.response.ResponseHelperSettings;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

@Immutable
public final class ResponseHelper {
    private static final ResponseHelper INSTANCE = new ResponseHelper();

    private ResponseHelper() {
    }

    @Nonnull
    public static EResponseStreamType getBestSuitableOutputStreamType(@Nonnull HttpServletRequest httpServletRequest) {
        if (ResponseHelperSettings.isResponseCompressionEnabled()) {
            AcceptEncodingList acceptEncodingList = RequestHelper.getAcceptEncodings(httpServletRequest);
            if (ResponseHelperSettings.isResponseGzipEnabled() && acceptEncodingList.getUsedGZIPEncoding() != null) {
                return EResponseStreamType.GZIP;
            }
            if (ResponseHelperSettings.isResponseDeflateEnabled() && acceptEncodingList.getUsedDeflateEncoding() != null) {
                return EResponseStreamType.DEFLATE;
            }
        }
        return EResponseStreamType.PLAIN;
    }

    @Nonnull
    public static OutputStream getBestSuitableOutputStream(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse) throws IOException {
        Object object = httpServletResponse.getOutputStream();
        if (ResponseHelperSettings.isResponseCompressionEnabled()) {
            AcceptEncodingList acceptEncodingList = RequestHelper.getAcceptEncodings(httpServletRequest);
            httpServletResponse.setHeader("Vary", "Accept-Encoding");
            String string = acceptEncodingList.getUsedGZIPEncoding();
            if (string != null && ResponseHelperSettings.isResponseGzipEnabled()) {
                httpServletResponse.setHeader("Content-Encoding", string);
                object = new GZIPOutputStream((OutputStream)httpServletResponse.getOutputStream());
            } else {
                String string2 = acceptEncodingList.getUsedDeflateEncoding();
                if (string2 != null && ResponseHelperSettings.isResponseDeflateEnabled()) {
                    httpServletResponse.setHeader("Content-Encoding", string2);
                    object = new ZipOutputStream((OutputStream)httpServletResponse.getOutputStream());
                    ((ZipOutputStream)object).putNextEntry(new ZipEntry("dummy name"));
                }
            }
        }
        return object;
    }

    public static void finishReponseOutputStream(@Nonnull OutputStream outputStream) throws IOException {
        ValueEnforcer.notNull((Object)outputStream, (String)"OutputStream");
        outputStream.flush();
        outputStream.close();
    }

    public static boolean isEmptyStatusCode(int n) {
        return n == 202 || n == 204 || n == 301 || n == 302 || n == 303 || n == 304;
    }

    public static void setContentLength(@Nonnull HttpServletResponse httpServletResponse, @Nonnegative long l) {
        if (l < Integer.MAX_VALUE) {
            httpServletResponse.setContentLength((int)l);
        } else {
            httpServletResponse.setHeader("Content-Length", Long.toString(l));
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public static HttpHeaderMap getResponseHeaderMap(@Nonnull HttpServletResponse httpServletResponse) {
        ValueEnforcer.notNull((Object)httpServletResponse, (String)"HttpResponse");
        HttpHeaderMap httpHeaderMap = new HttpHeaderMap();
        for (String string : httpServletResponse.getHeaderNames()) {
            for (String string2 : httpServletResponse.getHeaders(string)) {
                httpHeaderMap.addHeader(string, string2);
            }
        }
        return httpHeaderMap;
    }
}

